/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.mapper.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.mapper.MapperInvoke;
import org.beetl.sql.mapper.builder.BaseMapperConfigBuilder;
import org.beetl.sql.mapper.proxy.MapperProxy;
import org.beetl.sql.mapper.proxy.MapperProxyExecutor;
import org.beetl.sql.mapper.proxy.ProxyContext;

public class MapperProxyConfigBuilder
extends BaseMapperConfigBuilder {
    @Override
    protected MapperInvoke wrap(MapperInvoke old, Method method) {
        Annotation config = null;
        config = BeanKit.getMethodAnnotation((Method)method, MapperProxy.class);
        if (config == null && (config = BeanKit.getClassAnnotation(method.getDeclaringClass(), MapperProxy.class)) == null) {
            return old;
        }
        MapperProxy mapperProxy = config.annotationType().getAnnotation(MapperProxy.class);
        MapperProxyExecutor executor = (MapperProxyExecutor)BeanKit.newSingleInstance(mapperProxy.value());
        MapperInvokeWrapper wrapper = new MapperInvokeWrapper(old, config, executor);
        return wrapper;
    }

    static class MapperInvokeWrapper
    extends MapperInvoke {
        MapperInvoke old;
        Annotation config;
        MapperProxyExecutor executor;

        public MapperInvokeWrapper(MapperInvoke old, Annotation config, MapperProxyExecutor executor) {
            this.old = old;
            this.config = config;
            this.executor = executor;
        }

        @Override
        public Object call(SQLManager sm, Class entityClass, Method m, Object[] args) {
            ProxyContext proxyContext = new ProxyContext();
            proxyContext.setSqlManager(sm);
            proxyContext.setMapperInvoke(this.old);
            proxyContext.setMethod(m);
            proxyContext.setConfig(this.config);
            proxyContext.setArgs(args);
            this.executor.before(proxyContext);
            Object ret = this.old.call(sm, entityClass, m, args);
            this.executor.after(proxyContext, ret);
            return ret;
        }
    }
}

