/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.demo.web;

import java.util.HashMap;
import org.beetl.sql.saga.common.SagaContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@ConditionalOnProperty(value={"spring.application.name"}, havingValue="demoSystem")
public class DemoController {
    private static final Logger log = LoggerFactory.getLogger(DemoController.class);
    @Autowired
    RestTemplateBuilder restTemplateBuilder;
    String orderAddUrl = "http://127.0.0.1:8081/order/item/{orderId}/{userId}/{fee}";
    String userBalanceUpdateUrl = "http://127.0.0.1:8082/user/fee/{orderId}/{userId}/{fee}";
    String userBalanceQueryUrl = "http://127.0.0.1:8082/user/info/{userId}";
    String userId = "xiandafu";

    @PostMapping(value={"/buy/{gid}"})
    public String buy(@PathVariable String gid) {
        RestTemplate rest = this.restTemplateBuilder.build();
        int fee = 3;
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("orderId", gid);
        paras.put("userId", this.userId);
        paras.put("fee", fee);
        String retStr = (String)rest.getForEntity(this.userBalanceQueryUrl, String.class, paras).getBody();
        Integer balance = Integer.parseInt(retStr);
        if (balance < 3) {
            throw new RuntimeException("\u4f59\u989d\u4e0d\u8db3 " + balance);
        }
        log.info("buy,order id " + gid + " balance " + balance);
        SagaContext sagaContext = SagaContext.sagaContextFactory.current();
        try {
            sagaContext.start(gid);
            rest.postForEntity(this.orderAddUrl, null, String.class, paras);
            rest.postForEntity(this.userBalanceUpdateUrl, null, String.class, paras);
            throw new RuntimeException("\u6a21\u62df\u5931\u8d25,\u67e5\u8be2saga-server \u770b\u6548\u679c");
        }
        catch (Exception e) {
            log.info("error " + e.getMessage());
            log.info("start rollback  " + e.getMessage());
            sagaContext.rollback();
            return e.getMessage();
        }
    }
}

