/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.demo.web;

import org.beetl.sql.saga.demo.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/user"})
@ConditionalOnProperty(value={"spring.application.name"}, havingValue="userSystem")
public class UserApi {
    private static final Logger log = LoggerFactory.getLogger(UserApi.class);
    @Autowired
    UserService userService;

    @PostMapping(value={"/fee/{orderId}/{userId}/{fee}"})
    public void updateBalance(@PathVariable String orderId, @PathVariable String userId, @PathVariable Integer fee) {
        log.info("update user balance " + orderId + " fee " + fee);
        this.userService.update(orderId, userId, fee);
    }

    @GetMapping(value={"/info/{userId}"})
    public String info(@PathVariable String userId) {
        int balance = this.userService.queryBalance(userId);
        log.info("query user balance " + balance);
        return String.valueOf(balance);
    }
}

