/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.demo.config;

import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.ext.DBInitHelper;
import org.beetl.sql.starter.SQLManagerCustomize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class DataSourceConfig {
    @Autowired
    ApplicationContext ctx;

    @Bean(value={"datasource"})
    public DataSource datasource(Environment env) {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(env.getProperty("spring.datasource.url"));
        ds.setUsername(env.getProperty("spring.datasource.username"));
        ds.setPassword(env.getProperty("spring.datasource.password"));
        ds.setDriverClassName(env.getProperty("spring.datasource.driver-class-name"));
        return ds;
    }

    @Bean
    public SQLManagerCustomize mySQLManagerCustomize() {
        return new SQLManagerCustomize(){

            public void customize(String sqlMangerName, SQLManager manager) {
                DBInitHelper.executeSqlScript((SQLManager)manager, (String)"db/schema.sql");
            }
        };
    }
}

