/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.saga.demo.web;

import org.beetl.sql.saga.demo.service.OrderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/order"})
@ConditionalOnProperty(value={"spring.application.name"}, havingValue="orderSystem")
public class OrderApi {
    private static final Logger log = LoggerFactory.getLogger(OrderApi.class);
    @Autowired
    OrderService orderService;

    @PostMapping(value={"/item/{orderId}/{userId}/{fee}"})
    public void updateBalance(@PathVariable String orderId, @PathVariable String userId, @PathVariable Integer fee) {
        log.info("add order item " + orderId + " fee " + fee);
        this.orderService.addOrder(orderId, userId, fee);
    }
}

