/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext.spring;

import org.beetl.sql.ext.spring.BeetlSqlClassPathScanner;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BeetlSqlScannerConfigurer
implements BeanDefinitionRegistryPostProcessor,
InitializingBean,
ApplicationContextAware,
BeanNameAware {
    protected String basePackage;
    protected String daoSuffix = "Dao";
    protected ApplicationContext applicationContext;
    protected String beanName;
    protected BeanNameGenerator nameGenerator;
    protected String sqlManagerFactoryBeanName;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        String basePackage2 = this.applicationContext.getEnvironment().resolvePlaceholders(this.basePackage);
        String[] packages = StringUtils.tokenizeToStringArray((String)basePackage2, (String)",; \t\n");
        BeetlSqlClassPathScanner scanner = new BeetlSqlClassPathScanner(registry);
        scanner.setSuffix(this.daoSuffix);
        scanner.setResourceLoader((ResourceLoader)this.applicationContext);
        scanner.setBeanNameGenerator(this.nameGenerator);
        scanner.setSqlManagerFactoryBeanName(this.sqlManagerFactoryBeanName);
        scanner.registerFilters();
        scanner.doScan(packages);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.basePackage, (String)" 'basePackage' \u5c5e\u6027\u5fc5\u987b\u914d\u7f6e");
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getDaoSuffix() {
        return this.daoSuffix;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public BeanNameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public String getSqlManagerFactoryBeanName() {
        return this.sqlManagerFactoryBeanName;
    }

    public void setDaoSuffix(String daoSuffix) {
        this.daoSuffix = daoSuffix;
    }

    public void setNameGenerator(BeanNameGenerator nameGenerator) {
        this.nameGenerator = nameGenerator;
    }

    public void setSqlManagerFactoryBeanName(String sqlManagerFactoryBeanName) {
        this.sqlManagerFactoryBeanName = sqlManagerFactoryBeanName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeetlSqlScannerConfigurer)) {
            return false;
        }
        BeetlSqlScannerConfigurer other = (BeetlSqlScannerConfigurer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$basePackage = this.getBasePackage();
        String other$basePackage = other.getBasePackage();
        if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
            return false;
        }
        String this$daoSuffix = this.getDaoSuffix();
        String other$daoSuffix = other.getDaoSuffix();
        if (this$daoSuffix == null ? other$daoSuffix != null : !this$daoSuffix.equals(other$daoSuffix)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        String this$beanName = this.getBeanName();
        String other$beanName = other.getBeanName();
        if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
            return false;
        }
        BeanNameGenerator this$nameGenerator = this.getNameGenerator();
        BeanNameGenerator other$nameGenerator = other.getNameGenerator();
        if (this$nameGenerator == null ? other$nameGenerator != null : !this$nameGenerator.equals(other$nameGenerator)) {
            return false;
        }
        String this$sqlManagerFactoryBeanName = this.getSqlManagerFactoryBeanName();
        String other$sqlManagerFactoryBeanName = other.getSqlManagerFactoryBeanName();
        return !(this$sqlManagerFactoryBeanName == null ? other$sqlManagerFactoryBeanName != null : !this$sqlManagerFactoryBeanName.equals(other$sqlManagerFactoryBeanName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeetlSqlScannerConfigurer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $basePackage = this.getBasePackage();
        result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
        String $daoSuffix = this.getDaoSuffix();
        result = result * 59 + ($daoSuffix == null ? 43 : $daoSuffix.hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        String $beanName = this.getBeanName();
        result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
        BeanNameGenerator $nameGenerator = this.getNameGenerator();
        result = result * 59 + ($nameGenerator == null ? 43 : $nameGenerator.hashCode());
        String $sqlManagerFactoryBeanName = this.getSqlManagerFactoryBeanName();
        result = result * 59 + ($sqlManagerFactoryBeanName == null ? 43 : $sqlManagerFactoryBeanName.hashCode());
        return result;
    }

    public String toString() {
        return "BeetlSqlScannerConfigurer(basePackage=" + this.getBasePackage() + ", daoSuffix=" + this.getDaoSuffix() + ", applicationContext=" + this.getApplicationContext() + ", beanName=" + this.getBeanName() + ", nameGenerator=" + this.getNameGenerator() + ", sqlManagerFactoryBeanName=" + this.getSqlManagerFactoryBeanName() + ")";
    }
}

