/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.starter;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.beetl.sql.clazz.kit.StringKit;
import org.beetl.sql.core.ConditionalSQLManager;
import org.springframework.core.env.Environment;

public class BeetlSqlConfig {
    public static final String PREFIX = "beetlsql";
    Environment env = null;
    Map<String, SQLManagerConfig> configs = new HashMap<String, SQLManagerConfig>();

    public BeetlSqlConfig(Environment env) {
        this.env = env;
        this.init();
    }

    public void init() {
        SQLManagerConfig defaultConfig = SQLManagerConfig.initDefault(this.env);
        String[] allSqlManangerNames = null;
        String oldSqlManagerConfig = this.env.getProperty(PREFIX);
        if (!StringKit.isBlank((String)oldSqlManagerConfig)) {
            allSqlManangerNames = oldSqlManagerConfig.split(",");
        } else {
            if (StringKit.isBlank((String)this.env.getProperty("beetlsql.sqlManagers"))) {
                throw new IllegalArgumentException("\u7f3a\u5c11 beetlsql.sqlManagers \u914d\u7f6e");
            }
            allSqlManangerNames = this.env.getProperty("beetlsql.sqlManagers").split(",");
        }
        for (String s : allSqlManangerNames) {
            SQLManagerConfig sqlManagerConfig = new SQLManagerConfig(this.env, s, defaultConfig);
            this.configs.put(s, sqlManagerConfig);
        }
    }

    public Environment getEnv() {
        return this.env;
    }

    public Map<String, SQLManagerConfig> getConfigs() {
        return this.configs;
    }

    public void setEnv(Environment env) {
        this.env = env;
    }

    public void setConfigs(Map<String, SQLManagerConfig> configs) {
        this.configs = configs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeetlSqlConfig)) {
            return false;
        }
        BeetlSqlConfig other = (BeetlSqlConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Environment this$env = this.getEnv();
        Environment other$env = other.getEnv();
        if (this$env == null ? other$env != null : !this$env.equals(other$env)) {
            return false;
        }
        Map<String, SQLManagerConfig> this$configs = this.getConfigs();
        Map<String, SQLManagerConfig> other$configs = other.getConfigs();
        return !(this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeetlSqlConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Environment $env = this.getEnv();
        result = result * 59 + ($env == null ? 43 : $env.hashCode());
        Map<String, SQLManagerConfig> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        return result;
    }

    public String toString() {
        return "BeetlSqlConfig(env=" + this.getEnv() + ", configs=" + this.getConfigs() + ")";
    }

    public static class SQLManagerConfig {
        String basePackage = null;
        String daoSuffix = null;
        String sqlPath = null;
        String sqlFileCharset = null;
        String nameConversion = null;
        String dbStyle = null;
        boolean dev = false;
        String ds = null;
        String dynamicSqlManager;
        String dynamicCondition;

        public SQLManagerConfig() {
        }

        public static SQLManagerConfig initDefault(Environment env) {
            String prefix = "beetlsql._default";
            String basePackage = env.getProperty(prefix + ".basePackage", "com");
            String daoSuffix = env.getProperty(prefix + ".daoSuffix", "Mapper");
            String sqlPath = env.getProperty(prefix + ".sqlPath", "sql");
            String sqlFileCharset = env.getProperty(prefix + ".sqlFileCharset", Charset.defaultCharset().name());
            String nameConversion = env.getProperty(prefix + ".nameConversion", "org.beetl.sql.core.UnderlinedNameConversion");
            String dbStyle = env.getProperty(prefix + ".dbStyle", "org.beetl.sql.core.db.MySqlStyle");
            boolean dev = (Boolean)env.getProperty(prefix + ".dev", Boolean.class, (Object)true);
            SQLManagerConfig defaultConfig = new SQLManagerConfig();
            defaultConfig.setBasePackage(basePackage);
            defaultConfig.setDaoSuffix(daoSuffix);
            defaultConfig.setSqlPath(sqlPath);
            defaultConfig.setNameConversion(nameConversion);
            defaultConfig.setDbStyle(dbStyle);
            defaultConfig.setDev(dev);
            defaultConfig.setSqlFileCharset(sqlFileCharset);
            return defaultConfig;
        }

        public SQLManagerConfig(Environment env, String sqlManagerName, SQLManagerConfig defaultConfig) {
            String prefix = "beetlsql." + sqlManagerName;
            this.dynamicSqlManager = env.getProperty(prefix + ".dynamic");
            if (!StringKit.isEmpty((String)this.dynamicSqlManager)) {
                this.dynamicCondition = env.getProperty(prefix + ".dynamic.condition");
                if (StringKit.isEmpty((String)this.dynamicCondition)) {
                    this.dynamicCondition = ConditionalSQLManager.DefaultConditional.class.getName();
                }
                this.basePackage = env.getProperty(prefix + ".basePackage", defaultConfig.getBasePackage());
                this.daoSuffix = env.getProperty(prefix + ".daoSuffix", defaultConfig.getDaoSuffix());
                this.dev = (Boolean)env.getProperty(prefix + ".dev", Boolean.class, (Object)defaultConfig.isDev());
                return;
            }
            this.basePackage = env.getProperty(prefix + ".basePackage", defaultConfig.getBasePackage());
            this.daoSuffix = env.getProperty(prefix + ".daoSuffix", defaultConfig.getDaoSuffix());
            this.sqlPath = env.getProperty(prefix + ".sqlPath", defaultConfig.getSqlPath());
            this.sqlFileCharset = env.getProperty(prefix + ".sqlFileCharset", defaultConfig.getSqlFileCharset());
            this.nameConversion = env.getProperty(prefix + ".nameConversion", defaultConfig.getNameConversion());
            this.dbStyle = env.getProperty(prefix + ".dbStyle", defaultConfig.getDbStyle());
            this.dev = (Boolean)env.getProperty(prefix + ".dev", Boolean.class, (Object)defaultConfig.isDev());
            this.ds = env.getProperty(prefix + ".ds");
            if (this.ds == null) {
                throw new NullPointerException(prefix + ".ds \u4e0d\u80fd\u4e3a\u7a7a");
            }
        }

        public String getBasePackage() {
            return this.basePackage;
        }

        public String getDaoSuffix() {
            return this.daoSuffix;
        }

        public String getSqlPath() {
            return this.sqlPath;
        }

        public String getSqlFileCharset() {
            return this.sqlFileCharset;
        }

        public String getNameConversion() {
            return this.nameConversion;
        }

        public String getDbStyle() {
            return this.dbStyle;
        }

        public boolean isDev() {
            return this.dev;
        }

        public String getDs() {
            return this.ds;
        }

        public String getDynamicSqlManager() {
            return this.dynamicSqlManager;
        }

        public String getDynamicCondition() {
            return this.dynamicCondition;
        }

        public void setBasePackage(String basePackage) {
            this.basePackage = basePackage;
        }

        public void setDaoSuffix(String daoSuffix) {
            this.daoSuffix = daoSuffix;
        }

        public void setSqlPath(String sqlPath) {
            this.sqlPath = sqlPath;
        }

        public void setSqlFileCharset(String sqlFileCharset) {
            this.sqlFileCharset = sqlFileCharset;
        }

        public void setNameConversion(String nameConversion) {
            this.nameConversion = nameConversion;
        }

        public void setDbStyle(String dbStyle) {
            this.dbStyle = dbStyle;
        }

        public void setDev(boolean dev) {
            this.dev = dev;
        }

        public void setDs(String ds) {
            this.ds = ds;
        }

        public void setDynamicSqlManager(String dynamicSqlManager) {
            this.dynamicSqlManager = dynamicSqlManager;
        }

        public void setDynamicCondition(String dynamicCondition) {
            this.dynamicCondition = dynamicCondition;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SQLManagerConfig)) {
                return false;
            }
            SQLManagerConfig other = (SQLManagerConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$basePackage = this.getBasePackage();
            String other$basePackage = other.getBasePackage();
            if (this$basePackage == null ? other$basePackage != null : !this$basePackage.equals(other$basePackage)) {
                return false;
            }
            String this$daoSuffix = this.getDaoSuffix();
            String other$daoSuffix = other.getDaoSuffix();
            if (this$daoSuffix == null ? other$daoSuffix != null : !this$daoSuffix.equals(other$daoSuffix)) {
                return false;
            }
            String this$sqlPath = this.getSqlPath();
            String other$sqlPath = other.getSqlPath();
            if (this$sqlPath == null ? other$sqlPath != null : !this$sqlPath.equals(other$sqlPath)) {
                return false;
            }
            String this$sqlFileCharset = this.getSqlFileCharset();
            String other$sqlFileCharset = other.getSqlFileCharset();
            if (this$sqlFileCharset == null ? other$sqlFileCharset != null : !this$sqlFileCharset.equals(other$sqlFileCharset)) {
                return false;
            }
            String this$nameConversion = this.getNameConversion();
            String other$nameConversion = other.getNameConversion();
            if (this$nameConversion == null ? other$nameConversion != null : !this$nameConversion.equals(other$nameConversion)) {
                return false;
            }
            String this$dbStyle = this.getDbStyle();
            String other$dbStyle = other.getDbStyle();
            if (this$dbStyle == null ? other$dbStyle != null : !this$dbStyle.equals(other$dbStyle)) {
                return false;
            }
            if (this.isDev() != other.isDev()) {
                return false;
            }
            String this$ds = this.getDs();
            String other$ds = other.getDs();
            if (this$ds == null ? other$ds != null : !this$ds.equals(other$ds)) {
                return false;
            }
            String this$dynamicSqlManager = this.getDynamicSqlManager();
            String other$dynamicSqlManager = other.getDynamicSqlManager();
            if (this$dynamicSqlManager == null ? other$dynamicSqlManager != null : !this$dynamicSqlManager.equals(other$dynamicSqlManager)) {
                return false;
            }
            String this$dynamicCondition = this.getDynamicCondition();
            String other$dynamicCondition = other.getDynamicCondition();
            return !(this$dynamicCondition == null ? other$dynamicCondition != null : !this$dynamicCondition.equals(other$dynamicCondition));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SQLManagerConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $basePackage = this.getBasePackage();
            result = result * 59 + ($basePackage == null ? 43 : $basePackage.hashCode());
            String $daoSuffix = this.getDaoSuffix();
            result = result * 59 + ($daoSuffix == null ? 43 : $daoSuffix.hashCode());
            String $sqlPath = this.getSqlPath();
            result = result * 59 + ($sqlPath == null ? 43 : $sqlPath.hashCode());
            String $sqlFileCharset = this.getSqlFileCharset();
            result = result * 59 + ($sqlFileCharset == null ? 43 : $sqlFileCharset.hashCode());
            String $nameConversion = this.getNameConversion();
            result = result * 59 + ($nameConversion == null ? 43 : $nameConversion.hashCode());
            String $dbStyle = this.getDbStyle();
            result = result * 59 + ($dbStyle == null ? 43 : $dbStyle.hashCode());
            result = result * 59 + (this.isDev() ? 79 : 97);
            String $ds = this.getDs();
            result = result * 59 + ($ds == null ? 43 : $ds.hashCode());
            String $dynamicSqlManager = this.getDynamicSqlManager();
            result = result * 59 + ($dynamicSqlManager == null ? 43 : $dynamicSqlManager.hashCode());
            String $dynamicCondition = this.getDynamicCondition();
            result = result * 59 + ($dynamicCondition == null ? 43 : $dynamicCondition.hashCode());
            return result;
        }

        public String toString() {
            return "BeetlSqlConfig.SQLManagerConfig(basePackage=" + this.getBasePackage() + ", daoSuffix=" + this.getDaoSuffix() + ", sqlPath=" + this.getSqlPath() + ", sqlFileCharset=" + this.getSqlFileCharset() + ", nameConversion=" + this.getNameConversion() + ", dbStyle=" + this.getDbStyle() + ", dev=" + this.isDev() + ", ds=" + this.getDs() + ", dynamicSqlManager=" + this.getDynamicSqlManager() + ", dynamicCondition=" + this.getDynamicCondition() + ")";
        }
    }
}

