/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.test;

import com.zaxxer.hikari.HikariDataSource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.sql.DataSource;
import org.beetl.sql.clazz.NameConversion;
import org.beetl.sql.clazz.kit.BeanKit;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLManagerBuilder;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.H2Style;
import org.beetl.sql.ext.DBInitHelper;
import org.beetl.sql.ext.DebugInterceptor;
import org.beetl.sql.test.OrderLog;
import org.beetl.sql.test.OrderLogMapper;

public class QuickTest {
    static DataSource dataSource = QuickTest.datasource();

    private static DataSource datasource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl("jdbc:h2:mem:dbtest;DB_CLOSE_ON_EXIT=FALSE");
        ds.setUsername("sa");
        ds.setPassword("");
        ds.setDriverClassName("org.h2.Driver");
        return ds;
    }

    private static SQLManager getSQLManager() {
        ConnectionSource source = ConnectionSourceHelper.getSingle((DataSource)dataSource);
        SQLManagerBuilder builder = new SQLManagerBuilder(source);
        builder.setNc((NameConversion)new UnderlinedNameConversion());
        builder.setInters(new Interceptor[]{new DebugInterceptor()});
        builder.setDbStyle((DBStyle)new H2Style());
        builder.setProduct(false);
        SQLManager sqlManager = builder.build();
        return sqlManager;
    }

    public static void main(String[] args) throws Exception {
        BeanKit.JAVABEAN_STRICT = false;
        SQLManager sqlManager = QuickTest.getSQLManager();
        DBInitHelper.executeSqlScript((SQLManager)sqlManager, (String)"db/schema.sql");
        sqlManager.query(OrderLog.class).andEq("order_id", (Object)1).select();
        OrderLog orderLog = (OrderLog)sqlManager.unique(OrderLog.class, (Object)1);
        System.out.println(orderLog);
        orderLog.setABc("effdfdf").setCreateTime(new Date());
        sqlManager.updateById((Object)orderLog);
        orderLog = (OrderLog)sqlManager.unique(OrderLog.class, (Object)1);
        System.out.println(orderLog);
        OrderLogMapper orderLogMapper = (OrderLogMapper)sqlManager.getMapper(OrderLogMapper.class);
        orderLogMapper.selectByStatus(Arrays.asList("a"));
    }

    private static Date getDate(String str) {
        SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sd.parse(str);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static DataSource mysqlDatasource() {
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(MysqlDBConfig.url);
        ds.setUsername(MysqlDBConfig.userName);
        ds.setPassword(MysqlDBConfig.password);
        ds.setDriverClassName(MysqlDBConfig.driver);
        ds.setLeakDetectionThreshold(10L);
        ds.setMaximumPoolSize(1);
        return ds;
    }

    public static class MysqlDBConfig {
        public static String driver = "com.mysql.cj.jdbc.Driver";
        public static String dbName = "test";
        public static String password = "123456";
        public static String userName = "root";
        public static String url = "jdbc:mysql://127.0.0.1:3306/" + dbName + "?&serverTimezone=GMT%2B8&useSSL=false&allowPublicKeyRetrieval=true";
    }
}

