/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.aem.aemtenantspecificvanityurls.core.model.report;

import com.adobe.granite.ui.components.ds.AbstractDataSource;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.ibm.aem.aemtenantspecificvanityurls.core.exceptions.AtsvuException;
import com.ibm.aem.aemtenantspecificvanityurls.core.model.report.ReportEntry;
import com.ibm.aem.aemtenantspecificvanityurls.core.model.report.ReportService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.injectorspecific.OSGiService;
import org.apache.sling.models.annotations.injectorspecific.SlingObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Model(adaptables={SlingHttpServletRequest.class})
public class ReportDataSource {
    private static final String ITEM_TYPE = "ibm/aem-tenant-specific-vanity-urls/tools/report/dataitem";
    public static final String ATTR_REPORT = "report";
    private static final Logger LOG = LoggerFactory.getLogger(ReportDataSource.class);
    @OSGiService
    private ReportService reportService;
    @SlingObject
    private SlingHttpServletRequest request;

    @PostConstruct
    public void setup() {
        String[] selectors = this.request.getRequestPathInfo().getSelectors();
        int offset = 0;
        int limit = 50;
        if (selectors.length > 1) {
            offset = Integer.parseInt(selectors[0]);
            limit = Integer.parseInt(selectors[1]);
        }
        ReportService.ORDER sortOrder = ReportService.ORDER.ASC;
        RequestParameter sortOrderParam = this.request.getRequestParameter("sortDir");
        if (sortOrderParam != null) {
            sortOrder = ReportService.ORDER.parse(sortOrderParam.getString());
        }
        ReportService.ORDER_ATTR sortAttr = ReportService.ORDER_ATTR.PATH;
        RequestParameter sortAttrParam = this.request.getRequestParameter("sortName");
        if (sortAttrParam != null) {
            sortAttr = ReportService.ORDER_ATTR.parse(sortAttrParam.getString());
        }
        this.request.setAttribute(DataSource.class.getName(), (Object)this.getResourceIterator(offset, limit, sortAttr, sortOrder));
    }

    private DataSource getResourceIterator(final int offset, final int limit, final ReportService.ORDER_ATTR sortAttr, final ReportService.ORDER sortOrder) {
        return new AbstractDataSource(){

            public Iterator<Resource> iterator() {
                ArrayList<ValueMapResource> entries = new ArrayList<ValueMapResource>();
                try {
                    List<ReportEntry> reportEntries = ReportDataSource.this.reportService.getVanityEntries(offset, limit + 1, sortAttr, sortOrder, ReportDataSource.this.request.getResourceResolver());
                    for (ReportEntry reportEntry : reportEntries) {
                        ValueMapDecorator vm = new ValueMapDecorator(new HashMap());
                        vm.put((Object)ReportDataSource.ATTR_REPORT, (Object)reportEntry);
                        entries.add(new ValueMapResource(ReportDataSource.this.request.getResourceResolver(), reportEntry.getPagePath(), ReportDataSource.ITEM_TYPE, (ValueMap)vm));
                    }
                }
                catch (AtsvuException e) {
                    LOG.error("Unable to read vanity URLs", (Throwable)e);
                }
                return entries.iterator();
            }
        };
    }
}

