/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.database.utils.query;

import com.ibm.fhir.database.utils.query.expression.StringExpNodeVisitor;
import com.ibm.fhir.database.utils.query.node.ExpNode;
import com.ibm.fhir.database.utils.query.node.ExpNodeVisitor;
import com.ibm.fhir.database.utils.query.node.PredicateParser;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PredicateParserTest {
    @Test
    public void expression1() {
        PredicateParser pp = new PredicateParser();
        pp.column("foo_id");
        pp.eq();
        pp.literal(Long.valueOf(1L));
        pp.add();
        pp.column("x");
        ExpNode expression = pp.parse();
        StringExpNodeVisitor visitor = new StringExpNodeVisitor();
        String exprString = (String)expression.visit((ExpNodeVisitor)visitor);
        Assert.assertEquals((String)exprString, (String)"foo_id = 1 + x");
    }

    @Test
    public void expressionParens() {
        PredicateParser pp = new PredicateParser();
        pp.column("foo_id");
        pp.eq();
        pp.leftParen();
        pp.literal(Long.valueOf(1L));
        pp.add();
        pp.column("x");
        pp.rightParen();
        ExpNode expression = pp.parse();
        StringExpNodeVisitor visitor = new StringExpNodeVisitor();
        String exprString = (String)expression.visit((ExpNodeVisitor)visitor);
        Assert.assertEquals((String)exprString, (String)"foo_id = (1 + x)");
    }

    @Test
    public void expressionLogic() {
        PredicateParser pp = new PredicateParser();
        pp.column("foo_id");
        pp.eq();
        pp.literal(Long.valueOf(1234L));
        pp.and();
        pp.column("foo_name");
        pp.eq();
        pp.column("other_name");
        pp.or();
        pp.column("something");
        pp.eq();
        pp.literal("blank");
        ExpNode expression = pp.parse();
        StringExpNodeVisitor visitor = new StringExpNodeVisitor();
        String exprString = (String)expression.visit((ExpNodeVisitor)visitor);
        Assert.assertEquals((String)exprString, (String)"foo_id = 1234 AND foo_name = other_name OR something = 'blank'");
    }

    @Test
    public void expressionLogicWithParen() {
        PredicateParser pp = new PredicateParser();
        pp.column("foo_id");
        pp.eq();
        pp.literal(Long.valueOf(1234L));
        pp.and();
        pp.leftParen();
        pp.column("foo_name");
        pp.eq();
        pp.column("other_name");
        pp.or();
        pp.column("something");
        pp.eq();
        pp.literal("blank");
        pp.rightParen();
        ExpNode expression = pp.parse();
        StringExpNodeVisitor visitor = new StringExpNodeVisitor();
        String exprString = (String)expression.visit((ExpNodeVisitor)visitor);
        Assert.assertEquals((String)exprString, (String)"foo_id = 1234 AND (foo_name = other_name OR something = 'blank')");
    }
}

