/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.database.utils.query;

import com.ibm.fhir.database.utils.api.IDatabaseTranslator;
import com.ibm.fhir.database.utils.derby.DerbyTranslator;
import com.ibm.fhir.database.utils.query.Select;
import com.ibm.fhir.database.utils.query.WhereAdapter;
import com.ibm.fhir.database.utils.query.expression.ExpressionSupport;
import com.ibm.fhir.database.utils.query.expression.StatementRenderer;
import com.ibm.fhir.database.utils.query.expression.StringStatementRenderer;
import org.testng.Assert;
import org.testng.annotations.Test;

public class QueryTest {
    private static final DerbyTranslator TRANSLATOR = new DerbyTranslator();
    public static final String FOO_TAB = "FOO_TAB";
    public static final String FOO_ID = "FOO_ID";
    public static final String FOO_NAME = "FOO_NAME";
    public static final String FOO_AGE = "FOO_AGE";
    public static final String FOO_TOWN = "FOO_TOWN";

    @Test
    public void plainQuery() {
        Select query = ((WhereAdapter)Select.select((String[])new String[]{FOO_ID, FOO_NAME, FOO_AGE}).from(FOO_TAB).where(FOO_AGE).isNotNull()).build();
        String SQL = "SELECT FOO_ID, FOO_NAME, FOO_AGE FROM FOO_TAB WHERE FOO_AGE IS NOT NULL";
        Assert.assertEquals((String)query.toString(), (String)"SELECT FOO_ID, FOO_NAME, FOO_AGE FROM FOO_TAB WHERE FOO_AGE IS NOT NULL");
    }

    @Test
    public void groupByQuery() {
        Select query = ((WhereAdapter)Select.select((String[])new String[]{FOO_TOWN, "MAX(FOO_AGE)"}).from(FOO_TAB).where(FOO_AGE).isNotNull()).groupBy(new String[]{FOO_TOWN}).having("COUNT(*) > 10").build();
        String SQL = "SELECT FOO_TOWN, MAX(FOO_AGE) FROM FOO_TAB WHERE FOO_AGE IS NOT NULL GROUP BY FOO_TOWN HAVING COUNT(*) > 10";
        Assert.assertEquals((String)query.toString(), (String)"SELECT FOO_TOWN, MAX(FOO_AGE) FROM FOO_TAB WHERE FOO_AGE IS NOT NULL GROUP BY FOO_TOWN HAVING COUNT(*) > 10");
    }

    @Test
    public void orderByQuery() {
        Select query = Select.select((String[])new String[]{FOO_ID, FOO_NAME, FOO_AGE}).from(FOO_TAB).orderBy(new String[]{FOO_ID, FOO_NAME, FOO_AGE}).build();
        String SQL = "SELECT FOO_ID, FOO_NAME, FOO_AGE FROM FOO_TAB ORDER BY FOO_ID, FOO_NAME, FOO_AGE";
        Assert.assertEquals((String)query.toString(), (String)"SELECT FOO_ID, FOO_NAME, FOO_AGE FROM FOO_TAB ORDER BY FOO_ID, FOO_NAME, FOO_AGE");
    }

    @Test
    public void fromSubQuery() {
        Select query = Select.select((String[])new String[]{"*"}).from(Select.select((String[])new String[]{FOO_ID}).from(FOO_TAB).build(), ExpressionSupport.alias((String)"sub")).build();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, null, false);
        String SQL = "SELECT * FROM (SELECT FOO_ID FROM FOO_TAB) AS sub";
        Assert.assertEquals((String)((String)query.render((StatementRenderer)renderer)), (String)"SELECT * FROM (SELECT FOO_ID FROM FOO_TAB) AS sub");
    }

    @Test
    public void complexExpression() {
        Select query = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"*"}).from(Select.select((String[])new String[]{FOO_ID}).from(FOO_TAB).build(), ExpressionSupport.alias((String)"sub")).where().col(FOO_ID)).eq(1)).or(ExpressionSupport.col((String)FOO_ID))).eq(2)).and(ExpressionSupport.col((String)FOO_NAME))).eq("alice")).build();
    }

    @Test
    public void expression2() {
        Select query = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"*"}).from(Select.select((String[])new String[]{FOO_ID}).from(FOO_TAB).build(), ExpressionSupport.alias((String)"sub")).where().col(FOO_ID)).eq(1)).and(ExpressionSupport.col((String)FOO_ID))).eq(2)).or(ExpressionSupport.col((String)FOO_NAME))).eq("alice")).build();
    }
}

