/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.fhir.database.utils.query;

import com.ibm.fhir.database.utils.api.IDatabaseTranslator;
import com.ibm.fhir.database.utils.derby.DerbyTranslator;
import com.ibm.fhir.database.utils.query.Select;
import com.ibm.fhir.database.utils.query.SelectAdapter;
import com.ibm.fhir.database.utils.query.WhereAdapter;
import com.ibm.fhir.database.utils.query.WhereFragment;
import com.ibm.fhir.database.utils.query.expression.BindMarkerNodeVisitor;
import com.ibm.fhir.database.utils.query.expression.ColumnRef;
import com.ibm.fhir.database.utils.query.expression.ExpressionSupport;
import com.ibm.fhir.database.utils.query.expression.StatementRenderer;
import com.ibm.fhir.database.utils.query.expression.StringExpNodeVisitor;
import com.ibm.fhir.database.utils.query.expression.StringStatementRenderer;
import com.ibm.fhir.database.utils.query.node.BindMarkerNode;
import com.ibm.fhir.database.utils.query.node.ColumnExpNode;
import com.ibm.fhir.database.utils.query.node.ExpNode;
import com.ibm.fhir.database.utils.query.node.ExpNodeVisitor;
import java.math.BigDecimal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SearchQueryTest {
    private static final DerbyTranslator TRANSLATOR = new DerbyTranslator();

    @Test
    public void simpleWhereTest() {
        Select select = ((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "PARAMETER_NAME_ID").eq(1274)).build();
        String SQL = "SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274";
        Assert.assertEquals((String)select.toString(), (String)"SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274");
    }

    @Test
    public void searchParameterCount() {
        Select sub1 = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "LOGICAL_RESOURCE_ID").eq("LR", "LOGICAL_RESOURCE_ID")).and("param", "TOKEN_VALUE")).eq(ExpressionSupport.bind((String)"Ford"))).and("param", "PARAMETER_NAME_ID")).eq(1274)).and("param", "CODE_SYSTEM_ID")).eq(20016)).build();
        Select sub2 = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "LOGICAL_RESOURCE_ID").eq("LR", "LOGICAL_RESOURCE_ID")).and("param", "TOKEN_VALUE")).eq(ExpressionSupport.bind((String)"Prefect"))).and("param", "PARAMETER_NAME_ID")).eq(1275)).and("param", "CODE_SYSTEM_ID")).eq(20016)).build();
        Select query = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"COUNT(LR.LOGICAL_RESOURCE_ID)"}).from("Patient_LOGICAL_RESOURCES", ExpressionSupport.alias((String)"LR")).where().exists(sub1)).and()).exists(sub2)).and("LR", "IS_DELETED")).eq()).literal("N")).and("LR", "LAST_UPDATED")).gte(ExpressionSupport.bind((Instant)Instant.now().minusSeconds(3600L)))).and("LR", "VERSION_ID")).isNotNull()).build();
        String SQL = "SELECT COUNT(LR.LOGICAL_RESOURCE_ID) FROM Patient_LOGICAL_RESOURCES AS LR WHERE EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016) AND EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1275 AND param.CODE_SYSTEM_ID = 20016) AND LR.IS_DELETED = 'N' AND LR.LAST_UPDATED >= ? AND LR.VERSION_ID IS NOT NULL";
        ArrayList bindMarkers = new ArrayList();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, bindMarkers, false);
        Assert.assertEquals((String)((String)query.render((StatementRenderer)renderer)), (String)"SELECT COUNT(LR.LOGICAL_RESOURCE_ID) FROM Patient_LOGICAL_RESOURCES AS LR WHERE EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016) AND EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1275 AND param.CODE_SYSTEM_ID = 20016) AND LR.IS_DELETED = 'N' AND LR.LAST_UPDATED >= ? AND LR.VERSION_ID IS NOT NULL");
        Assert.assertEquals((int)bindMarkers.size(), (int)3);
    }

    @Test
    public void searchParameter() {
        Select sub1 = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "LOGICAL_RESOURCE_ID").eq("LR", "LOGICAL_RESOURCE_ID")).and("param", "TOKEN_VALUE")).eq(ExpressionSupport.bind((String)"Ford"))).and("param", "PARAMETER_NAME_ID")).eq(1274)).and("param", "CODE_SYSTEM_ID")).eq(20016)).build();
        String sub1Expected = "SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016";
        Assert.assertEquals((String)sub1.toString(), (String)"SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016");
        Select sub2 = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "LOGICAL_RESOURCE_ID").eq("LR", "LOGICAL_RESOURCE_ID")).and("param", "TOKEN_VALUE")).eq(ExpressionSupport.bind((String)"Prefect"))).and("param", "PARAMETER_NAME_ID")).eq(1275)).and("param", "CODE_SYSTEM_ID")).eq(20016)).build();
        String sub2Expected = "SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1275 AND param.CODE_SYSTEM_ID = 20016";
        Assert.assertEquals((String)sub2.toString(), (String)"SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1275 AND param.CODE_SYSTEM_ID = 20016");
        Select query = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"LR.LOGICAL_RESOURCE_ID", "R.DATA", "R.VERSION_ID"}).from("Patient_LOGICAL_RESOURCES", ExpressionSupport.alias((String)"LR")).innerJoin("Patient_RESOURCES", ExpressionSupport.alias((String)"R"), (WhereFragment)ExpressionSupport.on((String)"R", (String)"RESOURCE_ID").eq("LR", "CURRENT_RESOURCE_ID")).where().exists(sub1)).and()).exists(sub2)).and("LR", "IS_DELETED")).eq()).literal("N")).and("LR", "LAST_UPDATED")).gt(ExpressionSupport.bind((Instant)Instant.now().minusSeconds(3600L)))).build();
        String SQL = "SELECT LR.LOGICAL_RESOURCE_ID, R.DATA, R.VERSION_ID FROM Patient_LOGICAL_RESOURCES AS LR INNER JOIN Patient_RESOURCES AS R ON R.RESOURCE_ID = LR.CURRENT_RESOURCE_ID WHERE EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016) AND EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1275 AND param.CODE_SYSTEM_ID = 20016) AND LR.IS_DELETED = 'N' AND LR.LAST_UPDATED > ?";
        ArrayList bindMarkers = new ArrayList();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, bindMarkers, false);
        Assert.assertEquals((String)((String)query.render((StatementRenderer)renderer)), (String)"SELECT LR.LOGICAL_RESOURCE_ID, R.DATA, R.VERSION_ID FROM Patient_LOGICAL_RESOURCES AS LR INNER JOIN Patient_RESOURCES AS R ON R.RESOURCE_ID = LR.CURRENT_RESOURCE_ID WHERE EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016) AND EXISTS (SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1275 AND param.CODE_SYSTEM_ID = 20016) AND LR.IS_DELETED = 'N' AND LR.LAST_UPDATED > ?");
        Assert.assertEquals((int)bindMarkers.size(), (int)3);
    }

    @Test
    public void multipleWhereTest() {
        Select select = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "LOGICAL_RESOURCE_ID").eq("LR", "LOGICAL_RESOURCE_ID")).where("param", "TOKEN_VALUE")).eq(ExpressionSupport.bind((String)"Ford"))).where("param", "PARAMETER_NAME_ID")).eq(1274)).where("param", "CODE_SYSTEM_ID")).eq(20016)).build();
        String SQL = "SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016";
        ArrayList bindMarkers = new ArrayList();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, bindMarkers, false);
        Assert.assertEquals((String)((String)select.render((StatementRenderer)renderer)), (String)"SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.TOKEN_VALUE = ? AND param.PARAMETER_NAME_ID = 1274 AND param.CODE_SYSTEM_ID = 20016");
        Assert.assertEquals((int)bindMarkers.size(), (int)1);
    }

    @Test
    public void testColumnExp() {
        StringExpNodeVisitor visitor = new StringExpNodeVisitor();
        ColumnExpNode c = new ColumnExpNode("LR", "LOGICAL_RESOURCE_ID");
        Assert.assertEquals((String)((String)c.visit((ExpNodeVisitor)visitor)), (String)"LR.LOGICAL_RESOURCE_ID");
    }

    @Test
    public void queryBuilderTest() {
        String resourceType = "Patient";
        String lrAliasName = "LR";
        String xxLogicalResources = "Patient_LOGICAL_RESOURCES";
        SelectAdapter query = Select.select((String[])new String[]{"COUNT(*)"});
        query.from("Patient_LOGICAL_RESOURCES", ExpressionSupport.alias((String)"LR")).where("LR", "IS_DELETED").eq(ExpressionSupport.string((String)"N"));
        String xxStrValues = "Patient_STR_VALUES";
        String paramAlias = "param";
        WhereFragment whereFragment = new WhereFragment();
        ((WhereFragment)whereFragment.col("param", "STR_VALUE")).eq(ExpressionSupport.bind((String)"MyName"));
        ExpNode filter = whereFragment.getExpression();
        Select exists = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Patient_STR_VALUES", ExpressionSupport.alias((String)"param")).where("param", "LOGICAL_RESOURCE_ID").eq("LR", "LOGICAL_RESOURCE_ID")).and("param", "PARAMETER_NAME_ID")).eq(1274L)).and(filter)).build();
        ((WhereAdapter)query.from().where().and()).exists(exists);
        ArrayList bindMarkers = new ArrayList();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, bindMarkers, false);
        Select statement = query.build();
        String rendered = (String)statement.render((StatementRenderer)renderer);
        String SQL = "SELECT COUNT(*) FROM Patient_LOGICAL_RESOURCES AS LR WHERE LR.IS_DELETED = 'N' AND EXISTS (SELECT 1 FROM Patient_STR_VALUES AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.PARAMETER_NAME_ID = 1274 AND (param.STR_VALUE = ?))";
        Assert.assertEquals((String)rendered, (String)"SELECT COUNT(*) FROM Patient_LOGICAL_RESOURCES AS LR WHERE LR.IS_DELETED = 'N' AND EXISTS (SELECT 1 FROM Patient_STR_VALUES AS param WHERE param.LOGICAL_RESOURCE_ID = LR.LOGICAL_RESOURCE_ID AND param.PARAMETER_NAME_ID = 1274 AND (param.STR_VALUE = ?))");
        Assert.assertEquals((int)bindMarkers.size(), (int)1);
    }

    @Test
    public void testChainedCompositeLikeBind() {
        String likeValue = "FOO%";
        String SQL = "SELECT COUNT(*) FROM Encounter_LOGICAL_RESOURCES AS LR0 WHERE (LR0.IS_DELETED = 'N') AND EXISTS (SELECT 1 FROM Encounter_TOKEN_VALUES_V AS P1 INNER JOIN Observation_LOGICAL_RESOURCES AS LR1 ON LR1.LOGICAL_ID = P1.TOKEN_VALUE AND LR1.VERSION_ID = COALESCE(P1.REF_VERSION_ID,LR1.VERSION_ID) AND P1.PARAMETER_NAME_ID = 1149 AND P1.CODE_SYSTEM_ID = 20129 AND (LR1.IS_DELETED = 'N') WHERE P1.LOGICAL_RESOURCE_ID = LR0.LOGICAL_RESOURCE_ID AND (EXISTS (SELECT 1 FROM Observation_TOKEN_VALUES_V AS comp1 INNER JOIN Observation_STR_VALUES AS comp2 ON comp2.LOGICAL_RESOURCE_ID = comp1.LOGICAL_RESOURCE_ID AND comp2.PARAMETER_NAME_ID = 21329 AND comp2.COMPOSITE_ID = comp1.COMPOSITE_ID AND (comp2.STR_VALUE LIKE ? ESCAPE '+') WHERE comp1.LOGICAL_RESOURCE_ID = LR1.LOGICAL_RESOURCE_ID AND comp1.PARAMETER_NAME_ID = 21328 AND (comp1.COMMON_TOKEN_VALUE_ID = 4464))))";
        Select ex2 = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Observation_TOKEN_VALUES_V", ExpressionSupport.alias((String)"comp1")).innerJoin("Observation_STR_VALUES", ExpressionSupport.alias((String)"comp2"), (WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)ExpressionSupport.on((String)"comp2", (String)"LOGICAL_RESOURCE_ID").eq("comp1", "LOGICAL_RESOURCE_ID")).and("comp2", "PARAMETER_NAME_ID")).eq(21329)).and("comp2", "COMPOSITE_ID")).eq("comp1", "COMPOSITE_ID")).and()).leftParen()).col("comp2", "STR_VALUE")).like(ExpressionSupport.bind((String)"FOO%"))).escape("+")).rightParen()).where("comp1", "LOGICAL_RESOURCE_ID").eq("LR1", "LOGICAL_RESOURCE_ID")).and("comp1", "PARAMETER_NAME_ID")).eq(21328)).and()).leftParen()).col("comp1", "COMMON_TOKEN_VALUE_ID")).eq(4464)).rightParen()).build();
        Select ex1 = ((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"1"}).from("Encounter_TOKEN_VALUES_V", ExpressionSupport.alias((String)"P1")).innerJoin("Observation_LOGICAL_RESOURCES", ExpressionSupport.alias((String)"LR1"), (WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)((WhereFragment)ExpressionSupport.on((String)"LR1", (String)"LOGICAL_ID").eq("P1", "TOKEN_VALUE")).and("LR1", "VERSION_ID")).eq()).coalesce(new ColumnRef[]{ExpressionSupport.col((String)"P1", (String)"REF_VERSION_ID"), ExpressionSupport.col((String)"LR1", (String)"VERSION_ID")})).and("P1", "PARAMETER_NAME_ID")).eq(1149)).and("P1", "CODE_SYSTEM_ID")).eq(20129)).and(ExpressionSupport.isDeleted((String)"LR1"))).where("P1", "LOGICAL_RESOURCE_ID").eq("LR0", "LOGICAL_RESOURCE_ID")).and()).leftParen()).exists(ex2)).rightParen()).build();
        Select main = ((WhereAdapter)((WhereAdapter)Select.select((String[])new String[]{"COUNT(*)"}).from("Encounter_LOGICAL_RESOURCES", ExpressionSupport.alias((String)"LR0")).where(ExpressionSupport.isDeleted((String)"LR0")).and()).exists(ex1)).build();
        ArrayList bindMarkers = new ArrayList();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, bindMarkers, false);
        String rendered = (String)main.render((StatementRenderer)renderer);
        Assert.assertEquals((String)rendered, (String)"SELECT COUNT(*) FROM Encounter_LOGICAL_RESOURCES AS LR0 WHERE (LR0.IS_DELETED = 'N') AND EXISTS (SELECT 1 FROM Encounter_TOKEN_VALUES_V AS P1 INNER JOIN Observation_LOGICAL_RESOURCES AS LR1 ON LR1.LOGICAL_ID = P1.TOKEN_VALUE AND LR1.VERSION_ID = COALESCE(P1.REF_VERSION_ID,LR1.VERSION_ID) AND P1.PARAMETER_NAME_ID = 1149 AND P1.CODE_SYSTEM_ID = 20129 AND (LR1.IS_DELETED = 'N') WHERE P1.LOGICAL_RESOURCE_ID = LR0.LOGICAL_RESOURCE_ID AND (EXISTS (SELECT 1 FROM Observation_TOKEN_VALUES_V AS comp1 INNER JOIN Observation_STR_VALUES AS comp2 ON comp2.LOGICAL_RESOURCE_ID = comp1.LOGICAL_RESOURCE_ID AND comp2.PARAMETER_NAME_ID = 21329 AND comp2.COMPOSITE_ID = comp1.COMPOSITE_ID AND (comp2.STR_VALUE LIKE ? ESCAPE '+') WHERE comp1.LOGICAL_RESOURCE_ID = LR1.LOGICAL_RESOURCE_ID AND comp1.PARAMETER_NAME_ID = 21328 AND (comp1.COMMON_TOKEN_VALUE_ID = 4464))))");
        Assert.assertEquals((int)bindMarkers.size(), (int)1);
        BindMarkerNode bindMarker = (BindMarkerNode)bindMarkers.get(0);
        BindMarkerNodeVisitor v = new BindMarkerNodeVisitor(){

            public void bindString(String value) {
                Assert.assertEquals((String)value, (String)"FOO%");
            }

            public void bindLong(Long value) {
                Assert.assertFalse((boolean)true);
            }

            public void bindInt(Integer value) {
                Assert.assertFalse((boolean)true);
            }

            public void bindInstant(Instant value) {
                Assert.assertFalse((boolean)true);
            }

            public void bindDouble(Double value) {
                Assert.assertFalse((boolean)true);
            }

            public void bindBigDecimal(BigDecimal value) {
                Assert.assertFalse((boolean)true);
            }
        };
        bindMarker.visit(v);
    }

    @Test
    public void unionAllTest() {
        List<String> resourceTypes = Arrays.asList("Patient", "Condition", "Observation");
        Select first = null;
        Select previous = null;
        for (String resourceType : resourceTypes) {
            Select select = ((WhereAdapter)Select.select((String[])new String[]{"1"}).from(resourceType + "_TOKEN_VALUES_V", ExpressionSupport.alias((String)"param")).where("param", "PARAMETER_NAME_ID").eq(1274)).build();
            if (previous != null) {
                previous.setUnionAll(select);
            } else {
                first = select;
            }
            previous = select;
        }
        String SQL = "SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274 UNION ALL SELECT 1 FROM Condition_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274 UNION ALL SELECT 1 FROM Observation_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274";
        ArrayList bindMarkers = new ArrayList();
        StringStatementRenderer renderer = new StringStatementRenderer((IDatabaseTranslator)TRANSLATOR, bindMarkers, false);
        Assert.assertEquals((String)((String)first.render((StatementRenderer)renderer)), (String)"SELECT 1 FROM Patient_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274 UNION ALL SELECT 1 FROM Condition_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274 UNION ALL SELECT 1 FROM Observation_TOKEN_VALUES_V AS param WHERE param.PARAMETER_NAME_ID = 1274");
        Assert.assertEquals((int)bindMarkers.size(), (int)0);
    }
}

