/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ModelResolver;
import com.ibm.jbatch.container.jsl.impl.JobModelResolverImpl;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.util.JSLMerger;
import com.ibm.jbatch.jsl.util.JSLValidationEventHandler;
import com.ibm.jbatch.jsl.util.ValidatorHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class StepModelResolverImpl
implements ModelResolver<Step> {
    @Override
    public Step resolveModel(String stepXML) {
        Step theStep = null;
        Step stepModel = this.unmarshalStepXML(stepXML);
        if (stepModel.getParent() != null) {
            Step parent = null;
            try {
                parent = this.getStepInheritance(stepModel.getParent());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (parent != null) {
                JSLMerger merger = new JSLMerger();
                theStep = merger.mergeStep(parent, stepModel);
            }
        }
        if (theStep == null) {
            theStep = stepModel;
        }
        return theStep;
    }

    private Step getStepInheritance(String parentId) throws IOException {
        Step step = null;
        InputStream indexFileUrl = JobModelResolverImpl.class.getResourceAsStream("/META-INF/jobinheritance");
        if (indexFileUrl != null) {
            Properties index = new Properties();
            index.load(indexFileUrl);
            if (index.getProperty(parentId) != null) {
                URL parentUrl = StepModelResolverImpl.class.getResource(index.getProperty(parentId));
                String parentXml = this.readJobXML(parentUrl.getFile());
                step = this.resolveModel(parentXml);
            }
        }
        return step;
    }

    private String readJobXML(String fileWithPath) throws FileNotFoundException, IOException {
        StringBuffer jobXMLBuffer;
        StringBuffer stringBuffer = jobXMLBuffer = fileWithPath == null ? null : new StringBuffer();
        if (fileWithPath != null) {
            BufferedReader zin = new BufferedReader(new FileReader(new File(fileWithPath)));
            String input = zin.readLine();
            do {
                if (input == null) continue;
                jobXMLBuffer.append(input);
                input = zin.readLine();
            } while (input != null);
        }
        return jobXMLBuffer == null ? null : jobXMLBuffer.toString();
    }

    @Override
    public Step resolveModel(Step t) {
        Step theStep = null;
        if (t.getParent() != null) {
            Step parent = null;
            try {
                parent = this.getStepInheritance(t.getParent());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (parent != null) {
                JSLMerger merger = new JSLMerger();
                theStep = merger.mergeStep(parent, t);
            }
        }
        if (theStep == null) {
            theStep = t;
        }
        return theStep;
    }

    private Step unmarshalStepXML(String stepXML) {
        Object result = null;
        Step step = null;
        JSLValidationEventHandler handler = new JSLValidationEventHandler();
        try {
            JAXBContext ctx = JAXBContext.newInstance((String)"com.ibm.jbatch.jsl.model");
            Unmarshaller u = ctx.createUnmarshaller();
            u.setSchema(ValidatorHelper.getXJCLSchema());
            u.setEventHandler((ValidationEventHandler)handler);
            result = u.unmarshal((Source)new StreamSource(new StringReader(stepXML)));
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Exception unmarshalling jobXML", e);
        }
        if (handler.eventOccurred()) {
            throw new IllegalArgumentException("xJCL invalid per schema, see SysOut for now for details");
        }
        step = (Step)((JAXBElement)result).getValue();
        return step;
    }
}

