/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BatchletStepControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.container.persistence.PersistentDataWrapper;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.InternalExecutionElementStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;

public abstract class BaseStepControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected RuntimeJobContextJobExecutionBridge jobExecutionImpl;
    protected JobInstance jobInstance;
    protected StepContextImpl stepContext;
    protected Step step;
    protected StepStatus stepStatus;
    protected BlockingQueue<PartitionDataWrapper> analyzerStatusQueue = null;
    protected RuntimeJobContextJobExecutionBridge rootJobExecution = null;
    protected static IBatchKernelService batchKernel = ServicesManagerImpl.getInstance().getBatchKernelService();
    protected TransactionManagerAdapter transactionManager = null;
    private static IPersistenceManagerService _persistenceManagementService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
    private static IJobStatusManagerService _jobStatusService = ServicesManagerImpl.getInstance().getJobStatusManagerService();

    protected BaseStepControllerImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl, Step step) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.jobInstance = jobExecutionImpl.getJobInstance();
        if (step == null) {
            throw new IllegalArgumentException("Step parameter to ctor cannot be null.");
        }
        this.step = step;
    }

    protected abstract void invokeCoreStep() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException;

    protected abstract void setupStepArtifacts();

    protected abstract void invokePreStepArtifacts();

    protected abstract void invokePostStepArtifacts();

    protected abstract void sendStatusFromPartitionToAnalyzerIfPresent();

    private void setContextProperties() {
        JSLProperties jslProps = this.step.getProperties();
        if (jslProps != null) {
            for (Property property : jslProps.getPropertyList()) {
                Properties contextProps = this.stepContext.getProperties();
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
        this.stepContext.addMetric(Metric.MetricType.READ_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.WRITE_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.READ_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.PROCESS_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.WRITE_SKIPCOUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.FILTER_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.COMMIT_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.ROLLBACK_COUNT, 0L);
        ITransactionManagementService transMgr = ServicesManagerImpl.getInstance().getTransactionManagementService();
        this.transactionManager = transMgr.getTransactionManager(this.stepContext);
    }

    @Override
    public void setStepContext(StepContextImpl stepContext) {
        this.stepContext = stepContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalExecutionElementStatus execute(RuntimeJobContextJobExecutionBridge rootJobExecution) throws AbortedBeforeStartException {
        Throwable throwable = null;
        this.rootJobExecution = rootJobExecution;
        try {
            RunOnRestart rc = this.preInvokeStep();
            if (rc.equals((Object)RunOnRestart.ALREADY_COMPLETE)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Not going to run this step.  Returning previous exit status of: " + this.stepStatus.getExitStatus());
                }
                InternalExecutionElementStatus internalExecutionElementStatus = new InternalExecutionElementStatus(this.stepStatus.getExitStatus());
                return internalExecutionElementStatus;
            }
            this.invokeCoreStep();
            this.transitionToFinalStatus();
        }
        catch (Throwable t) {
            throwable = t;
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            logger.warning(sourceClass + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            if (this.stepContext.getBatchStatus() != null) {
                this.stepContext.setBatchStatus(BatchStatus.FAILED);
                logger.fine(sourceClass + ": setting step BatchStatus to FAILED");
            } else {
                logger.fine(sourceClass + ": no step BatchStatus to set");
            }
        }
        finally {
            this.invokePostStepArtifacts();
            if (this.stepContext.getBatchStatus() != null) {
                this.defaultExitStatusIfNecessary();
                this.persistStepExitStatusAndUserData();
                this.sendStatusFromPartitionToAnalyzerIfPresent();
            }
        }
        if (this.stepContext.getBatchStatus() == null) {
            logger.warning("Aborting before start for stepId=" + this.step.getId());
            throw new AbortedBeforeStartException("Thrown for stepId=" + this.step.getId());
        }
        if (throwable != null) {
            throw new RuntimeException("Wrappering earlier uncaught exception: ", throwable);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Returning step exitStatus: " + this.stepContext.getExitStatus());
        }
        return new InternalExecutionElementStatus(this.stepContext.getBatchStatus(), this.stepContext.getExitStatus());
    }

    private void defaultExitStatusIfNecessary() {
        String stepExitStatus = this.stepContext.getExitStatus();
        String processRetVal = this.stepContext.getBatchletProcessRetVal();
        if (stepExitStatus != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning with user-set exit status: " + stepExitStatus);
            }
        } else if (processRetVal != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning with exit status from batchlet.process(): " + processRetVal);
            }
            this.stepContext.setExitStatus(processRetVal);
        } else {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Returning with default exit status");
            }
            this.stepContext.setExitStatus(this.stepContext.getBatchStatus().name());
        }
    }

    protected void statusStarting() {
        this.stepStatus.setBatchStatus(BatchStatus.STARTING);
        _jobStatusService.updateJobCurrentStep(this.jobInstance.getInstanceId(), this.step.getId());
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(BatchStatus.STARTING);
        long time = System.currentTimeMillis();
        Timestamp startTS = new Timestamp(time);
        this.stepContext.setStartTime(startTS);
    }

    protected void statusStarted() {
        this.stepStatus.setBatchStatus(BatchStatus.STARTED);
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(BatchStatus.STARTED);
    }

    protected void statusStopped() {
        this.stepStatus.setBatchStatus(BatchStatus.STOPPED);
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(BatchStatus.STOPPED);
    }

    protected void statusCompleted() {
        this.stepStatus.setBatchStatus(BatchStatus.COMPLETED);
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(BatchStatus.COMPLETED);
    }

    private void transitionToFinalStatus() {
        BatchStatus currentBatchStatus = this.stepContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)BatchStatus.STARTING)) {
            throw new IllegalStateException("Step batch status should not be in a STARTING state");
        }
        if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transitioning step status to COMPLETED for step: " + this.step.getId());
            }
            this.statusCompleted();
        } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Transitioning step status to STOPPED for step: " + this.step.getId());
            }
            this.statusStopped();
        }
    }

    protected void persistStepExitStatusAndUserData() {
        ByteArrayOutputStream persistentBAOS = new ByteArrayOutputStream();
        ObjectOutputStream persistentDataOOS = null;
        try {
            persistentDataOOS = new ObjectOutputStream(persistentBAOS);
            persistentDataOOS.writeObject(this.stepContext.getPersistentUserData());
            persistentDataOOS.close();
        }
        catch (Exception e) {
            throw new BatchContainerServiceException("Cannot persist the persistent user data for the step.", e);
        }
        this.stepStatus.setPersistentUserData(new PersistentDataWrapper(persistentBAOS.toByteArray()));
        this.stepStatus.setExitStatus(this.stepContext.getExitStatus());
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        long time = System.currentTimeMillis();
        Timestamp endTS = new Timestamp(time);
        this.stepContext.setEndTime(endTS);
        _persistenceManagementService.updateStepExecution(this.rootJobExecution.getExecutionId(), this.stepContext);
    }

    private StepExecutionImpl getNewStepExecution(long rootJobExecutionId, StepContextImpl stepContext) {
        return _persistenceManagementService.createStepExecution(rootJobExecutionId, stepContext);
    }

    protected RunOnRestart preInvokeStep() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("In preInvokeStep() with stepContext =  " + this.stepContext);
        }
        this.stepStatus = _jobStatusService.getStepStatus(this.jobInstance.getInstanceId(), this.step.getId());
        if (this.stepStatus == null) {
            StepExecutionImpl stepExecution = this.getNewStepExecution(this.rootJobExecution.getExecutionId(), this.stepContext);
            this.stepStatus = _jobStatusService.createStepStatus(stepExecution.getStepExecutionId());
            this.stepContext.setStepExecutionId(stepExecution.getStepExecutionId());
        } else {
            this.stepContext.setPersistentUserData(this.stepStatus.getPersistentUserData());
            if (this.runOnRestart()) {
                StepExecutionImpl stepExecution = this.getNewStepExecution(this.rootJobExecution.getExecutionId(), this.stepContext);
                this.stepContext.setStepExecutionId(stepExecution.getStepExecutionId());
                this.stepStatus.incrementStartCount();
            } else {
                return RunOnRestart.ALREADY_COMPLETE;
            }
        }
        this.statusStarting();
        this.setContextProperties();
        this.setupStepArtifacts();
        this.statusStarted();
        this.invokePreStepArtifacts();
        return RunOnRestart.RUN;
    }

    private boolean runOnRestart() {
        BatchStatus stepBatchStatus = this.stepStatus.getBatchStatus();
        if (stepBatchStatus.equals((Object)BatchStatus.COMPLETED)) {
            if (!Boolean.parseBoolean(this.step.getAllowStartIfComplete())) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Step: " + this.step.getId() + " already has batch status of COMPLETED, so won't be run again since it does not allow start if complete.");
                }
                return false;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Step: " + this.step.getId() + " already has batch status of COMPLETED, and allow-start-if-complete is set to 'true'");
            }
        }
        int startLimit = 0;
        String startLimitString = this.step.getStartLimit();
        if (startLimitString != null) {
            try {
                startLimit = Integer.parseInt(startLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse start limit value for stepId: " + this.step.getId() + ", with start-limit=" + this.step.getStartLimit(), e);
            }
        }
        if (startLimit < 0) {
            throw new IllegalArgumentException("Found negative start-limit of " + startLimit + "for stepId: " + this.step.getId());
        }
        if (startLimit > 0) {
            int newStepStartCount = this.stepStatus.getStartCount() + 1;
            if (newStepStartCount > startLimit) {
                throw new IllegalArgumentException("For stepId: " + this.step.getId() + ", tried to start step for the " + newStepStartCount + " time, but startLimit = " + startLimit);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Starting (possibly restarting) step: " + this.step.getId() + ", since newStepStartCount = " + newStepStartCount + "and startLimit=" + startLimit);
            }
        }
        return true;
    }

    protected BlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerStatusQueue;
    }

    @Override
    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerStatusQueue = analyzerQueue;
    }

    private static enum RunOnRestart {
        ALREADY_COMPLETE,
        RUN;

    }
}

