/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.artifact.proxy.DeciderProxy;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.status.InternalExecutionElementStatus;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;

public class DecisionControllerImpl
implements IExecutionElementController {
    protected RuntimeJobContextJobExecutionBridge jobExecutionImpl;
    protected StepContextImpl stepContext;
    protected Decision decision;
    private PartitionAnalyzerProxy analyzerProxy;
    protected List<StepExecution> stepExecutions = null;
    protected ExecutionElement executionElement = null;

    public DecisionControllerImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl, Decision decision) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.decision = decision;
    }

    @Override
    public void setStepContext(StepContextImpl stepContext) {
        throw new UnsupportedOperationException("Shouldn't be called on a decision.");
    }

    public void setStepExecution(Flow flow, StepExecution stepExecution) {
        this.executionElement = flow;
        this.stepExecutions = new ArrayList<StepExecution>();
        this.stepExecutions.add(stepExecution);
    }

    public void setStepExecution(Step step, StepExecution stepExecution) {
        this.executionElement = step;
        this.stepExecutions = new ArrayList<StepExecution>();
        this.stepExecutions.add(stepExecution);
    }

    public void setStepExecutions(Split split, List<StepExecution> stepExecutions) {
        this.executionElement = split;
        this.stepExecutions = stepExecutions;
    }

    @Override
    public InternalExecutionElementStatus execute(RuntimeJobContextJobExecutionBridge rootJobExecution) throws Exception {
        DeciderProxy deciderProxy;
        String deciderId = this.decision.getRef();
        List<Property> propList = this.decision.getProperties() == null ? null : this.decision.getProperties().getPropertyList();
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
        try {
            deciderProxy = ProxyFactory.createDeciderProxy(deciderId, injectionRef);
        }
        catch (ArtifactValidationException e) {
            throw new BatchContainerServiceException("Cannot create the decider [" + deciderId + "]", e);
        }
        String exitStatus = deciderProxy.decide(this.stepExecutions.toArray(new StepExecution[this.stepExecutions.size()]));
        return new InternalExecutionElementStatus(exitStatus);
    }

    @Override
    public void stop() {
        this.stepContext.setBatchStatus(BatchStatus.STOPPING);
    }

    @Override
    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }
}

