/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.JobListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ListenerFactory;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.impl.ExecutionElementControllerFactory;
import com.ibm.jbatch.container.impl.SplitControllerImpl;
import com.ibm.jbatch.container.jobinstance.JobExecutionHelper;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.Navigator;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.TransitionElement;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JDBCPersistenceManagerImpl;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.InternalExecutionElementStatus;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;

public class JobControllerImpl
implements IController {
    private static final String CLASSNAME = JobControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IJobStatusManagerService jobStatusService = null;
    private IPersistenceManagerService persistenceService = null;
    private RuntimeJobContextJobExecutionBridge jobExecution = null;
    private final JobContextImpl jobContext;
    private final Navigator<JSLJob> jobNavigator;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;
    private ListenerFactory listenerFactory = null;
    private final long jobInstanceId;
    private RuntimeJobContextJobExecutionBridge rootJobExecution = null;
    private volatile IExecutionElementController currentStoppableElementController = null;

    public JobControllerImpl(RuntimeJobContextJobExecutionBridge jobExecution, RuntimeJobContextJobExecutionBridge rootJobExecution) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.rootJobExecution = rootJobExecution;
        this.jobNavigator = jobExecution.getJobNavigator();
        this.jobInstanceId = jobExecution.getJobInstance().getInstanceId();
        this.jobStatusService = ServicesManagerImpl.getInstance().getJobStatusManagerService();
        this.persistenceService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
        this.setContextProperties();
        this.setupListeners();
    }

    private void setContextProperties() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getJSL();
        JSLProperties jslProps = jobModel.getProperties();
        if (jslProps != null) {
            Properties contextProps = this.jobContext.getProperties();
            for (Property property : jslProps.getPropertyList()) {
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
    }

    private void setupListeners() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getJSL();
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        this.listenerFactory = new ListenerFactory(jobModel, injectionRef);
        this.jobExecution.setListenerFactory(this.listenerFactory);
    }

    public void executeJob() {
        String methodName = "executeJob";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASSNAME, "executeJob");
        }
        try {
            if (BatchStatus.STOPPING.equals((Object)this.jobContext.getBatchStatus())) {
                this.updateJobBatchStatus(BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.updateJobBatchStatus(BatchStatus.STARTING);
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.updateJobBatchStatus(BatchStatus.STARTED);
            List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Invoking @BeforeJob on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
                }
                listenerProxy.beforeJob();
            }
            if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Exiting as job has been stopped");
                }
                return;
            }
            this.doExecutionLoop(this.jobNavigator);
            BatchStatus currentStatus = this.jobContext.getBatchStatus();
            if (currentStatus == null) {
                throw new IllegalStateException("Job BatchStatus should have been set by now");
            }
            BatchStatus curStatus = currentStatus;
            if (!curStatus.equals((Object)BatchStatus.FAILED) && !curStatus.equals((Object)BatchStatus.STOPPED)) {
                this.updateJobBatchStatus(BatchStatus.COMPLETED);
            }
            if (this.jobContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
                }
                this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
            }
            for (JobListenerProxy listenerProxy : jobListeners) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("executeJob Invoking @AfterJob on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
                }
                listenerProxy.afterJob();
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            logger.severe(CLASSNAME + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            this.updateJobBatchStatus(BatchStatus.FAILED);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Job failed with exception/error: " + t.getMessage());
            }
            if (this.jobContext.getExitStatus() == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
                }
                this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
            }
            throw new BatchContainerRuntimeException(t);
        }
        finally {
            block40: {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Job complete for job id=" + this.jobExecution.getJobInstance().getJobName() + ", executionId=" + this.jobExecution.getExecutionId() + ", batchStatus=" + this.jobContext.getBatchStatus() + ", exitStatus=" + this.jobContext.getExitStatus());
                }
                try {
                    this.jobStatusService.updateJobExecutionStatus(this.jobExecution.getInstanceId(), this.jobContext.getBatchStatus(), this.jobContext.getExitStatus());
                    long time = System.currentTimeMillis();
                    Timestamp updateTS = new Timestamp(time);
                    this.jobExecution.setLastUpdateTime(updateTS);
                    this.jobExecution.setEndTime(updateTS);
                    if (this.persistenceService instanceof JDBCPersistenceManagerImpl) {
                        this.persistenceService.jobExecutionStatusStringUpdate(this.jobExecution.getExecutionId(), "exitstatus", this.jobContext.getExitStatus(), updateTS);
                        this.persistenceService.jobExecutionTimestampUpdate(this.jobExecution.getExecutionId(), "endtime", updateTS);
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block40;
                    StringWriter sw = new StringWriter();
                    t.printStackTrace(new PrintWriter(sw));
                    logger.warning("Caught Throwable on updating execution status: " + sw.toString());
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.exiting(CLASSNAME, "executeJob");
            }
        }
    }

    private void doExecutionLoop(Navigator jobNavigator) throws Exception {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        JobContextImpl jobContext = this.jobExecution.getJobContext();
        ExecutionElement currentExecutionElement = null;
        try {
            currentExecutionElement = jobNavigator.getFirstExecutionElement(this.jobExecution.getRestartOn());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Job doesn't contain a step.", e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + currentExecutionElement.getId());
        }
        StepContextImpl stepContext = null;
        ExecutionElement previousExecutionElement = null;
        IExecutionElementController previousElementController = null;
        while (true) {
            if (!(currentExecutionElement instanceof Step || currentExecutionElement instanceof Decision || currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split)) {
                throw new IllegalStateException("Found unknown currentExecutionElement type = " + currentExecutionElement.getClass().getName());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next execution element = " + currentExecutionElement.getId());
            }
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecution, currentExecutionElement);
            elementController.setAnalyzerQueue(this.analyzerQueue);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement != null) {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision.");
                    }
                    if (previousExecutionElement instanceof Step) {
                        StepExecution lastStepExecution = this.getLastStepExecution((Step)previousExecutionElement);
                        ((DecisionControllerImpl)elementController).setStepExecution((Step)previousExecutionElement, lastStepExecution);
                    } else if (previousExecutionElement instanceof Split) {
                        List<StepExecution> stepExecutions = this.getSplitStepExecutions(previousElementController);
                        ((DecisionControllerImpl)elementController).setStepExecutions((Split)previousExecutionElement, stepExecutions);
                    } else if (previousExecutionElement instanceof Flow) {
                        Step last = this.getLastStepInTheFlow(previousExecutionElement);
                        StepExecution lastStepExecution = this.getLastStepExecution(last);
                        ((DecisionControllerImpl)elementController).setStepExecution((Flow)previousExecutionElement, lastStepExecution);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else if (currentExecutionElement instanceof Flow) {
                String flowId = ((Flow)currentExecutionElement).getId();
            } else if (currentExecutionElement instanceof Split) {
                String splitId = ((Split)currentExecutionElement).getId();
            }
            if (jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            InternalExecutionElementStatus executionElementStatus = null;
            try {
                executionElementStatus = elementController.execute(this.rootJobExecution);
            }
            catch (AbortedBeforeStartException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId());
                }
                logger.warning("Execution failed, InstanceId: " + this.jobInstanceId + ", executionId = " + this.jobExecution.getExecutionId());
                throw new BatchContainerRuntimeException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            if (executionElementStatus.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
                logger.warning("Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.");
                throw new BatchContainerRuntimeException("Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.");
            }
            if (executionElementStatus.getBatchStatus().equals((Object)BatchStatus.STOPPED)) {
                String restartOn = executionElementStatus.getRestartOn();
                this.jslStop(executionElementStatus, executionElementStatus.getExitStatus(), restartOn);
                return;
            }
            this.currentStoppableElementController = null;
            previousElementController = elementController;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementStatus);
            }
            if (jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.updateJobBatchStatus(BatchStatus.STOPPED);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting as job has been stopped");
                }
                return;
            }
            nextTransition = jobNavigator.getNextTransition(currentExecutionElement, executionElementStatus.getExitStatus());
            if (nextTransition == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop TODO: is this an expected state or not? ");
                }
                return;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("doExecutionLoop , Looping through to next execution element=" + currentExecutionElement.getId());
        }
        if (nextTransition.getTransitionElement() != null) {
            TransitionElement transitionElement = nextTransition.getTransitionElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("doExecutionLoop , Looping through to next control element=" + transitionElement);
            }
            if (transitionElement instanceof Stop) {
                String newExitStatus;
                String restartOn = ((Stop)transitionElement).getRestart();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <stop> : " + transitionElement + " with restartOn=" + restartOn);
                }
                if ((newExitStatus = ((Stop)transitionElement).getExitStatus()) != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on stop, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
                InternalExecutionElementStatus internalStopStatus = new InternalExecutionElementStatus(BatchStatus.STOPPED, newExitStatus);
                this.jslStop(internalStopStatus, newExitStatus, restartOn);
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting stopped job");
                }
                return;
            }
            if (transitionElement instanceof End) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is an <end>: " + transitionElement);
                }
                this.updateJobBatchStatus(BatchStatus.COMPLETED);
                String newExitStatus = ((End)transitionElement).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on end, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else if (transitionElement instanceof Fail) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <fail>: " + transitionElement);
                }
                this.updateJobBatchStatus(BatchStatus.FAILED);
                String newExitStatus = ((Fail)transitionElement).getExitStatus();
                if (newExitStatus != null && !newExitStatus.isEmpty()) {
                    jobContext.setExitStatus(newExitStatus);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on fail, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                }
            } else {
                throw new IllegalStateException("Not sure how we'd get here but better than looping.");
            }
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecutionLoop Exiting as there are no more execution elements= ");
        }
    }

    private List<StepExecution> getSplitStepExecutions(IExecutionElementController previousElementController) {
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        if (previousElementController != null) {
            SplitControllerImpl controller = (SplitControllerImpl)previousElementController;
            for (BatchWorkUnit batchWorkUnit : controller.getParallelJobExecs()) {
                StepExecution lastStepExecution = null;
                List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(batchWorkUnit.getJobExecutionImpl().getExecutionId());
                Iterator<StepExecution> i$ = stepExecs.iterator();
                while (i$.hasNext()) {
                    StepExecution stepExecution;
                    lastStepExecution = stepExecution = i$.next();
                }
                stepExecutions.add(lastStepExecution);
            }
        }
        return stepExecutions;
    }

    private StepExecution getLastStepExecution(Step last) {
        StepExecution lastStepExecution = null;
        List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(this.jobExecution.getExecutionId());
        for (StepExecution stepExecution : stepExecs) {
            if (!last.getId().equals(stepExecution.getStepName())) continue;
            lastStepExecution = stepExecution;
        }
        return lastStepExecution;
    }

    private Step getLastStepInTheFlow(ExecutionElement previousExecutionElement) {
        Flow flow = (Flow)previousExecutionElement;
        Step last = null;
        for (ExecutionElement elem : flow.getExecutionElements()) {
            if (!(elem instanceof Step)) continue;
            last = (Step)elem;
        }
        return last;
    }

    @Override
    public void stop() {
        if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTING) || this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTED)) {
            this.updateJobBatchStatus(BatchStatus.STOPPING);
            if (this.currentStoppableElementController != null) {
                this.currentStoppableElementController.stop();
            }
        }
    }

    private void updateJobBatchStatus(BatchStatus batchStatus) {
        String methodName = "updateJobBatchStatus";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(methodName + " Setting job batch status to: " + batchStatus);
        }
        this.jobContext.setBatchStatus(batchStatus);
        this.jobStatusService.updateJobBatchStatus(this.jobInstanceId, batchStatus);
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        switch (batchStatus) {
            case STARTING: {
                JobExecutionHelper.updateBatchStatusUPDATEonly(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case STARTED: {
                JobExecutionHelper.updateBatchStatusSTART(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case STOPPING: {
                JobExecutionHelper.updateBatchStatusUPDATEonly(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case STOPPED: {
                JobExecutionHelper.updateBatchStatusSTOP(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case COMPLETED: {
                JobExecutionHelper.updateBatchStatusCOMPLETED(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
            case FAILED: {
                JobExecutionHelper.updateBatchStatusFAILED(this.jobExecution.getExecutionId(), batchStatus.name(), timestamp);
                break;
            }
        }
    }

    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    private void jslStop(InternalExecutionElementStatus status, String exitStatus, String restartOn) {
        logger.fine("Logging JSL stop(): status = " + status + ", exitStatus = " + exitStatus + ", restartOn = " + restartOn);
        this.updateJobBatchStatus(BatchStatus.STOPPED);
        this.jobStatusService.updateJobStatusFromJSLStop(this.jobInstanceId, restartOn);
        this.jobContext.setExitStatus(exitStatus);
    }
}

