/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jobinstance;

import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.JDBCPersistenceManagerImpl;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.spi.TaggedJobExecution;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class JobOperatorJobExecutionImpl
implements IJobExecution,
TaggedJobExecution {
    private static final String sourceClass = JobOperatorJobExecutionImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private static IPersistenceManagerService _persistenceManagementService = servicesManager.getPersistenceManagerService();
    private long executionID = 0L;
    private long instanceID = 0L;
    Timestamp createTime;
    Timestamp startTime;
    Timestamp endTime;
    Timestamp updateTime;
    Properties parameters;
    String batchStatus;
    String exitStatus;
    Properties jobProperties = null;
    String jobName = null;
    private JobContextImpl jobContext = null;

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Override
    public void setJobContext(JobContextImpl jobContext) {
        this.jobContext = jobContext;
    }

    public JobOperatorJobExecutionImpl(long executionId, long instanceId) {
        this.executionID = executionId;
        this.instanceID = instanceId;
    }

    public BatchStatus getBatchStatus() {
        BatchStatus batchStatus = null;
        if (this.jobContext != null) {
            batchStatus = this.jobContext.getBatchStatus();
            logger.finest("Returning batch status of: " + batchStatus + " from JobContext.");
        } else {
            if (!(_persistenceManagementService instanceof JDBCPersistenceManagerImpl)) {
                throw new UnsupportedOperationException("Only JDBC-based persistence currently supported for this function.");
            }
            batchStatus = BatchStatus.valueOf((String)((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionStatus(this.executionID, "batchstatus"));
            logger.finest("Returning batch status of: " + batchStatus + " from JobContext.");
        }
        return batchStatus;
    }

    public Date getCreateTime() {
        if (this.jobContext == null && _persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            this.createTime = ((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionTimestamp(this.executionID, "createtime");
        }
        return new Date(this.createTime.getTime());
    }

    public Date getEndTime() {
        if (this.jobContext == null && _persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            this.endTime = ((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionTimestamp(this.executionID, "endtime");
        }
        return new Date(this.endTime.getTime());
    }

    public long getExecutionId() {
        return this.executionID;
    }

    public String getExitStatus() {
        if (this.jobContext != null) {
            return this.jobContext.getExitStatus();
        }
        if (_persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            this.exitStatus = ((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionStatus(this.executionID, "exitstatus");
        }
        return this.exitStatus;
    }

    public Date getLastUpdatedTime() {
        if (this.jobContext == null && _persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            this.updateTime = ((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionTimestamp(this.executionID, "updatetime");
        }
        return new Date(this.updateTime.getTime());
    }

    public Date getStartTime() {
        if (this.jobContext == null && _persistenceManagementService instanceof JDBCPersistenceManagerImpl) {
            this.startTime = ((JDBCPersistenceManagerImpl)_persistenceManagementService).jobOperatorQueryJobExecutionTimestamp(this.executionID, "starttime");
        }
        return new Date(this.startTime.getTime());
    }

    public Properties getJobParameters() {
        return this.jobProperties;
    }

    @Override
    public void setBatchStatus(String status) {
        this.batchStatus = status;
    }

    @Override
    public void setCreateTime(Timestamp ts) {
        this.createTime = ts;
    }

    @Override
    public void setEndTime(Timestamp ts) {
        this.endTime = ts;
    }

    public void setExecutionId(long id) {
        this.executionID = id;
    }

    public void setJobInstanceId(long jobInstanceID) {
        this.instanceID = jobInstanceID;
    }

    @Override
    public void setExitStatus(String status) {
        this.exitStatus = status;
    }

    public void setInstanceId(long id) {
        this.instanceID = id;
    }

    @Override
    public void setLastUpdateTime(Timestamp ts) {
        this.updateTime = ts;
    }

    @Override
    public void setStartTime(Timestamp ts) {
        this.startTime = ts;
    }

    @Override
    public void setJobParameters(Properties jProps) {
        this.jobProperties = jProps;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getTagName() {
        return _persistenceManagementService.getTagName(this.executionID);
    }

    @Override
    public long getInstanceId() {
        return this.instanceID;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("createTime=" + this.createTime);
        buf.append(",batchStatus=" + this.batchStatus);
        buf.append(",exitStatus=" + this.exitStatus);
        buf.append(",jobName=" + this.jobName);
        buf.append(",instanceId=" + this.instanceID);
        buf.append(",executionId=" + this.executionID);
        return buf.toString();
    }
}

