/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.JobControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class BatchWorkUnit
implements Runnable {
    private String CLASSNAME = BatchWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchWorkUnit.class.getPackage().getName());
    private RuntimeJobContextJobExecutionBridge jobExecutionImpl = null;
    private IBatchKernelService batchKernel = null;
    private final JobControllerImpl controller;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;
    private BlockingQueue<BatchWorkUnit> completedThreadQueue;
    private boolean notifyCallbackWhenDone;
    private RuntimeJobContextJobExecutionBridge rootJobExecution = null;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobContextJobExecutionBridge jobExecutionImpl) {
        this(batchKernel, jobExecutionImpl, null, null, jobExecutionImpl, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobContextJobExecutionBridge jobExecutionImpl, BlockingQueue<PartitionDataWrapper> analyzerQueue, BlockingQueue<BatchWorkUnit> completedThreadQueue, RuntimeJobContextJobExecutionBridge rootJobExecution, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.setJobExecutionImpl(jobExecutionImpl);
        this.setAnalyzerQueue(analyzerQueue);
        this.setCompletedThreadQueue(completedThreadQueue);
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        if (rootJobExecution == null) {
            this.setRootJobExecution(jobExecutionImpl);
        } else {
            this.setRootJobExecution(rootJobExecution);
        }
        this.controller = new JobControllerImpl(this.getJobExecutionImpl(), this.rootJobExecution);
        this.controller.setAnalyzerQueue(this.analyzerQueue);
    }

    public JobControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("==========================================================");
        }
        try {
            this.controller.executeJob();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Exception when invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            }
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            if (this.completedThreadQueue != null) {
                this.completedThreadQueue.add(this);
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", e);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Done invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            this.logger.fine("==========================================================");
        }
        if (this.isNotifyCallbackWhenDone()) {
            this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
        }
        if (this.completedThreadQueue != null) {
            this.completedThreadQueue.add(this);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    private BatchStatus getBatchStatus() {
        return this.jobExecutionImpl.getJobContext().getBatchStatus();
    }

    private String getExitStatus() {
        return this.jobExecutionImpl.getJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl) {
        this.jobExecutionImpl = jobExecutionImpl;
    }

    public RuntimeJobContextJobExecutionBridge getJobExecutionImpl() {
        return this.jobExecutionImpl;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }

    public BlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerQueue;
    }

    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    public BlockingQueue<BatchWorkUnit> getCompletedThreadQueue() {
        return this.completedThreadQueue;
    }

    public void setCompletedThreadQueue(BlockingQueue<BatchWorkUnit> completedThreadQueue) {
        this.completedThreadQueue = completedThreadQueue;
    }

    public RuntimeJobContextJobExecutionBridge getRootJobExecution() {
        return this.rootJobExecution;
    }

    public void setRootJobExecution(RuntimeJobContextJobExecutionBridge rootJobExecution) {
        this.rootJobExecution = rootJobExecution;
    }
}

