/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.PartitionedStepBuilder;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.InternalExecutionElementStatus;
import com.ibm.jbatch.container.util.BatchParallelWorkUnit;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.Split;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.runtime.BatchStatus;

public class SplitControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = SplitControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private final RuntimeJobContextJobExecutionBridge jobExecutionImpl;
    private volatile List<BatchParallelWorkUnit> parallelBatchWorkUnits;
    private final ServicesManager servicesManager;
    private final IBatchKernelService batchKernel;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected Split split;

    public SplitControllerImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl, Split split) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.split = split;
        this.servicesManager = ServicesManagerImpl.getInstance();
        this.batchKernel = this.servicesManager.getBatchKernelService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelBatchWorkUnits != null) {
                for (BatchParallelWorkUnit subJob : this.parallelBatchWorkUnits) {
                    try {
                        this.batchKernel.stopJob(subJob.getJobExecutionImpl().getExecutionId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalExecutionElementStatus execute(RuntimeJobContextJobExecutionBridge rootJobExecution) throws AbortedBeforeStartException, JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        String sourceMethod = "execute";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, sourceMethod);
        }
        LinkedBlockingQueue<BatchParallelWorkUnit> completedWorkQueue = new LinkedBlockingQueue<BatchParallelWorkUnit>();
        List<Flow> flows = this.split.getFlows();
        this.parallelBatchWorkUnits = new ArrayList<BatchParallelWorkUnit>();
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            for (Flow flow : flows) {
                this.subJobs.add(PartitionedStepBuilder.buildSubJob(this.jobExecutionImpl.getExecutionId(), this.jobExecutionImpl.getJobContext(), this.split, flow, null));
            }
            for (JSLJob job : this.subJobs) {
                int count = this.batchKernel.getJobInstanceCount(job.getId());
                if (count == 0) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildNewBatchParallelWorkUnit(job, null, null, completedWorkQueue, rootJobExecution));
                    continue;
                }
                if (count == 1) {
                    this.parallelBatchWorkUnits.add(this.batchKernel.buildRestartableBatchParallelWorkUnit(job, null, null, completedWorkQueue, rootJobExecution));
                    continue;
                }
                throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
            }
        }
        for (BatchParallelWorkUnit work : this.parallelBatchWorkUnits) {
            int count = this.batchKernel.getJobInstanceCount(work.getJobExecutionImpl().getJobInstance().getJobName());
            assert (count <= 1);
            if (count == 1) {
                this.batchKernel.startGeneratedJob(work);
                continue;
            }
            if (count > 1) {
                this.batchKernel.restartGeneratedJob(work);
                continue;
            }
            throw new IllegalStateException("There is an inconsistency somewhere in the internal subjob creation");
        }
        boolean someFlowFailed = false;
        boolean someFlowStopped = false;
        for (int i = 0; i < this.subJobs.size(); ++i) {
            BatchWorkUnit batchWork;
            try {
                batchWork = (BatchWorkUnit)completedWorkQueue.take();
            }
            catch (InterruptedException e) {
                throw new BatchContainerRuntimeException(e);
            }
            BatchStatus batchStatus = batchWork.getJobExecutionImpl().getJobContext().getBatchStatus();
            if (batchStatus.equals((Object)BatchStatus.FAILED)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Subjob " + batchWork.getJobExecutionImpl().getExecutionId() + "ended with status '" + batchStatus + "'");
                }
                someFlowFailed = true;
                continue;
            }
            if (!batchStatus.equals((Object)BatchStatus.STOPPED)) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Subjob " + batchWork.getJobExecutionImpl().getExecutionId() + "ended with status '" + batchStatus + "'");
            }
            someFlowStopped = true;
        }
        InternalExecutionElementStatus splitStatus = null;
        splitStatus = someFlowFailed ? new InternalExecutionElementStatus(BatchStatus.FAILED) : (someFlowStopped ? new InternalExecutionElementStatus(BatchStatus.STOPPED) : new InternalExecutionElementStatus(BatchStatus.COMPLETED));
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Exiting with: " + splitStatus);
        }
        return splitStatus;
    }

    @Override
    public void setStepContext(StepContextImpl stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }

    public List<BatchParallelWorkUnit> getParallelJobExecs() {
        return this.parallelBatchWorkUnits;
    }
}

