/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.TransitionElement;
import com.ibm.jbatch.container.jsl.impl.GlobPatternMatcherImpl;
import com.ibm.jbatch.container.jsl.impl.TransitionImpl;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Next;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractNavigatorImpl {
    private static final Logger logger = Logger.getLogger(AbstractNavigatorImpl.class.getName());
    private Map<String, ExecutionElement> alreadyExecutedElements = new HashMap<String, ExecutionElement>();

    public ExecutionElement getFirstExecutionElement(List<ExecutionElement> peerExecutionElements, String restartOn) throws IllegalTransitionException {
        String method = "getFirstExecutionElement";
        logger.fine("getFirstExecutionElement , restartOn = " + restartOn);
        ExecutionElement startElement = null;
        if (restartOn != null) {
            startElement = this.getExecutionElementFromId(peerExecutionElements, restartOn);
            if (startElement == null) {
                throw new IllegalStateException("Didn't find an execution element maching restart-on designated element: " + restartOn);
            }
        } else if (peerExecutionElements.size() > 0) {
            startElement = peerExecutionElements.get(0);
        } else {
            logger.fine("getFirstExecutionElement , Container appears to contain no execution elements.  Returning.");
            return null;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getFirstExecutionElement , Found start element: " + startElement);
        }
        if (!(startElement instanceof Decision)) {
            this.alreadyExecutedElements.put(startElement.getId(), startElement);
        }
        return startElement;
    }

    public Transition getNextTransition(ExecutionElement currentElem, List<ExecutionElement> peerExecutionElements, String currentExitStatus) throws IllegalTransitionException {
        String method = "getNextTransition";
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("getNextTransition ,currentExitStatus=" + currentExitStatus);
        }
        TransitionImpl returnTransition = new TransitionImpl();
        ExecutionElement nextExecutionElement = null;
        List<TransitionElement> transitionElements = currentElem.getTransitionElements();
        if (!transitionElements.isEmpty()) {
            for (TransitionElement t : transitionElements) {
                logger.fine("getNextTransition Trying to match next transition element: " + t);
                boolean isMatched = this.matchExitStatusAgainstOnAttribute(currentExitStatus, t);
                if (!isMatched) continue;
                if (t instanceof Next) {
                    Next next = (Next)t;
                    nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, next.getTo());
                    returnTransition.setNextExecutionElement(nextExecutionElement);
                    break;
                }
                returnTransition.setTransitionElement(t);
                return returnTransition;
            }
        }
        if (nextExecutionElement == null) {
            nextExecutionElement = this.getNextExecutionElemFromAttribute(peerExecutionElements, currentElem);
            returnTransition.setNextExecutionElement(nextExecutionElement);
        }
        if (nextExecutionElement != null) {
            if (this.alreadyExecutedElements.containsKey(nextExecutionElement.getId())) {
                String errorMsg = "Execution loop detected !!!  Trying to re-execute execution element: " + nextExecutionElement.getId();
                logger.severe(errorMsg);
                throw new IllegalTransitionException(errorMsg);
            }
            if (!(nextExecutionElement instanceof Decision)) {
                this.alreadyExecutedElements.put(nextExecutionElement.getId(), nextExecutionElement);
            }
            logger.fine("getNextTransition Transitioning to next element id = " + nextExecutionElement.getId());
            return returnTransition;
        }
        logger.fine("getNextTransition return null, there is no next execution elemetn");
        return null;
    }

    private ExecutionElement getExecutionElementFromId(List<ExecutionElement> executionElements, String id) throws IllegalTransitionException {
        if (id != null) {
            logger.finer("attribute value is " + id);
            for (ExecutionElement elem : executionElements) {
                if (!elem.getId().equals(id)) continue;
                return elem;
            }
            logger.warning("No execution element found with id = " + id);
            throw new IllegalTransitionException("No execution element found with id = " + id);
        }
        logger.finer("attribute value is <null>, so simply exiting...");
        return null;
    }

    private static boolean matchSpecifiedExitStatus(String currentStepExitStatus, String exitStatusPattern) {
        logger.finer("matchSpecifiedExitStatus, matching current exitStatus  " + currentStepExitStatus + " against pattern: " + exitStatusPattern);
        GlobPatternMatcherImpl matcher = new GlobPatternMatcherImpl();
        boolean match = matcher.matchWithoutBackslashEscape(currentStepExitStatus, exitStatusPattern);
        if (match) {
            logger.finer("matchSpecifiedExitStatus, match=YES");
            return true;
        }
        logger.finer("matchSpecifiedExitStatus, match=NO");
        return false;
    }

    private boolean matchExitStatusAgainstOnAttribute(String exitStatus, TransitionElement elem) {
        logger.fine("Trying to match exitStatus = " + exitStatus + " , against transition element: " + elem);
        String exitStatusToMatch = null;
        if (elem instanceof End) {
            exitStatusToMatch = ((End)elem).getOn();
        } else {
            if (elem instanceof Fail) {
                exitStatusToMatch = ((Fail)elem).getOn();
                return AbstractNavigatorImpl.matchSpecifiedExitStatus(exitStatus, exitStatusToMatch);
            }
            if (elem instanceof Stop) {
                exitStatusToMatch = ((Stop)elem).getOn();
            } else if (elem instanceof Next) {
                exitStatusToMatch = ((Next)elem).getOn();
            } else {
                throw new IllegalStateException("Shouldn't be possible to get here. Unknown transition element,  " + elem.toString());
            }
        }
        boolean match = AbstractNavigatorImpl.matchSpecifiedExitStatus(exitStatus, exitStatusToMatch);
        String logMsg = match ? "Matched" : "Didn't match";
        logger.fine(logMsg);
        return match;
    }

    private ExecutionElement getNextExecutionElemFromAttribute(List<ExecutionElement> peerExecutionElements, ExecutionElement currentElem) throws IllegalTransitionException {
        ExecutionElement nextExecutionElement = null;
        String nextAttrId = null;
        if (currentElem instanceof Step) {
            nextAttrId = ((Step)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Split) {
            nextAttrId = ((Split)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Flow) {
            nextAttrId = ((Flow)currentElem).getNextFromAttribute();
            nextExecutionElement = this.getExecutionElementFromId(peerExecutionElements, nextAttrId);
        } else if (currentElem instanceof Decision) {
            // empty if block
        }
        logger.fine("From currentElem = " + currentElem + " , return @next attribute execution element: " + nextExecutionElement);
        return nextExecutionElement;
    }
}

