/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.FlowNavigator;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.impl.AbstractNavigatorImpl;
import com.ibm.jbatch.jsl.model.Flow;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FlowNavigatorImpl
extends AbstractNavigatorImpl
implements FlowNavigator {
    private static final Logger logger = Logger.getLogger(FlowNavigatorImpl.class.getName());
    private Flow flow = null;

    public FlowNavigatorImpl(Flow flow) {
        this.flow = flow;
    }

    public String toString() {
        return "FlowNavigatorImpl for flow id = " + this.flow.getId();
    }

    @Override
    public Flow getFlow() {
        return this.flow;
    }

    @Override
    public ExecutionElement getFirstExecutionElementInFlow(String restartOn) throws IllegalTransitionException {
        logger.fine("Getting first execution element in flow, restartOn = " + restartOn);
        ExecutionElement firstElem = this.getFirstExecutionElement(this.flow.getExecutionElements(), restartOn);
        logger.fine("Got first execution element in flow = " + firstElem.getId());
        return firstElem;
    }

    @Override
    public Transition getNextTransitionInFlow(ExecutionElement currentExecutionElem, String currentStepExitStatus) throws IllegalTransitionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting next transition in flow, currentExecutionElem = " + currentExecutionElem);
        }
        Transition nextTransition = this.getNextTransition(currentExecutionElem, this.flow.getExecutionElements(), currentStepExitStatus);
        logger.fine("Got next transition in flow = " + nextTransition);
        return nextTransition;
    }
}

