/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jsl.impl;

import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.JobNavigator;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.impl.AbstractNavigatorImpl;
import com.ibm.jbatch.jsl.model.JSLJob;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JobNavigatorImpl
extends AbstractNavigatorImpl
implements JobNavigator {
    private static final Logger logger = Logger.getLogger(JobNavigatorImpl.class.getName());
    private JSLJob job = null;

    public JobNavigatorImpl(JSLJob job) {
        this.job = job;
    }

    public String toString() {
        return "JobNavigatorImpl for job id = " + this.job.getId();
    }

    @Override
    public JSLJob getJSLJob() {
        return this.job;
    }

    @Override
    public ExecutionElement getFirstExecutionElementInJob(String restartOn) throws IllegalTransitionException {
        logger.fine("Getting first execution element in job, restartOn = " + restartOn);
        ExecutionElement firstElem = this.getFirstExecutionElement(this.job.getExecutionElements(), restartOn);
        logger.fine("Got first execution element in job = " + firstElem.getId());
        return firstElem;
    }

    @Override
    public Transition getNextTransitionInJob(ExecutionElement currentExecutionElem, String currentStepExitStatus) throws IllegalTransitionException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Getting next transition in job, currentExecutionElem = " + currentExecutionElem);
        }
        Transition nextTransition = this.getNextTransition(currentExecutionElem, this.job.getExecutionElements(), currentStepExitStatus);
        logger.fine("Got next transition in job = " + nextTransition);
        return nextTransition;
    }
}

