/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.JobControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchParallelWorkUnit
extends BatchWorkUnit {
    private String CLASSNAME = BatchParallelWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchParallelWorkUnit.class.getPackage().getName());
    private final JobControllerImpl controller;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;
    private BlockingQueue<BatchParallelWorkUnit> completedThreadQueue;
    private RuntimeJobContextJobExecutionBridge rootJobExecution = null;

    public BatchParallelWorkUnit(IBatchKernelService batchKernel, RuntimeJobContextJobExecutionBridge jobExecutionImpl) {
        this(batchKernel, jobExecutionImpl, null, null, jobExecutionImpl, true);
    }

    public BatchParallelWorkUnit(IBatchKernelService batchKernel, RuntimeJobContextJobExecutionBridge jobExecutionImpl, BlockingQueue<PartitionDataWrapper> analyzerQueue, BlockingQueue<BatchParallelWorkUnit> completedThreadQueue, RuntimeJobContextJobExecutionBridge rootJobExecution, boolean notifyCallbackWhenDone) {
        super(batchKernel, jobExecutionImpl, notifyCallbackWhenDone);
        this.setAnalyzerQueue(analyzerQueue);
        this.setCompletedThreadQueue(completedThreadQueue);
        if (rootJobExecution == null) {
            this.setRootJobExecution(jobExecutionImpl);
        } else {
            this.setRootJobExecution(rootJobExecution);
        }
        this.controller = new JobControllerImpl(this.getJobExecutionImpl(), this.rootJobExecution);
        this.controller.setAnalyzerQueue(this.analyzerQueue);
    }

    @Override
    public JobControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("==========================================================");
        }
        try {
            this.controller.executeJob();
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("==========================================================");
                this.logger.fine("Done invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
                this.logger.fine("==========================================================");
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.logger.warning("Caught throwable from run().  Stack trace: " + sw.toString());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Exception when invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            }
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", t);
        }
        finally {
            if (this.completedThreadQueue != null) {
                this.completedThreadQueue.add(this);
            }
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    public BlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerQueue;
    }

    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    public BlockingQueue<BatchParallelWorkUnit> getCompletedThreadQueue() {
        return this.completedThreadQueue;
    }

    public void setCompletedThreadQueue(BlockingQueue<BatchParallelWorkUnit> completedThreadQueue) {
        this.completedThreadQueue = completedThreadQueue;
    }

    public RuntimeJobContextJobExecutionBridge getRootJobExecution() {
        return this.rootJobExecution;
    }

    public void setRootJobExecution(RuntimeJobContextJobExecutionBridge rootJobExecution) {
        this.rootJobExecution = rootJobExecution;
    }
}

