/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.util;

import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.JobControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.services.IBatchKernelService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;

public class BatchWorkUnit
implements Runnable {
    private String CLASSNAME = BatchWorkUnit.class.getName();
    private Logger logger = Logger.getLogger(BatchWorkUnit.class.getPackage().getName());
    protected RuntimeJobContextJobExecutionBridge jobExecutionImpl = null;
    protected IBatchKernelService batchKernel = null;
    protected final JobControllerImpl controller;
    protected boolean notifyCallbackWhenDone;

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobContextJobExecutionBridge jobExecutionImpl) {
        this(batchKernel, jobExecutionImpl, true);
    }

    public BatchWorkUnit(IBatchKernelService batchKernel, RuntimeJobContextJobExecutionBridge jobExecutionImpl, boolean notifyCallbackWhenDone) {
        this.setBatchKernel(batchKernel);
        this.setJobExecutionImpl(jobExecutionImpl);
        this.setNotifyCallbackWhenDone(notifyCallbackWhenDone);
        this.controller = new JobControllerImpl(jobExecutionImpl);
    }

    public JobControllerImpl getController() {
        return this.controller;
    }

    @Override
    public void run() {
        String method = "run";
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.entering(this.CLASSNAME, method);
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("==========================================================");
            this.logger.fine("Invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
            this.logger.fine("==========================================================");
        }
        try {
            this.controller.executeJob();
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("==========================================================");
                this.logger.fine("Done invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
                this.logger.fine("==========================================================");
            }
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            this.logger.warning("Caught throwable from run().  Stack trace: " + sw.toString());
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Exception when invoking executeJob on JobController; JobInstance id=" + this.getJobExecutionImpl().getInstanceId() + ", executionId=" + this.getJobExecutionImpl().getExecutionId());
                this.logger.fine("Job Batch Status = " + this.getBatchStatus() + ";  Job Exit Status = " + this.getExitStatus());
            }
            if (this.isNotifyCallbackWhenDone()) {
                this.getBatchKernel().jobExecutionDone(this.getJobExecutionImpl());
            }
            throw new BatchContainerRuntimeException("This job failed unexpectedly.", t);
        }
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.exiting(this.CLASSNAME, method);
        }
    }

    protected BatchStatus getBatchStatus() {
        return this.jobExecutionImpl.getJobContext().getBatchStatus();
    }

    protected String getExitStatus() {
        return this.jobExecutionImpl.getJobContext().getExitStatus();
    }

    public void setBatchKernel(IBatchKernelService batchKernel) {
        this.batchKernel = batchKernel;
    }

    public IBatchKernelService getBatchKernel() {
        return this.batchKernel;
    }

    public void setJobExecutionImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl) {
        this.jobExecutionImpl = jobExecutionImpl;
    }

    public RuntimeJobContextJobExecutionBridge getJobExecutionImpl() {
        return this.jobExecutionImpl;
    }

    public void setNotifyCallbackWhenDone(boolean notifyCallbackWhenDone) {
        this.notifyCallbackWhenDone = notifyCallbackWhenDone;
    }

    public boolean isNotifyCallbackWhenDone() {
        return this.notifyCallbackWhenDone;
    }
}

