/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.PartitionCollectorProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.StepListenerProxy;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Collector;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Logger;

public abstract class SingleThreadedStepControllerImpl
extends BaseStepControllerImpl
implements IController {
    private static final String sourceClass = SingleThreadedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected PartitionCollectorProxy collectorProxy = null;
    List<StepListenerProxy> stepListeners = null;

    protected SingleThreadedStepControllerImpl(RuntimeJobExecution jobExecutionImpl, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue) {
        super(jobExecutionImpl, step, stepContext, rootJobExecutionId, analyzerStatusQueue);
    }

    @Override
    protected void setupStepArtifacts() {
        Collector collector;
        InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.stepListeners = this.jobExecutionImpl.getListenerFactory().getStepListeners(this.step, injectionRef, this.stepContext);
        if (this.step.getPartition() != null && (collector = this.step.getPartition().getCollector()) != null) {
            List<Property> propList = collector.getProperties() == null ? null : collector.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            try {
                this.collectorProxy = ProxyFactory.createPartitionCollectorProxy(collector.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the collector [" + collector.getRef() + "]", e);
            }
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.stepListeners == null) {
            return;
        }
        for (StepListenerProxy listenerProxy : this.stepListeners) {
            listenerProxy.beforeStep();
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.stepListeners != null) {
            for (StepListenerProxy listenerProxy : this.stepListeners) {
                listenerProxy.afterStep();
            }
        }
    }

    protected void invokeCollectorIfPresent() {
        if (this.collectorProxy != null) {
            Serializable data = this.collectorProxy.collectPartitionData();
            logger.finer("Got partition data: " + data + ", from collector: " + this.collectorProxy);
            this.sendCollectorDataToAnalyzerIfPresent(data);
        }
    }

    protected void sendCollectorDataToAnalyzerIfPresent(Serializable data) {
        if (this.analyzerStatusQueue != null) {
            logger.finer("Sending collector partition data: " + data + " to analyzer queue: " + this.analyzerStatusQueue);
            PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
            dataWrapper.setCollectorData(data);
            dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_COLLECTOR_DATA);
            this.analyzerStatusQueue.add(dataWrapper);
        } else {
            logger.fine("Analyzer not configured.");
        }
    }

    @Override
    protected void sendStatusFromPartitionToAnalyzerIfPresent() {
        if (this.analyzerStatusQueue != null) {
            logger.fine("Send status from partition for analyzeStatus with batchStatus = " + this.stepStatus.getBatchStatus() + ", exitStatus = " + this.stepStatus.getExitStatus());
            PartitionDataWrapper dataWrapper = new PartitionDataWrapper();
            dataWrapper.setBatchStatus(this.stepStatus.getBatchStatus());
            dataWrapper.setExitStatus(this.stepStatus.getExitStatus());
            dataWrapper.setEventType(PartitionDataWrapper.PartitionEventType.ANALYZE_STATUS);
            this.analyzerStatusQueue.add(dataWrapper);
        } else {
            logger.fine("Analyzer not configured.");
        }
    }
}

