/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.impl.ExecutionElementControllerFactory;
import com.ibm.jbatch.container.impl.PartitionedStepControllerImpl;
import com.ibm.jbatch.container.impl.SplitControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.FlowNavigator;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.NavigatorFactory;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.TransitionElement;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.InternalExecutionElementStatus;
import com.ibm.jbatch.container.util.BatchParallelWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;

public class FlowControllerImpl
implements IExecutionElementController {
    private static final String CLASSNAME = PartitionedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private final RuntimeJobContextJobExecutionBridge jobExecutionImpl;
    private IPersistenceManagerService persistenceService = null;
    protected FlowNavigator flowNavigator;
    protected Flow flow;
    private volatile IExecutionElementController currentStoppableElementController = null;

    public FlowControllerImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl, Flow flow) {
        this.jobExecutionImpl = jobExecutionImpl;
        this.flowNavigator = NavigatorFactory.createFlowNavigator((Flow)flow);
        this.flow = flow;
        this.persistenceService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
    }

    @Override
    public InternalExecutionElementStatus execute(RuntimeJobContextJobExecutionBridge rootJobExecution) throws AbortedBeforeStartException {
        String methodName = "execute";
        if (logger.isLoggable(Level.FINE)) {
            logger.entering(CLASSNAME, "execute");
        }
        try {
            InternalExecutionElementStatus internalExecutionElementStatus = this.doExecutionLoop(rootJobExecution);
            return internalExecutionElementStatus;
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(CLASSNAME + ": caught exception/error: " + t.getMessage() + " : Stack trace: " + sw.toString());
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Flow failed with exception/error: " + t.getMessage());
            }
            throw new BatchContainerRuntimeException(t);
        }
        finally {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Flow complete for flow id=" + this.flow.getId() + ", executionId=" + this.jobExecutionImpl.getExecutionId());
                logger.exiting(CLASSNAME, "execute");
            }
        }
    }

    private InternalExecutionElementStatus doExecutionLoop(RuntimeJobContextJobExecutionBridge rootJobExecution) {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        ExecutionElement currentExecutionElement = null;
        try {
            currentExecutionElement = this.flowNavigator.getFirstExecutionElementInFlow(this.jobExecutionImpl.getRestartOn());
        }
        catch (IllegalTransitionException e) {
            String errorMsg = "Could not transition to first execution element within flow>";
            logger.warning(errorMsg);
            throw new IllegalArgumentException(errorMsg, e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("First execution element = " + currentExecutionElement.getId());
        }
        StepContextImpl stepContext = null;
        ExecutionElement previousExecutionElement = null;
        IExecutionElementController previousElementController = null;
        while (true) {
            if (!(currentExecutionElement instanceof Step || currentExecutionElement instanceof Decision || currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split)) {
                throw new UnsupportedOperationException("Only support step, and decision within a flow");
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Next execution element = " + currentExecutionElement.getId());
            }
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecutionImpl, currentExecutionElement);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement == null) {
                    elementController.setStepContext(null);
                } else {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision...OR CAN IT???");
                    }
                    if (previousExecutionElement instanceof Step) {
                        StepExecution lastStepExecution = this.getLastStepExecution((Step)previousExecutionElement);
                        ((DecisionControllerImpl)elementController).setStepExecution((Step)previousExecutionElement, lastStepExecution);
                    } else if (previousExecutionElement instanceof Split) {
                        List<StepExecution> stepExecutions = this.getSplitStepExecutions(previousElementController);
                        ((DecisionControllerImpl)elementController).setStepExecutions((Split)previousExecutionElement, stepExecutions);
                    } else if (previousExecutionElement instanceof Flow) {
                        Step last = this.getLastStepInTheFlow(previousExecutionElement);
                        StepExecution lastStepExecution = this.getLastStepExecution(last);
                        ((DecisionControllerImpl)elementController).setStepExecution((Flow)previousExecutionElement, lastStepExecution);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else if (currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split) {
                // empty if block
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            InternalExecutionElementStatus executionElementStatus = null;
            try {
                executionElementStatus = elementController.execute(rootJobExecution);
            }
            catch (AbortedBeforeStartException e) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId());
                }
                throw new IllegalStateException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            this.currentStoppableElementController = null;
            previousElementController = elementController;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementStatus.getExitStatus());
            }
            nextTransition = null;
            try {
                nextTransition = this.flowNavigator.getNextTransitionInFlow(currentExecutionElement, executionElementStatus.getExitStatus());
            }
            catch (IllegalTransitionException e) {
                String errorMsg = "Tried to transition to invalid target from within flow.";
                logger.severe(errorMsg);
                throw new IllegalStateException(errorMsg);
            }
            if (nextTransition == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop ; No further transitions found within flow. ");
                }
                return new InternalExecutionElementStatus(BatchStatus.COMPLETED);
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.fine("doExecutionLoop , Looping through to next execution element=" + currentExecutionElement.getId());
        }
        if (nextTransition.getTransitionElement() != null) {
            TransitionElement transitionElem = nextTransition.getTransitionElement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("doExecutionLoop , Looping through to next control element=" + transitionElem);
            }
            if (transitionElem instanceof Stop) {
                String newExitStatus;
                String restartOn = ((Stop)transitionElem).getRestart();
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <stop> : " + transitionElem + " with restartOn=" + restartOn);
                }
                if ((newExitStatus = ((Stop)transitionElem).getExitStatus()) != null && !newExitStatus.isEmpty()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on stop, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                } else {
                    newExitStatus = this.jobExecutionImpl.getJobContext().getExitStatus();
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop Exiting stopped job");
                }
                return new InternalExecutionElementStatus(BatchStatus.STOPPED, newExitStatus);
            }
            if (transitionElem instanceof End) {
                String newExitStatus;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is an <end>: " + transitionElem);
                }
                if ((newExitStatus = ((End)transitionElem).getExitStatus()) != null && !newExitStatus.isEmpty()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on end, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                } else {
                    newExitStatus = this.jobExecutionImpl.getJobContext().getExitStatus();
                }
                return new InternalExecutionElementStatus(BatchStatus.COMPLETED, newExitStatus);
            }
            if (transitionElem instanceof Fail) {
                String newExitStatus;
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("doExecutionLoop , next control element is a <fail>: " + transitionElem);
                }
                if ((newExitStatus = ((Fail)transitionElem).getExitStatus()) != null && !newExitStatus.isEmpty()) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("doExecutionLoop , on fail, setting new JSL-specified exit status to: " + newExitStatus);
                    }
                } else {
                    newExitStatus = this.jobExecutionImpl.getJobContext().getExitStatus();
                }
                return new InternalExecutionElementStatus(BatchStatus.FAILED, newExitStatus);
            }
            throw new IllegalStateException("Not sure how we'd get here but better than looping.");
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("doExecutionLoop Exiting as there are no more execution elements= ");
        }
        return new InternalExecutionElementStatus();
    }

    private List<StepExecution> getSplitStepExecutions(IExecutionElementController previousElementController) {
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        if (previousElementController != null) {
            SplitControllerImpl controller = (SplitControllerImpl)previousElementController;
            for (BatchParallelWorkUnit batchWorkUnit : controller.getParallelJobExecs()) {
                StepExecution lastStepExecution = null;
                List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(batchWorkUnit.getJobExecutionImpl().getExecutionId());
                Iterator<StepExecution> i$ = stepExecs.iterator();
                while (i$.hasNext()) {
                    StepExecution stepExecution;
                    lastStepExecution = stepExecution = i$.next();
                }
                stepExecutions.add(lastStepExecution);
            }
        }
        return stepExecutions;
    }

    private StepExecution getLastStepExecution(Step last) {
        StepExecution lastStepExecution = null;
        List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(this.jobExecutionImpl.getExecutionId());
        for (StepExecution stepExecution : stepExecs) {
            if (!last.getId().equals(stepExecution.getStepName())) continue;
            lastStepExecution = stepExecution;
        }
        return lastStepExecution;
    }

    private Step getLastStepInTheFlow(ExecutionElement previousExecutionElement) {
        Flow flow = (Flow)previousExecutionElement;
        Step last = null;
        for (ExecutionElement elem : flow.getExecutionElements()) {
            if (!(elem instanceof Step)) continue;
            last = (Step)elem;
        }
        return last;
    }

    @Override
    public void stop() {
        if (this.currentStoppableElementController != null) {
            this.currentStoppableElementController.stop();
        }
    }

    @Override
    public void setStepContext(StepContextImpl stepContext) {
        throw new BatchContainerRuntimeException("Incorrect usage: step context is not in scope within a flow.");
    }

    @Override
    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
    }
}

