/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.AbortedBeforeStartException;
import com.ibm.jbatch.container.IController;
import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.JobListenerProxy;
import com.ibm.jbatch.container.artifact.proxy.ListenerFactory;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.impl.DecisionControllerImpl;
import com.ibm.jbatch.container.impl.ExecutionElementControllerFactory;
import com.ibm.jbatch.container.impl.SplitControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.jsl.ExecutionElement;
import com.ibm.jbatch.container.jsl.IllegalTransitionException;
import com.ibm.jbatch.container.jsl.JobNavigator;
import com.ibm.jbatch.container.jsl.Transition;
import com.ibm.jbatch.container.jsl.TransitionElement;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.InternalExecutionElementStatus;
import com.ibm.jbatch.container.util.BatchParallelWorkUnit;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.Decision;
import com.ibm.jbatch.jsl.model.End;
import com.ibm.jbatch.jsl.model.Fail;
import com.ibm.jbatch.jsl.model.Flow;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Split;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.jsl.model.Stop;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.listener.JobListener;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.StepExecution;

public class JobControllerImpl
implements IController {
    private static final String CLASSNAME = JobControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IJobStatusManagerService jobStatusService = null;
    private IPersistenceManagerService persistenceService = null;
    private RuntimeJobContextJobExecutionBridge jobExecution = null;
    private final JobContextImpl jobContext;
    private final JobNavigator jobNavigator;
    private BlockingQueue<PartitionDataWrapper> analyzerQueue;
    private ListenerFactory listenerFactory = null;
    private final long jobInstanceId;
    private RuntimeJobContextJobExecutionBridge rootJobExecution = null;
    private volatile IExecutionElementController currentStoppableElementController = null;

    public JobControllerImpl(RuntimeJobContextJobExecutionBridge jobExecution) {
        this(jobExecution, jobExecution);
    }

    public JobControllerImpl(RuntimeJobContextJobExecutionBridge jobExecution, RuntimeJobContextJobExecutionBridge rootJobExecution) {
        this.jobExecution = jobExecution;
        this.jobContext = jobExecution.getJobContext();
        this.rootJobExecution = rootJobExecution;
        this.jobNavigator = jobExecution.getJobNavigator();
        this.jobInstanceId = jobExecution.getJobInstance().getInstanceId();
        this.jobStatusService = ServicesManagerImpl.getInstance().getJobStatusManagerService();
        this.persistenceService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
        this.setContextProperties();
        this.setupListeners();
    }

    public void executeJob() {
        String methodName = "executeJob";
        logger.entering(CLASSNAME, methodName);
        try {
            if (!this.jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                this.markJobStarted();
                this.jobListenersBeforeJob();
                this.doExecutionLoop();
            }
        }
        catch (Throwable t) {
            this.logWarning("Caught throwable in main execution loop", t);
            this.updateJobBatchStatus(BatchStatus.FAILED);
        }
        this.endOfJob();
        logger.exiting(CLASSNAME, methodName);
    }

    private void markJobStarted() {
        this.updateJobBatchStatus(BatchStatus.STARTED);
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.jobExecution.setStartTime(timestamp);
        this.persistenceService.markJobStarted(this.jobExecution.getExecutionId(), timestamp);
    }

    private void endOfJob() {
        try {
            this.jobListenersAfterJob();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            logger.warning("Error invoking jobListener.afterJob(). Stack trace: " + sw.toString());
            this.updateJobBatchStatus(BatchStatus.FAILED);
        }
        this.transitionToFinalBatchStatus();
        if (this.jobContext.getExitStatus() == null) {
            logger.fine("No job-level exitStatus set, defaulting to job batch Status = " + this.jobContext.getBatchStatus());
            this.jobContext.setExitStatus(this.jobContext.getBatchStatus().name());
        }
        logger.fine("Job complete for job id=" + this.jobExecution.getJobInstance().getJobName() + ", executionId=" + this.jobExecution.getExecutionId() + ", batchStatus=" + this.jobContext.getBatchStatus() + ", exitStatus=" + this.jobContext.getExitStatus());
        this.persistJobBatchAndExitStatus();
    }

    private void persistJobBatchAndExitStatus() {
        BatchStatus batchStatus = this.jobContext.getBatchStatus();
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.jobStatusService.updateJobBatchStatus(this.jobInstanceId, batchStatus);
        this.jobStatusService.updateJobExecutionStatus(this.jobExecution.getInstanceId(), this.jobContext.getBatchStatus(), this.jobContext.getExitStatus());
        if (!(batchStatus.equals((Object)BatchStatus.COMPLETED) || batchStatus.equals((Object)BatchStatus.STOPPED) || batchStatus.equals((Object)BatchStatus.FAILED))) {
            throw new IllegalStateException("Not expected to encounter batchStatus of " + batchStatus + " at this point.  Aborting.");
        }
        this.jobExecution.setEndTime(timestamp);
        this.persistenceService.updateWithFinalExecutionStatusesAndTimestamps(this.jobExecution.getExecutionId(), batchStatus, this.jobContext.getExitStatus(), timestamp);
    }

    private void transitionToFinalBatchStatus() {
        BatchStatus currentBatchStatus = this.jobContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
            this.updateJobBatchStatus(BatchStatus.COMPLETED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
            this.updateJobBatchStatus(BatchStatus.STOPPED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
            this.updateJobBatchStatus(BatchStatus.FAILED);
        } else {
            throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
        }
    }

    private void updateJobBatchStatus(BatchStatus batchStatus) {
        logger.fine("Setting job batch status to: " + batchStatus);
        this.jobContext.setBatchStatus(batchStatus);
    }

    private void doExecutionLoop() throws Exception {
        Transition nextTransition;
        String methodName = "doExecutionLoop";
        StepContextImpl stepContext = null;
        ExecutionElement previousExecutionElement = null;
        IExecutionElementController previousElementController = null;
        ExecutionElement currentExecutionElement = null;
        JobContextImpl jobContext = this.jobExecution.getJobContext();
        try {
            currentExecutionElement = this.jobNavigator.getFirstExecutionElementInJob(this.jobExecution.getRestartOn());
        }
        catch (IllegalTransitionException e) {
            String errorMsg = "Could not transition to first execution element within job.";
            logger.warning(errorMsg);
            throw new IllegalArgumentException(errorMsg, e);
        }
        logger.fine("First execution element = " + currentExecutionElement.getId());
        while (true) {
            if (jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting execution loop as job is now in stopping state.");
                return;
            }
            if (!(currentExecutionElement instanceof Step || currentExecutionElement instanceof Decision || currentExecutionElement instanceof Flow || currentExecutionElement instanceof Split)) {
                throw new IllegalStateException("Found unknown currentExecutionElement type = " + currentExecutionElement.getClass().getName());
            }
            logger.fine("Next execution element = " + currentExecutionElement.getId());
            IExecutionElementController elementController = ExecutionElementControllerFactory.getExecutionElementController(this.jobExecution, currentExecutionElement);
            elementController.setAnalyzerQueue(this.analyzerQueue);
            if (currentExecutionElement instanceof Decision) {
                if (previousExecutionElement != null) {
                    if (previousExecutionElement instanceof Decision) {
                        throw new BatchContainerRuntimeException("A decision cannot precede another decision.");
                    }
                    if (previousExecutionElement instanceof Step) {
                        StepExecution lastStepExecution = this.getLastStepExecution((Step)previousExecutionElement);
                        ((DecisionControllerImpl)elementController).setStepExecution((Step)previousExecutionElement, lastStepExecution);
                    } else if (previousExecutionElement instanceof Split) {
                        List<StepExecution> stepExecutions = this.getSplitStepExecutions(previousElementController);
                        ((DecisionControllerImpl)elementController).setStepExecutions((Split)previousExecutionElement, stepExecutions);
                    } else if (previousExecutionElement instanceof Flow) {
                        Step last = this.getLastStepInTheFlow(previousExecutionElement);
                        StepExecution lastStepExecution = this.getLastStepExecution(last);
                        ((DecisionControllerImpl)elementController).setStepExecution((Flow)previousExecutionElement, lastStepExecution);
                    }
                }
            } else if (currentExecutionElement instanceof Step) {
                String stepId = ((Step)currentExecutionElement).getId();
                stepContext = new StepContextImpl(stepId);
                elementController.setStepContext(stepContext);
            } else if (currentExecutionElement instanceof Flow) {
                String flowId = ((Flow)currentExecutionElement).getId();
            } else if (currentExecutionElement instanceof Split) {
                String splitId = ((Split)currentExecutionElement).getId();
            }
            if (jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting execution loop as job is now in stopping state.");
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Start executing element = " + currentExecutionElement.getId());
            }
            this.currentStoppableElementController = elementController;
            InternalExecutionElementStatus executionElementStatus = null;
            try {
                executionElementStatus = elementController.execute(this.rootJobExecution);
            }
            catch (AbortedBeforeStartException e) {
                logger.warning("Execution failed, InstanceId: " + this.jobInstanceId + ", executionId = " + this.jobExecution.getExecutionId());
                throw new BatchContainerRuntimeException("Execution failed before even getting to execute execution element = " + currentExecutionElement.getId() + "; breaking out of execution loop.");
            }
            if (executionElementStatus.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
                logger.warning("Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.");
                throw new BatchContainerRuntimeException("Sub-execution returned its own BatchStatus of FAILED.  Deal with this by throwing exception to the next layer.");
            }
            if (executionElementStatus.getBatchStatus().equals((Object)BatchStatus.STOPPED)) {
                String restartOn = executionElementStatus.getRestartOn();
                jobContext.setExitStatus(executionElementStatus.getExitStatus());
                this.jslStop(restartOn);
                return;
            }
            this.currentStoppableElementController = null;
            previousElementController = elementController;
            logger.fine("Done executing element=" + currentExecutionElement.getId() + ", exitStatus=" + executionElementStatus);
            if (jobContext.getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("doExecutionLoop Exiting as job has been stopped");
                return;
            }
            nextTransition = null;
            try {
                nextTransition = this.jobNavigator.getNextTransitionInJob(currentExecutionElement, executionElementStatus.getExitStatus());
            }
            catch (IllegalTransitionException e) {
                String errorMsg = "Problem transitioning to next execution element.";
                logger.warning(errorMsg);
                throw new IllegalArgumentException(errorMsg, e);
            }
            if (nextTransition == null) {
                logger.fine("doExecutionLoopNo next execution element, and no transition element found either.  Looks like we're done and ready for COMPLETED state.");
                return;
            }
            if (nextTransition.getNextExecutionElement() == null) break;
            previousExecutionElement = currentExecutionElement;
            currentExecutionElement = nextTransition.getNextExecutionElement();
        }
        if (nextTransition.getTransitionElement() != null) {
            this.handleTerminatingTransitionElement(nextTransition.getTransitionElement());
            logger.finer("doExecutionLoop , Breaking out of execution loop after processing terminating transition element.");
            return;
        }
        throw new IllegalStateException("Not sure how we'd end up in this state...aborting rather than looping.");
    }

    private void updateExitStatusFromJSL(String exitStatusFromJSL) {
        if (exitStatusFromJSL != null) {
            this.jobContext.setExitStatus(exitStatusFromJSL);
            logger.fine("On stop, setting new JSL-specified exit status to: " + exitStatusFromJSL);
        }
    }

    private void handleTerminatingTransitionElement(TransitionElement transitionElement) {
        logger.fine("Found terminating transition element (stop, end, or fail).");
        if (transitionElement instanceof Stop) {
            Stop stopElement = (Stop)transitionElement;
            String restartOn = stopElement.getRestart();
            String exitStatusFromJSL = stopElement.getExitStatus();
            logger.fine("Next transition element is a <stop> : " + transitionElement + " with restartOn=" + restartOn + " , and JSL exit status = " + exitStatusFromJSL);
            this.updateExitStatusFromJSL(exitStatusFromJSL);
            this.jslStop(restartOn);
        } else if (transitionElement instanceof End) {
            End endElement = (End)transitionElement;
            String exitStatusFromJSL = endElement.getExitStatus();
            logger.fine("Next transition element is an <end> : " + transitionElement + " with JSL exit status = " + exitStatusFromJSL);
            this.updateExitStatusFromJSL(exitStatusFromJSL);
        } else if (transitionElement instanceof Fail) {
            Fail failElement = (Fail)transitionElement;
            String exitStatusFromJSL = failElement.getExitStatus();
            logger.fine("Next transition element is a <fail> : " + transitionElement + " with JSL exit status = " + exitStatusFromJSL);
            this.updateJobBatchStatus(BatchStatus.FAILED);
            this.updateExitStatusFromJSL(exitStatusFromJSL);
        } else {
            throw new IllegalStateException("Not sure how we'd get here...aborting.");
        }
    }

    private void setupListeners() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getJSLJob();
        InjectionReferences injectionRef = new InjectionReferences(this.jobContext, null, null);
        this.listenerFactory = new ListenerFactory(jobModel, injectionRef);
        this.jobExecution.setListenerFactory(this.listenerFactory);
    }

    private void jobListenersBeforeJob() {
        List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
        for (JobListenerProxy listenerProxy : jobListeners) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Invoking beforeJob() on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
            }
            listenerProxy.beforeJob();
        }
    }

    private void jobListenersAfterJob() {
        List<JobListenerProxy> jobListeners = this.listenerFactory.getJobListeners();
        for (JobListenerProxy listenerProxy : jobListeners) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(" Invoking afterJob() on jobListener: " + listenerProxy.getDelegate() + " of type: " + ((JobListener)listenerProxy.getDelegate()).getClass());
            }
            listenerProxy.afterJob();
        }
    }

    private void logWarning(String msg, Throwable t) {
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        logger.warning(msg + " with Throwable message: " + t.getMessage() + ", and stack trace: " + sw.toString());
    }

    private List<StepExecution> getSplitStepExecutions(IExecutionElementController previousElementController) {
        ArrayList<StepExecution> stepExecutions = new ArrayList<StepExecution>();
        if (previousElementController != null) {
            SplitControllerImpl controller = (SplitControllerImpl)previousElementController;
            for (BatchParallelWorkUnit batchWorkUnit : controller.getParallelJobExecs()) {
                StepExecution lastStepExecution = null;
                List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(batchWorkUnit.getJobExecutionImpl().getExecutionId());
                Iterator<StepExecution> i$ = stepExecs.iterator();
                while (i$.hasNext()) {
                    StepExecution stepExecution;
                    lastStepExecution = stepExecution = i$.next();
                }
                stepExecutions.add(lastStepExecution);
            }
        }
        return stepExecutions;
    }

    private StepExecution getLastStepExecution(Step last) {
        StepExecution lastStepExecution = null;
        List<StepExecution> stepExecs = this.persistenceService.getStepExecutionIDListQueryByJobID(this.jobExecution.getExecutionId());
        for (StepExecution stepExecution : stepExecs) {
            if (!last.getId().equals(stepExecution.getStepName())) continue;
            lastStepExecution = stepExecution;
        }
        return lastStepExecution;
    }

    private Step getLastStepInTheFlow(ExecutionElement previousExecutionElement) {
        Flow flow = (Flow)previousExecutionElement;
        Step last = null;
        for (ExecutionElement elem : flow.getExecutionElements()) {
            if (!(elem instanceof Step)) continue;
            last = (Step)elem;
        }
        return last;
    }

    private void batchStatusStopping() {
        this.updateJobBatchStatus(BatchStatus.STOPPING);
        long time = System.currentTimeMillis();
        Timestamp timestamp = new Timestamp(time);
        this.jobExecution.setLastUpdateTime(timestamp);
        this.persistenceService.updateBatchStatusOnly(this.jobExecution.getExecutionId(), BatchStatus.STOPPING, timestamp);
    }

    @Override
    public void stop() {
        if (this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTING) || this.jobContext.getBatchStatus().equals((Object)BatchStatus.STARTED)) {
            this.batchStatusStopping();
            if (this.currentStoppableElementController != null) {
                this.currentStoppableElementController.stop();
            }
        } else {
            logger.info("Stop ignored since batch status for job is already set to: " + this.jobContext.getBatchStatus());
        }
    }

    private void setContextProperties() {
        JSLJob jobModel = this.jobExecution.getJobNavigator().getJSLJob();
        JSLProperties jslProps = jobModel.getProperties();
        if (jslProps != null) {
            Properties contextProps = this.jobContext.getProperties();
            for (Property property : jslProps.getPropertyList()) {
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
    }

    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerQueue = analyzerQueue;
    }

    private void jslStop(String restartOn) {
        logger.fine("Logging JSL stop(): exitStatus = " + this.jobContext.getExitStatus() + ", restartOn = " + restartOn);
        this.batchStatusStopping();
        this.jobStatusService.updateJobStatusFromJSLStop(this.jobInstanceId, restartOn);
    }
}

