/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.artifact.proxy.InjectionReferences;
import com.ibm.jbatch.container.artifact.proxy.PartitionAnalyzerProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionMapperProxy;
import com.ibm.jbatch.container.artifact.proxy.PartitionReducerProxy;
import com.ibm.jbatch.container.artifact.proxy.ProxyFactory;
import com.ibm.jbatch.container.artifact.proxy.StepListenerProxy;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BaseStepControllerImpl;
import com.ibm.jbatch.container.impl.PartitionedStepBuilder;
import com.ibm.jbatch.container.jobinstance.RuntimeJobContextJobExecutionBridge;
import com.ibm.jbatch.container.jsl.CloneUtility;
import com.ibm.jbatch.container.util.BatchParallelWorkUnit;
import com.ibm.jbatch.container.util.BatchPartitionPlan;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.container.validation.ArtifactValidationException;
import com.ibm.jbatch.jsl.model.Analyzer;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.PartitionMapper;
import com.ibm.jbatch.jsl.model.PartitionReducer;
import com.ibm.jbatch.jsl.model.Step;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.api.partition.PartitionPlan;
import javax.batch.api.partition.PartitionReducer;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;

public class PartitionedStepControllerImpl
extends BaseStepControllerImpl {
    private static final String sourceClass = PartitionedStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final int DEFAULT_PARTITION_INSTANCES = 1;
    private static final int DEFAULT_THREADS = 0;
    private PartitionPlan plan = null;
    private int partitions = 1;
    private int threads = 0;
    private Properties[] partitionProperties = null;
    private volatile List<BatchParallelWorkUnit> parallelBatchWorkUnits;
    private PartitionReducerProxy partitionReducerProxy = null;
    int numPreviouslyCompleted = 0;
    private PartitionAnalyzerProxy analyzerProxy = null;
    final List<JSLJob> subJobs = new ArrayList<JSLJob>();
    protected List<StepListenerProxy> stepListeners = null;
    List<BatchParallelWorkUnit> completedWork = new ArrayList<BatchParallelWorkUnit>();
    BlockingQueue<BatchParallelWorkUnit> completedWorkQueue = null;
    BlockingQueue<PartitionDataWrapper> analyzerQueue = null;

    protected PartitionedStepControllerImpl(RuntimeJobContextJobExecutionBridge jobExecutionImpl, Step step) {
        super(jobExecutionImpl, step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.updateBatchStatus(BatchStatus.STOPPING);
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.parallelBatchWorkUnits != null) {
                for (BatchParallelWorkUnit subJob : this.parallelBatchWorkUnits) {
                    try {
                        batchKernel.stopJob(subJob.getJobExecutionImpl().getExecutionId());
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }
            }
        }
    }

    private PartitionPlan generatePartitionPlan() {
        BatchPartitionPlan plan = null;
        Integer previousNumPartitions = null;
        PartitionMapper partitionMapper = this.step.getPartition().getMapper();
        if (this.stepStatus.getNumPartitions() != null) {
            previousNumPartitions = this.stepStatus.getNumPartitions();
        }
        if (partitionMapper != null) {
            PartitionMapperProxy partitionMapperProxy;
            List propertyList = partitionMapper.getProperties() == null ? null : partitionMapper.getProperties().getPropertyList();
            InjectionReferences injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propertyList);
            try {
                partitionMapperProxy = ProxyFactory.createPartitionMapperProxy(partitionMapper.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the PartitionMapper [" + partitionMapper.getRef() + "]", e);
            }
            PartitionPlan mapperPlan = partitionMapperProxy.mapPartitions();
            plan = new BatchPartitionPlan();
            plan.setPartitionsOverride(mapperPlan.getPartitionsOverride());
            if (mapperPlan.getPartitionsOverride() || previousNumPartitions == null) {
                plan.setPartitions(mapperPlan.getPartitions());
            } else {
                plan.setPartitions(previousNumPartitions);
            }
            if (mapperPlan.getThreads() == 0) {
                plan.setThreads(plan.getPartitions());
            } else {
                plan.setThreads(mapperPlan.getThreads());
            }
            plan.setPartitionProperties(mapperPlan.getPartitionProperties());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Partition plan defined by partition mapper: " + plan);
            }
        } else if (this.step.getPartition().getPlan() != null) {
            int numThreads;
            String partitionsAttr = this.step.getPartition().getPlan().getPartitions();
            String threadsAttr = null;
            int numPartitions = Integer.MIN_VALUE;
            Properties[] partitionProps = null;
            if (partitionsAttr != null) {
                try {
                    numPartitions = Integer.parseInt(partitionsAttr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse partition instances value in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr, e);
                }
                partitionProps = new Properties[numPartitions];
                if (numPartitions < 1) {
                    throw new IllegalArgumentException("Partition instances value must be 1 or greater in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr);
                }
            }
            if ((threadsAttr = this.step.getPartition().getPlan().getThreads()) != null) {
                try {
                    numThreads = Integer.parseInt(partitionsAttr);
                    if (numThreads == 0) {
                        numThreads = numPartitions;
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse partition threads value in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr, e);
                }
                if (numThreads < 0) {
                    throw new IllegalArgumentException("Threads value must be 0 or greater in stepId: " + this.step.getId() + ", with instances=" + partitionsAttr);
                }
            } else {
                numThreads = numPartitions;
            }
            if (this.step.getPartition().getPlan().getProperties() != null) {
                List jslProperties = this.step.getPartition().getPlan().getProperties();
                for (JSLProperties props : jslProperties) {
                    int targetPartition = Integer.parseInt(props.getPartition());
                    try {
                        partitionProps[targetPartition - 1] = CloneUtility.jslPropertiesToJavaProperties((JSLProperties)props);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new BatchContainerRuntimeException("There are only " + numPartitions + " partition instances, but there are " + jslProperties.size() + " partition properties lists defined.", e);
                    }
                }
            }
            plan = new BatchPartitionPlan();
            plan.setPartitions(numPartitions);
            plan.setThreads(numThreads);
            plan.setPartitionProperties(partitionProps);
            plan.setPartitionsOverride(false);
        }
        this.partitions = plan.getPartitions();
        this.threads = plan.getThreads();
        this.partitionProperties = plan.getPartitionProperties();
        return plan;
    }

    @Override
    protected void invokeCoreStep() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException {
        this.plan = this.generatePartitionPlan();
        this.stepStatus.setNumPartitions(this.plan.getPartitions());
        if (this.plan.getPartitionsOverride() && this.partitionReducerProxy != null) {
            this.partitionReducerProxy.rollbackPartitionedStep();
        }
        logger.fine("Number of partitions in step: " + this.partitions + " in step " + this.step.getId() + "; Subjob properties defined by partition mapper: " + this.partitionProperties);
        if (this.analyzerProxy != null) {
            this.analyzerQueue = new LinkedBlockingQueue<PartitionDataWrapper>();
        }
        this.completedWorkQueue = new LinkedBlockingQueue<BatchParallelWorkUnit>();
        this.buildSubJobBatchWorkUnits();
        this.executeAndWaitForCompletion();
        this.checkCompletedWork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildSubJobBatchWorkUnits() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException {
        List<JSLJob> list = this.subJobs;
        synchronized (list) {
            if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
                logger.fine("Step already in STOPPING state, exiting from buildSubJobBatchWorkUnits() before beginning execution");
                return;
            }
            for (int instance = 0; instance < this.partitions; ++instance) {
                this.subJobs.add(PartitionedStepBuilder.buildSubJob(this.jobExecutionImpl.getInstanceId(), this.jobExecutionImpl.getJobContext(), this.step, instance));
            }
            this.parallelBatchWorkUnits = this.stepStatus.getStartCount() > 1 && !this.plan.getPartitionsOverride() ? batchKernel.buildRestartableParallelJobs(this.subJobs, this.partitionProperties, this.analyzerQueue, this.completedWorkQueue, null) : batchKernel.buildNewParallelJobs(this.subJobs, this.partitionProperties, this.analyzerQueue, this.completedWorkQueue, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeAndWaitForCompletion() throws JobRestartException {
        if (this.jobExecutionImpl.getJobContext().getBatchStatus().equals((Object)BatchStatus.STOPPING)) {
            logger.fine("Step already in STOPPING state, exiting from executeAndWaitForCompletion() before beginning execution");
            return;
        }
        int numTotalForThisExcecution = this.parallelBatchWorkUnits.size();
        this.numPreviouslyCompleted = this.partitions - numTotalForThisExcecution;
        int numCurrentCompleted = 0;
        int numCurrentSubmitted = 0;
        logger.fine("Calculated that " + this.numPreviouslyCompleted + " partitions are already complete out of total # = " + this.partitions + ", with # remaining =" + numTotalForThisExcecution);
        for (int i = 0; i < this.threads && i < numTotalForThisExcecution; ++i, ++numCurrentSubmitted) {
            if (this.stepStatus.getStartCount() > 1 && !this.plan.getPartitionsOverride()) {
                batchKernel.restartGeneratedJob(this.parallelBatchWorkUnits.get(i));
                continue;
            }
            batchKernel.startGeneratedJob(this.parallelBatchWorkUnits.get(i));
        }
        boolean readyToSubmitAnother = false;
        while (true) {
            logger.finer("Begin main loop in waitForQueueCompletion(), readyToSubmitAnother = " + readyToSubmitAnother);
            try {
                if (this.analyzerProxy != null) {
                    logger.fine("Found analyzer, proceeding on analyzerQueue path");
                    PartitionDataWrapper dataWrapper = this.analyzerQueue.take();
                    if (PartitionDataWrapper.PartitionEventType.ANALYZE_COLLECTOR_DATA.equals((Object)dataWrapper.getEventType())) {
                        logger.finer("Analyze collector data: " + dataWrapper.getCollectorData());
                        this.analyzerProxy.analyzeCollectorData(dataWrapper.getCollectorData());
                        continue;
                    }
                    if (!PartitionDataWrapper.PartitionEventType.ANALYZE_STATUS.equals((Object)dataWrapper.getEventType())) {
                        logger.warning("Invalid partition state");
                        throw new IllegalStateException("Invalid partition state");
                    }
                    this.analyzerProxy.analyzeStatus(dataWrapper.getBatchstatus(), dataWrapper.getExitStatus());
                    logger.fine("Analyze status called for completed partition: batchStatus= " + dataWrapper.getBatchstatus() + ", exitStatus = " + dataWrapper.getExitStatus());
                    this.completedWork.add(this.completedWorkQueue.take());
                    readyToSubmitAnother = true;
                } else {
                    logger.fine("No analyzer, proceeding on analyzerQueue path");
                    this.completedWork.add(this.completedWorkQueue.take());
                    readyToSubmitAnother = true;
                }
            }
            catch (InterruptedException e) {
                logger.severe("Caught exc" + e);
                throw new BatchContainerRuntimeException(e);
            }
            if (readyToSubmitAnother) {
                logger.fine("Ready to submit another (if there is another left to submit); numCurrentCompleted = " + ++numCurrentCompleted);
                if (numCurrentCompleted >= numTotalForThisExcecution) {
                    logger.fine("Finished... breaking out of loop");
                    return;
                }
                if (numCurrentSubmitted >= numTotalForThisExcecution) continue;
                logger.fine("Submitting # " + ++numCurrentSubmitted + " out of " + numTotalForThisExcecution + " total for this execution");
                if (this.stepStatus.getStartCount() > 1) {
                    batchKernel.startGeneratedJob(this.parallelBatchWorkUnits.get(numCurrentSubmitted));
                } else {
                    batchKernel.restartGeneratedJob(this.parallelBatchWorkUnits.get(numCurrentSubmitted));
                }
                readyToSubmitAnother = false;
                continue;
            }
            logger.fine("Not ready to submit another.");
        }
    }

    private void checkCompletedWork() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Check completed work list.");
        }
        boolean rollback = false;
        boolean partitionFailed = false;
        for (BatchParallelWorkUnit subJob : this.completedWork) {
            BatchStatus batchStatus = subJob.getJobExecutionImpl().getJobContext().getBatchStatus();
            if (batchStatus.equals((Object)BatchStatus.FAILED)) {
                logger.fine("Subjob " + subJob.getJobExecutionImpl().getExecutionId() + " ended with status '" + batchStatus + "'; Starting logical transaction rollback.");
                rollback = true;
                partitionFailed = true;
                this.stepContext.setBatchStatus(BatchStatus.FAILED);
                continue;
            }
            if (!batchStatus.equals((Object)BatchStatus.STOPPED)) continue;
            logger.fine("Subjob " + subJob.getJobExecutionImpl().getExecutionId() + "ended with status '" + batchStatus + "'; Starting logical transaction rollback.");
            rollback = true;
            if (BatchStatus.FAILED.equals((Object)this.stepContext.getBatchStatus())) continue;
            this.updateBatchStatus(BatchStatus.STOPPING);
        }
        if (rollback) {
            if (this.partitionReducerProxy != null) {
                this.partitionReducerProxy.rollbackPartitionedStep();
            }
            if (partitionFailed) {
                throw new BatchContainerRuntimeException("One or more partitions failed");
            }
        } else if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.beforePartitionedStepCompletion();
        }
    }

    @Override
    protected void setupStepArtifacts() {
        PartitionReducer partitionReducer;
        InjectionReferences injectionRef = null;
        injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, null);
        this.stepListeners = this.jobExecutionImpl.getListenerFactory().getStepListeners(this.step, injectionRef, this.stepContext);
        Analyzer analyzer = this.step.getPartition().getAnalyzer();
        if (analyzer != null) {
            List propList = analyzer.getProperties() == null ? null : analyzer.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            try {
                this.analyzerProxy = ProxyFactory.createPartitionAnalyzerProxy(analyzer.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the analyzer [" + analyzer.getRef() + "]", e);
            }
        }
        if ((partitionReducer = this.step.getPartition().getReducer()) != null) {
            List propList = partitionReducer.getProperties() == null ? null : partitionReducer.getProperties().getPropertyList();
            injectionRef = new InjectionReferences(this.jobExecutionImpl.getJobContext(), this.stepContext, propList);
            try {
                this.partitionReducerProxy = ProxyFactory.createPartitionReducerProxy(partitionReducer.getRef(), injectionRef, this.stepContext);
            }
            catch (ArtifactValidationException e) {
                throw new BatchContainerServiceException("Cannot create the analyzer [" + partitionReducer.getRef() + "]", e);
            }
        }
    }

    @Override
    protected void invokePreStepArtifacts() {
        if (this.stepListeners == null) {
            return;
        }
        for (StepListenerProxy listenerProxy : this.stepListeners) {
            listenerProxy.beforeStep();
        }
        if (this.partitionReducerProxy != null) {
            this.partitionReducerProxy.beginPartitionedStep();
        }
    }

    @Override
    protected void invokePostStepArtifacts() {
        if (this.partitionReducerProxy != null) {
            if (BatchStatus.COMPLETED.equals((Object)this.stepContext.getBatchStatus())) {
                this.partitionReducerProxy.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.COMMIT);
            } else {
                this.partitionReducerProxy.afterPartitionedStepCompletion(PartitionReducer.PartitionStatus.ROLLBACK);
            }
        }
        if (this.stepListeners == null) {
            return;
        }
        for (StepListenerProxy listenerProxy : this.stepListeners) {
            listenerProxy.afterStep();
        }
    }

    @Override
    protected void sendStatusFromPartitionToAnalyzerIfPresent() {
    }
}

