/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IExecutionElementController;
import com.ibm.jbatch.container.context.impl.StepContextImpl;
import com.ibm.jbatch.container.exception.BatchContainerRuntimeException;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.impl.BatchletStepControllerImpl;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.jobinstance.StepExecutionImpl;
import com.ibm.jbatch.container.persistence.PersistentDataWrapper;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobStatusManagerService;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.status.ExecutionStatus;
import com.ibm.jbatch.container.status.ExtendedBatchStatus;
import com.ibm.jbatch.container.status.StepStatus;
import com.ibm.jbatch.container.util.PartitionDataWrapper;
import com.ibm.jbatch.jsl.model.JSLProperties;
import com.ibm.jbatch.jsl.model.Property;
import com.ibm.jbatch.jsl.model.Step;
import com.ibm.jbatch.spi.services.ITransactionManagementService;
import com.ibm.jbatch.spi.services.TransactionManagerAdapter;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobStartException;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.Metric;

public abstract class BaseStepControllerImpl
implements IExecutionElementController {
    private static final String sourceClass = BatchletStepControllerImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    protected RuntimeJobExecution jobExecutionImpl;
    protected JobInstance jobInstance;
    protected StepContextImpl stepContext;
    protected Step step;
    protected StepStatus stepStatus;
    protected BlockingQueue<PartitionDataWrapper> analyzerStatusQueue = null;
    protected long rootJobExecutionId;
    protected static IBatchKernelService batchKernel = ServicesManagerImpl.getInstance().getBatchKernelService();
    protected TransactionManagerAdapter transactionManager = null;
    private static IPersistenceManagerService _persistenceManagementService = ServicesManagerImpl.getInstance().getPersistenceManagerService();
    private static IJobStatusManagerService _jobStatusService = ServicesManagerImpl.getInstance().getJobStatusManagerService();

    protected BaseStepControllerImpl(RuntimeJobExecution jobExecution, Step step, StepContextImpl stepContext, long rootJobExecutionId) {
        this.jobExecutionImpl = jobExecution;
        this.jobInstance = jobExecution.getJobInstance();
        this.stepContext = stepContext;
        this.rootJobExecutionId = rootJobExecutionId;
        if (step == null) {
            throw new IllegalArgumentException("Step parameter to ctor cannot be null.");
        }
        this.step = step;
    }

    protected BaseStepControllerImpl(RuntimeJobExecution jobExecution, Step step, StepContextImpl stepContext, long rootJobExecutionId, BlockingQueue<PartitionDataWrapper> analyzerStatusQueue) {
        this(jobExecution, step, stepContext, rootJobExecutionId);
        this.analyzerStatusQueue = analyzerStatusQueue;
    }

    protected abstract void invokeCoreStep() throws JobRestartException, JobStartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException;

    protected abstract void setupStepArtifacts();

    protected abstract void invokePreStepArtifacts();

    protected abstract void invokePostStepArtifacts();

    protected abstract void sendStatusFromPartitionToAnalyzerIfPresent();

    @Override
    public ExecutionStatus execute() {
        PrintWriter pw;
        StringWriter sw;
        try {
            boolean executeStep = this.shouldStepBeExecuted();
            if (!executeStep) {
                logger.fine("Not going to run this step.  Returning previous exit status of: " + this.stepStatus.getExitStatus());
                return new ExecutionStatus(ExtendedBatchStatus.DO_NOT_RUN, this.stepStatus.getExitStatus());
            }
        }
        catch (Throwable t) {
            this.markJobAndStepFailed();
            this.rethrowWithWarning("Caught throwable while determining if step should be executed.  Failing job.", t);
        }
        try {
            this.startStep();
        }
        catch (Throwable t) {
            this.markJobAndStepFailed();
            this.rethrowWithWarning("Caught throwable while starting step.  Failing job.", t);
        }
        try {
            this.invokePreStepArtifacts();
            this.invokeCoreStep();
        }
        catch (Exception e) {
            try {
                sw = new StringWriter();
                pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                logger.warning("Caught exception executing step: " + sw.toString());
                this.markStepFailed();
            }
            catch (Throwable t) {
                StringWriter sw2 = new StringWriter();
                PrintWriter pw2 = new PrintWriter(sw2);
                t.printStackTrace(pw2);
                this.rethrowWithSevere("ERROR. PERSISTING BATCH STATUS FAILED.  STEP EXECUTION STATUS TABLES MIGHT HAVE CONSISTENCY ISSUESAND/OR UNEXPECTED ENTRIES.", t);
            }
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            logger.warning("Failing both step AND job after catching error executing step: " + sw.toString());
            this.markJobAndStepFailed();
        }
        try {
            this.invokePostStepArtifacts();
        }
        catch (Throwable t) {
            sw = new StringWriter();
            pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            logger.warning("Error invoking end of step artifacts. Stack trace: " + sw.toString());
            this.markStepFailed();
        }
        try {
            this.persistUserData();
            this.transitionToFinalBatchStatus();
            this.defaultExitStatusIfNecessary();
            this.persistExitStatusAndEndTimestamp();
        }
        catch (Throwable t) {
            this.markJobAndStepFailed();
            this.rethrowWithWarning("Failure ending step execution", t);
        }
        this.sendStatusFromPartitionToAnalyzerIfPresent();
        logger.finer("Returning step batchStatus: " + this.stepStatus.getBatchStatus() + ", exitStatus: " + this.stepStatus.getExitStatus());
        if (this.stepStatus.getBatchStatus().equals((Object)BatchStatus.FAILED)) {
            return new ExecutionStatus(ExtendedBatchStatus.EXCEPTION_THROWN, this.stepStatus.getExitStatus());
        }
        return new ExecutionStatus(ExtendedBatchStatus.NORMAL_COMPLETION, this.stepStatus.getExitStatus());
    }

    private void defaultExitStatusIfNecessary() {
        String stepExitStatus = this.stepContext.getExitStatus();
        String processRetVal = this.stepContext.getBatchletProcessRetVal();
        if (stepExitStatus != null) {
            logger.fine("Returning with user-set exit status: " + stepExitStatus);
        } else if (processRetVal != null) {
            logger.fine("Returning with exit status from batchlet.process(): " + processRetVal);
            this.stepContext.setExitStatus(processRetVal);
        } else {
            logger.fine("Returning with default exit status");
            this.stepContext.setExitStatus(this.stepContext.getBatchStatus().name());
        }
    }

    private void markStepFailed() {
        this.updateBatchStatus(BatchStatus.FAILED);
    }

    protected void markJobAndStepFailed() {
        this.jobExecutionImpl.getJobContext().setBatchStatus(BatchStatus.FAILED);
        this.markStepFailed();
    }

    private void startStep() {
        this.statusStarting();
        this.setContextProperties();
        this.setupStepArtifacts();
        this.updateBatchStatus(BatchStatus.STARTED);
        long time = System.currentTimeMillis();
        Timestamp startTS = new Timestamp(time);
        this.stepContext.setStartTime(startTS);
        _persistenceManagementService.updateStepExecution(this.rootJobExecutionId, this.stepContext);
    }

    private void transitionToFinalBatchStatus() {
        BatchStatus currentBatchStatus = this.stepContext.getBatchStatus();
        if (currentBatchStatus.equals((Object)BatchStatus.STARTED)) {
            this.updateBatchStatus(BatchStatus.COMPLETED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.STOPPING)) {
            this.updateBatchStatus(BatchStatus.STOPPED);
        } else if (currentBatchStatus.equals((Object)BatchStatus.FAILED)) {
            this.updateBatchStatus(BatchStatus.FAILED);
        } else {
            throw new IllegalStateException("Step batch status should not be in a " + currentBatchStatus.name() + " state");
        }
    }

    protected void updateBatchStatus(BatchStatus updatedBatchStatus) {
        logger.fine("Updating batch status from : " + this.stepStatus.getBatchStatus() + ", to: " + updatedBatchStatus);
        this.stepStatus.setBatchStatus(updatedBatchStatus);
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(updatedBatchStatus);
    }

    protected boolean shouldStepBeExecuted() {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("In shouldStepBeExecuted() with stepContext =  " + this.stepContext);
        }
        this.stepStatus = _jobStatusService.getStepStatus(this.jobInstance.getInstanceId(), this.step.getId());
        if (this.stepStatus == null) {
            logger.finer("No existing step status found.  Create new step execution and proceed to execution.");
            StepExecutionImpl stepExecution = this.getNewStepExecution(this.rootJobExecutionId, this.stepContext);
            this.stepStatus = _jobStatusService.createStepStatus(stepExecution.getStepExecutionId());
            this.stepContext.setStepExecutionId(stepExecution.getStepExecutionId());
            return true;
        }
        logger.finer("Existing step status found.");
        this.stepContext.setPersistentUserData(this.stepStatus.getPersistentUserData());
        if (this.shouldStepBeExecutedOnRestart()) {
            this.stepStatus.incrementStartCount();
            StepExecutionImpl stepExecution = this.getNewStepExecution(this.rootJobExecutionId, this.stepContext);
            this.stepStatus.setLastRunStepExecutionId(stepExecution.getStepExecutionId());
            this.stepContext.setStepExecutionId(stepExecution.getStepExecutionId());
            return true;
        }
        return false;
    }

    private boolean shouldStepBeExecutedOnRestart() {
        BatchStatus stepBatchStatus = this.stepStatus.getBatchStatus();
        if (stepBatchStatus.equals((Object)BatchStatus.COMPLETED)) {
            if (!Boolean.parseBoolean(this.step.getAllowStartIfComplete())) {
                logger.fine("Step: " + this.step.getId() + " already has batch status of COMPLETED, so won't be run again since it does not allow start if complete.");
                return false;
            }
            logger.fine("Step: " + this.step.getId() + " already has batch status of COMPLETED, and allow-start-if-complete is set to 'true'");
        }
        int startLimit = 0;
        String startLimitString = this.step.getStartLimit();
        if (startLimitString != null) {
            try {
                startLimit = Integer.parseInt(startLimitString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Could not parse start limit value.  Received NumberFormatException for start-limit value:  " + startLimitString + " for stepId: " + this.step.getId() + ", with start-limit=" + this.step.getStartLimit());
            }
        }
        if (startLimit < 0) {
            throw new IllegalArgumentException("Found negative start-limit of " + startLimit + "for stepId: " + this.step.getId());
        }
        if (startLimit > 0) {
            int newStepStartCount = this.stepStatus.getStartCount() + 1;
            if (newStepStartCount > startLimit) {
                throw new IllegalStateException("For stepId: " + this.step.getId() + ", tried to start step for the " + newStepStartCount + " time, but startLimit = " + startLimit);
            }
            logger.fine("Starting (possibly restarting) step: " + this.step.getId() + ", since newStepStartCount = " + newStepStartCount + " and startLimit=" + startLimit);
        }
        return true;
    }

    protected void statusStarting() {
        this.stepStatus.setBatchStatus(BatchStatus.STARTING);
        _jobStatusService.updateJobCurrentStep(this.jobInstance.getInstanceId(), this.step.getId());
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        this.stepContext.setBatchStatus(BatchStatus.STARTING);
    }

    protected void persistUserData() {
        ByteArrayOutputStream persistentBAOS = new ByteArrayOutputStream();
        ObjectOutputStream persistentDataOOS = null;
        try {
            persistentDataOOS = new ObjectOutputStream(persistentBAOS);
            persistentDataOOS.writeObject(this.stepContext.getPersistentUserData());
            persistentDataOOS.close();
        }
        catch (Exception e) {
            throw new BatchContainerServiceException("Cannot persist the persistent user data for the step.", e);
        }
        this.stepStatus.setPersistentUserData(new PersistentDataWrapper(persistentBAOS.toByteArray()));
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
    }

    protected void persistExitStatusAndEndTimestamp() {
        this.stepStatus.setExitStatus(this.stepContext.getExitStatus());
        _jobStatusService.updateStepStatus(this.stepStatus.getStepExecutionId(), this.stepStatus);
        long time = System.currentTimeMillis();
        Timestamp endTS = new Timestamp(time);
        this.stepContext.setEndTime(endTS);
        _persistenceManagementService.updateStepExecution(this.rootJobExecutionId, this.stepContext);
    }

    private StepExecutionImpl getNewStepExecution(long rootJobExecutionId, StepContextImpl stepContext) {
        return _persistenceManagementService.createStepExecution(rootJobExecutionId, stepContext);
    }

    private void setContextProperties() {
        JSLProperties jslProps = this.step.getProperties();
        if (jslProps != null) {
            for (Property property : jslProps.getPropertyList()) {
                Properties contextProps = this.stepContext.getProperties();
                contextProps.setProperty(property.getName(), property.getValue());
            }
        }
        this.stepContext.addMetric(Metric.MetricType.READ_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.WRITE_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.READ_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.PROCESS_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.WRITE_SKIP_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.FILTER_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.COMMIT_COUNT, 0L);
        this.stepContext.addMetric(Metric.MetricType.ROLLBACK_COUNT, 0L);
        ITransactionManagementService transMgr = ServicesManagerImpl.getInstance().getTransactionManagementService();
        this.transactionManager = transMgr.getTransactionManager(this.stepContext);
    }

    public void setStepContext(StepContextImpl stepContext) {
        this.stepContext = stepContext;
    }

    protected BlockingQueue<PartitionDataWrapper> getAnalyzerQueue() {
        return this.analyzerStatusQueue;
    }

    public void setAnalyzerQueue(BlockingQueue<PartitionDataWrapper> analyzerQueue) {
        this.analyzerStatusQueue = analyzerQueue;
    }

    @Override
    public List<Long> getLastRunStepExecutions() {
        ArrayList<Long> stepExecIdList = new ArrayList<Long>(1);
        stepExecIdList.add(this.stepStatus.getLastRunStepExecutionId());
        return stepExecIdList;
    }

    private void rethrowWithMsg(String msgBeginning, Throwable t, Level level) {
        String errorMsg = msgBeginning + " ; Caught exception/error: " + t.getLocalizedMessage();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        logger.log(level, errorMsg + " : Stack trace: " + sw.toString());
        throw new BatchContainerRuntimeException(errorMsg, t);
    }

    private void rethrowWithWarning(String msgBeginning, Throwable t) {
        this.rethrowWithMsg(msgBeginning, t, Level.WARNING);
    }

    private void rethrowWithSevere(String msgBeginning, Throwable t) {
        this.rethrowWithMsg(msgBeginning, t, Level.SEVERE);
    }

    public String toString() {
        return "BaseStepControllerImpl for step = " + this.step.getId();
    }
}

