/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.jobinstance;

import com.ibm.jbatch.container.artifact.proxy.ListenerFactory;
import com.ibm.jbatch.container.context.impl.JobContextImpl;
import com.ibm.jbatch.container.jobinstance.JobOperatorJobExecution;
import com.ibm.jbatch.container.navigator.ModelNavigator;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.jsl.model.JSLJob;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import javax.batch.runtime.JobInstance;

public class RuntimeJobExecution {
    private ModelNavigator<JSLJob> jobNavigator = null;
    private JobInstance jobInstance;
    private long executionId;
    private String restartOn;
    private JobContextImpl jobContext = null;
    private ListenerFactory listenerFactory;
    private IJobExecution operatorJobExecution = null;

    public RuntimeJobExecution(JobInstance jobInstance, long executionId) {
        this.jobInstance = jobInstance;
        this.executionId = executionId;
        this.operatorJobExecution = new JobOperatorJobExecution(executionId, jobInstance.getInstanceId());
    }

    public void prepareForExecution(JobContextImpl jobContext, String restartOn) {
        this.jobContext = jobContext;
        this.jobNavigator = jobContext.getNavigator();
        jobContext.setExecutionId(this.executionId);
        jobContext.setInstanceId(this.jobInstance.getInstanceId());
        this.restartOn = restartOn;
        this.operatorJobExecution.setJobContext(jobContext);
    }

    public void prepareForExecution(JobContextImpl jobContext) {
        this.prepareForExecution(jobContext, null);
    }

    public void setRestartOn(String restartOn) {
        this.restartOn = restartOn;
    }

    public long getExecutionId() {
        return this.executionId;
    }

    public long getInstanceId() {
        return this.jobInstance.getInstanceId();
    }

    public JobInstance getJobInstance() {
        return this.jobInstance;
    }

    public ModelNavigator<JSLJob> getJobNavigator() {
        return this.jobNavigator;
    }

    public JobContextImpl getJobContext() {
        return this.jobContext;
    }

    public String getRestartOn() {
        return this.restartOn;
    }

    public ListenerFactory getListenerFactory() {
        return this.listenerFactory;
    }

    public void setListenerFactory(ListenerFactory listenerFactory) {
        this.listenerFactory = listenerFactory;
    }

    public IJobExecution getJobOperatorJobExecution() {
        return this.operatorJobExecution;
    }

    public BatchStatus getBatchStatus() {
        return this.jobContext.getBatchStatus();
    }

    public String getExitStatus() {
        return this.jobContext.getExitStatus();
    }

    public void setBatchStatus(String status) {
        this.operatorJobExecution.setBatchStatus(status);
    }

    public void setCreateTime(Timestamp ts) {
        this.operatorJobExecution.setCreateTime(ts);
    }

    public void setEndTime(Timestamp ts) {
        this.operatorJobExecution.setEndTime(ts);
    }

    public void setExitStatus(String status) {
        this.operatorJobExecution.setExitStatus(status);
    }

    public void setLastUpdateTime(Timestamp ts) {
        this.operatorJobExecution.setLastUpdateTime(ts);
    }

    public void setStartTime(Timestamp ts) {
        this.operatorJobExecution.setStartTime(ts);
    }

    public void setJobParameters(Properties jProps) {
        this.operatorJobExecution.setJobParameters(jProps);
    }

    public Properties getJobParameters() {
        return this.operatorJobExecution.getJobParameters();
    }

    public Date getStartTime() {
        return this.operatorJobExecution.getStartTime();
    }

    public Date getEndTime() {
        return this.operatorJobExecution.getEndTime();
    }

    public Date getLastUpdatedTime() {
        return this.operatorJobExecution.getLastUpdatedTime();
    }

    public Date getCreateTime() {
        return this.operatorJobExecution.getCreateTime();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(" executionId: " + this.executionId);
        buf.append(" restartOn: " + this.restartOn);
        buf.append("\n-----------------------\n");
        buf.append("jobInstance: \n   " + this.jobInstance);
        return buf.toString();
    }
}

