/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.ConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.InventoryRecord;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import javax.batch.api.chunk.AbstractItemWriter;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="inventoryInitWriter")
public class InventoryInitWriter
extends AbstractItemWriter {
    protected DataSource dataSource = null;

    public void open(Serializable cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
    }

    public void writeItems(List<Object> records) throws Exception {
        int itemID = -1;
        int quantity = -1;
        for (Object record : records) {
            itemID = ((InventoryRecord)record).getItemID();
            quantity = ((InventoryRecord)record).getQuantity();
        }
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("delete from Orders where orderID > 0");
            int rs = statement.executeUpdate();
            ConnectionHelper.cleanupConnection(connection, null, statement);
            connection = ConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("update inventory set quantity = ? where itemID = ?");
            statement.setInt(2, itemID);
            statement.setInt(1, quantity);
            rs = statement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanupConnection(connection, null, statement);
                throw throwable;
            }
        }
        ConnectionHelper.cleanupConnection(connection, null, statement);
    }
}

