/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.RetryConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersRecord;
import com.ibm.jbatch.tck.artifacts.reusable.MyParentException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.AbstractItemReader;
import javax.batch.runtime.context.StepContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.testng.Reporter;

@Named(value="numbersReader")
public class NumbersReader
extends AbstractItemReader {
    private static final String CLASSNAME = NumbersReader.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    protected DataSource dataSource = null;
    private static final int STATE_NORMAL = 0;
    private static final int STATE_RETRY = 1;
    private int testState = 0;
    @Inject
    StepContext stepCtx;
    @Inject
    @BatchProperty(name="forced.fail.count.read")
    String forcedFailCountProp;
    int forcedFailCount;
    int dummyDelay;
    int expectedReaderChkp = -1;
    int readerIndex = 1;
    int failindex = 0;
    NumbersCheckpointData numbersCheckpoint = new NumbersCheckpointData();

    public void open(Serializable cpd) throws NamingException {
        NumbersCheckpointData numbersCheckpointData = (NumbersCheckpointData)cpd;
        this.forcedFailCount = Integer.parseInt(this.forcedFailCountProp);
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
        if (cpd != null) {
            this.forcedFailCount = 0;
            this.readerIndex = numbersCheckpointData.getCount();
            this.stepCtx.getProperties().setProperty("init.checkpoint", this.readerIndex + "");
        }
    }

    public NumbersRecord readItem() throws Exception {
        NumbersRecord numbersRecord;
        int i = this.readerIndex;
        if (this.forcedFailCount != 0 && this.readerIndex >= this.forcedFailCount) {
            this.forcedFailCount = 0;
            this.failindex = this.readerIndex;
            this.testState = 1;
            Reporter.log((String)"Fail on purpose NumbersRecord.readItem<p>");
            throw new MyParentException("Fail on purpose in NumbersRecord.readItem()");
        }
        if (this.testState == 1) {
            if (this.stepCtx.getProperties().getProperty("retry.read.exception.invoked") != "true") {
                Reporter.log((String)"onRetryReadException not invoked<p>");
                throw new Exception("onRetryReadException not invoked");
            }
            if (this.stepCtx.getProperties().getProperty("retry.read.exception.match") != "true") {
                Reporter.log((String)"retryable exception does not match");
                throw new Exception("retryable exception does not match");
            }
            this.testState = 0;
        }
        if (this.readerIndex > 5) {
            return null;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = RetryConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select item, quantity from numbers where item = ?");
            statement.setInt(1, this.readerIndex);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
            }
            ++this.readerIndex;
            numbersRecord = new NumbersRecord(i, quantity);
        }
        catch (SQLException e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                RetryConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        RetryConnectionHelper.cleanupConnection(connection, rs, statement);
        return numbersRecord;
    }

    public Serializable checkpointInfo() throws Exception {
        NumbersCheckpointData _chkptData = new NumbersCheckpointData();
        _chkptData.setCount(this.readerIndex);
        this.stepCtx.getProperties().setProperty("checkpoint.index", Integer.toString(this.readerIndex));
        return _chkptData;
    }
}

