/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.artifacts.chunkartifacts;

import com.ibm.jbatch.tck.artifacts.chunkartifacts.RetryConnectionHelper;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersCheckpointData;
import com.ibm.jbatch.tck.artifacts.chunktypes.NumbersRecord;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.batch.api.chunk.AbstractItemReader;
import javax.inject.Named;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@Named(value="retryInitReader")
public class RetryInitReader
extends AbstractItemReader {
    protected DataSource dataSource = null;
    private int count = 0;

    public void open(Serializable cpd) throws NamingException {
        InitialContext ctx = new InitialContext();
        this.dataSource = (DataSource)ctx.lookup("jdbc/orderDB");
    }

    public NumbersRecord readItem() throws SQLException {
        NumbersRecord numbersRecord;
        if (this.count > 19) {
            return null;
        }
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = RetryConnectionHelper.getConnection(this.dataSource);
            statement = connection.prepareStatement("select item, quantity from numbers where item = ?");
            statement.setInt(1, 1);
            rs = statement.executeQuery();
            int quantity = -1;
            while (rs.next()) {
                quantity = rs.getInt("quantity");
                ++this.count;
            }
            numbersRecord = new NumbersRecord(this.count, quantity);
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                RetryConnectionHelper.cleanupConnection(connection, rs, statement);
                throw throwable;
            }
        }
        RetryConnectionHelper.cleanupConnection(connection, rs, statement);
        return numbersRecord;
    }

    public Serializable checkpointInfo() {
        NumbersCheckpointData chkpData = new NumbersCheckpointData();
        chkpData.setCount(this.count);
        return chkpData;
    }
}

