/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.test;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLComms;
import com.mdfromhtml.core.MDfromHTMLConstants;
import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class TestWebServicesMD {
    JSONObject _htmlFilters = new JSONObject();

    public TestWebServicesMD() {
        String htmlFiltersFilename = "." + File.separator + "properties" + File.separator + "HTML_Filters.json";
        while (true) {
            String test;
            if ("q".equalsIgnoreCase(test = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path of the HTML filters file (\"" + htmlFiltersFilename + "\" or q to quit:")))) {
                System.out.println("Goodbye");
                System.exit(0);
            }
            if (test.length() == 0) {
                test = htmlFiltersFilename;
            }
            htmlFiltersFilename = test;
            try {
                this._htmlFilters = MDfromHTMLUtils.loadJSONFile((String)htmlFiltersFilename);
            }
            catch (Exception e) {
                System.err.println("Could not load the HTML filters file \"" + htmlFiltersFilename + "\". " + e.getLocalizedMessage() + ". Try again.");
                continue;
            }
            break;
        }
    }

    public static void main(String[] args) {
        TestWebServicesMD pgm = new TestWebServicesMD();
        boolean quit = false;
        while (!quit) {
            int actionVal = 1;
            try {
                switch (actionVal) {
                    case 1: {
                        JSONObject response = pgm.getMarkdownFromHTML();
                        if (response.size() == 0) {
                            System.out.println("Request aborted.");
                            quit = true;
                            break;
                        }
                        System.out.println("Full Response:\n" + response.serialize(true));
                        System.out.println("\n--------- cut markdown below ----------\n");
                        System.out.println(((JSONObject)response.get((Object)"results")).get((Object)"markdown"));
                        System.out.println("\n--------- end markdown cutting --------\n");
                        break;
                    }
                    default: {
                        System.err.println("The action you entered is not equal to 1. Try again.");
                        break;
                    }
                }
            }
            catch (IOException | NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        System.out.println("Goodbye");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getMarkdownFromHTML() {
        String mdfromhtmlWebServicesFile = MDfromHTMLConstants.MDfromHTML_DIR_PROPERTIES + "MDfromHTMLWebService.properties";
        JSONObject response = new JSONObject();
        String htmlFile = "./src/test/resources/Archive0001.json";
        String servicename = "localhost";
        while (true) {
            File testFile;
            String propertiesFilename;
            if ((propertiesFilename = MDfromHTMLUtils.prompt((String)("Enter the fully qualified filename of the web service properties file (" + mdfromhtmlWebServicesFile + ") or q  to quit:"))).length() == 0) {
                propertiesFilename = mdfromhtmlWebServicesFile;
            }
            if ("q".equalsIgnoreCase(propertiesFilename)) break;
            Properties propFile = new Properties();
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(propertiesFilename);
                propFile.load(fis);
            }
            catch (IOException ioe) {
                System.out.println("Can not load " + propertiesFilename + " Error: " + ioe.getLocalizedMessage());
                continue;
            }
            finally {
                if (fis == null) continue;
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            String filename = MDfromHTMLUtils.prompt((String)("Enter the fully qualified filename of the HTML json file whose html is to be transformed to markdown (" + htmlFile + ") or q to quit:"));
            if ("q".equalsIgnoreCase(filename)) break;
            if (filename.length() == 0) {
                filename = htmlFile;
            }
            if (!(testFile = new File(filename)).exists()) {
                System.err.println("Filename \"" + filename + "\" does not exist. Try again.");
                continue;
            }
            if (testFile.isDirectory()) {
                System.err.println("Filename \"" + filename + "\" is a directory. Try again.");
                continue;
            }
            String hostname = MDfromHTMLUtils.prompt((String)("Enter the hostname where the service is running or q to quit (" + servicename + ")"));
            if ("q".equalsIgnoreCase(hostname)) break;
            if (hostname.length() == 0) {
                hostname = servicename;
            }
            servicename = hostname;
            try {
                JSONObject htmlObj = MDfromHTMLUtils.loadJSONFile((String)filename);
                htmlFile = filename;
                JSONObject service = new JSONObject();
                service.put("protocol", (Object)propFile.getProperty("protocol", "http"));
                service.put("domain", (Object)propFile.getProperty("hostname", "localhost"));
                service.put("portnumber", (Object)propFile.getProperty("port", "9080"));
                service.put("endpoint", (Object)("/" + propFile.getProperty("servletname", "MDfromHTMLWebServices") + "/" + propFile.getProperty("version", "v1") + "/mdfromhtml/getMarkdown"));
                service.put("username", (Object)propFile.getProperty("username", "mask"));
                service.put("password", (Object)propFile.getProperty("password", "password"));
                service.put("apitimeout", (Object)propFile.getProperty("apitimeout", "100000"));
                JSONObject request = new JSONObject();
                JSONArray captureArray = (JSONArray)htmlObj.get((Object)"captureArray");
                JSONObject firstObj = (JSONObject)captureArray.get(0);
                request.put("html", firstObj.get((Object)"html"));
                request.put("url", firstObj.get((Object)"url"));
                request.put("HTMLFilters", (Object)this._htmlFilters);
                JSONObject params = new JSONObject();
                params.put("request", (Object)request);
                response = MDfromHTMLComms.sendRequest((String)"POST", (JSONObject)service, (JSONObject)params);
            }
            catch (Exception e) {
                System.err.println("Error calling service: " + e.getLocalizedMessage() + ". Try again.");
                System.err.println("Note: you can check the server is running by pasting this in a browser:\nhttp://" + hostname + ":9080/AidenWebServices/v1/HelloAiden");
                continue;
            }
            break;
        }
        return response;
    }
}

