/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.overzealous.remark.Remark;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class FindUnfilteredDomains {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String defaultFileToURLFilename = "." + File.separator + "data" + File.separator + "file_to_url.txt";
        String htmlFiltersFilename = "." + File.separator + "properties" + File.separator + "HTML_Filters.json";
        String fileToURLFilename = "";
        boolean quietMode = false;
        try {
            String tmp;
            if (args.length > 0) {
                htmlFiltersFilename = args[0];
            } else {
                tmp = MDfromHTMLUtils.prompt((String)("Enter the HTML_Filters.json file location or q to quit: (" + htmlFiltersFilename + "):"));
                if (tmp.length() == 0) {
                    tmp = htmlFiltersFilename;
                }
                if ("q".equalsIgnoreCase(tmp)) {
                    System.exit(0);
                }
                htmlFiltersFilename = tmp;
            }
            if (args.length > 1) {
                fileToURLFilename = args[1];
                quietMode = true;
            } else {
                tmp = MDfromHTMLUtils.prompt((String)("Enter the path and filename of the tab delimited file cross referencing file names to URLs or q to quit (" + defaultFileToURLFilename + "):"));
                if (tmp.length() == 0) {
                    tmp = defaultFileToURLFilename;
                }
                if ("q".equalsIgnoreCase(fileToURLFilename)) {
                    System.exit(0);
                }
                fileToURLFilename = tmp;
            }
            if (!quietMode) {
                System.out.println("This utility will read URLs from a tab delimited file with URLs in \nthe 2nd column named " + fileToURLFilename + " and compare these URLs domains against the domain filters in ." + htmlFiltersFilename);
                System.out.println("Loading HTML_Filters.json");
            }
            JSONObject htmlfilters = MDfromHTMLUtils.loadJSONFile((String)htmlFiltersFilename);
            List files2urls = MDfromHTMLUtils.loadTextFile((String)fileToURLFilename);
            String[] parts = new String[]{};
            String url = "";
            String domain = "";
            HashSet<String> unfiltered = new HashSet<String>();
            int urlCount = 1;
            if (!quietMode) {
                System.out.println("Processing URLs (. == 50 urls processed)\n");
            }
            for (String file_url : files2urls) {
                if (file_url.trim().startsWith("#")) continue;
                parts = file_url.split("\t");
                url = parts[1];
                domain = Remark.getDomain((String)url);
                if (htmlfilters.get((Object)domain) == null) {
                    unfiltered.add(domain);
                }
                if (!quietMode) {
                    if (urlCount % 50 == 0) {
                        System.out.print(".");
                    }
                    if (urlCount % 4000 == 0) {
                        System.out.println();
                    }
                }
                ++urlCount;
            }
            if (!quietMode) {
                System.out.println("\n");
            }
            ArrayList<String> unfilteredDomains = new ArrayList<String>();
            unfilteredDomains.addAll(unfiltered);
            Collections.sort(unfilteredDomains);
            if (!quietMode) {
                System.out.println("Domains without filters:");
            }
            for (String unfilteredDomain : unfilteredDomains) {
                System.out.println(unfilteredDomain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (!quietMode) {
                System.out.println("Goodbye");
            }
        }
    }
}

