/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetHTMLJSONfromHTML {
    String _ext = "html";
    Path _inputPath = null;
    String _inputMapFile = "";
    boolean _interactive = false;
    String _outputPath = ".";
    boolean _thumbsucker = false;

    public static void main(String[] args) {
        int exitVal = 0;
        GetHTMLJSONfromHTML pgm = new GetHTMLJSONfromHTML();
        if (pgm.getParams(args)) {
            if (pgm._thumbsucker) {
                System.out.println("\nFiles ending with ." + pgm._ext + " will be read from " + pgm._inputPath + "\nand the generated html json file saved in " + pgm._outputPath);
            }
            if (pgm._interactive && MDfromHTMLUtils.prompt((String)"Press q to quit or press Enter to continue...").length() == 0) {
                pgm._interactive = false;
            }
            if (!pgm._interactive) {
                try {
                    List inputLines = MDfromHTMLUtils.loadTextFile((String)pgm._inputMapFile);
                    HashMap<String, String> html2urlMap = new HashMap<String, String>();
                    String[] parts = null;
                    int lineNum = 0;
                    for (String inputLine : inputLines) {
                        ++lineNum;
                        parts = inputLine.split("\t");
                        if (parts.length != 2) {
                            System.out.println("Errant line: " + lineNum + ": " + inputLine);
                            continue;
                        }
                        html2urlMap.put(parts[1].trim(), parts[0].trim());
                    }
                    List files = MDfromHTMLUtils.listSourceFiles((Path)FileSystems.getDefault().getPath(pgm._inputPath.toString(), new String[0]), (String)pgm._ext);
                    for (Path file : files) {
                        try {
                            exitVal = pgm.doWork(file, html2urlMap);
                            if (exitVal == 0) continue;
                            break;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: Can not reference files with extension " + pgm._ext + " in directory " + pgm._inputPath + " reason: " + e.getLocalizedMessage());
                    exitVal = -1;
                }
            }
            if (pgm._thumbsucker) {
                System.out.println();
            }
        } else {
            exitVal = -1;
        }
        if (pgm._thumbsucker) {
            System.out.println("Goodbye");
        }
        System.exit(exitVal);
    }

    public String escapeString(String str) {
        return str.replace("\\", "\\\\").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t").replace("'", "\\'").replace("\"", "\\\"");
    }

    int doWork(Path file, Map<String, String> html2urlMap) {
        int exitVal = 0;
        try {
            String fqFileName = file.toString();
            if (this._thumbsucker) {
                System.out.println("Processing: " + fqFileName);
            }
            JSONObject outputJsonFile = new JSONObject();
            JSONArray captureArray = new JSONArray();
            outputJsonFile.put("captureArray", (Object)captureArray);
            JSONObject outputJson = new JSONObject();
            String shortFileName = fqFileName.substring(fqFileName.lastIndexOf(File.separator) + 1);
            int index = shortFileName.lastIndexOf("." + this._ext);
            if (index < 1) {
                System.out.println(fqFileName + " doesn't end with ." + this._ext);
                exitVal = -1;
            } else {
                String outputFileName = this._outputPath + shortFileName.substring(0, index) + ".json";
                outputJson.put("url", (Object)html2urlMap.get(shortFileName));
                BufferedReader br = MDfromHTMLUtils.openTextFile((String)fqFileName);
                StringBuffer sb = new StringBuffer();
                String line = br.readLine();
                String test = "";
                while (line != null) {
                    test = line.trim();
                    if (test.length() == 0) {
                        line = br.readLine();
                        continue;
                    }
                    sb.append(line);
                    line = br.readLine();
                }
                outputJson.put("html", (Object)sb.toString());
                captureArray.add((Object)outputJson);
                MDfromHTMLUtils.saveJSONFile((String)outputFileName, (JSONObject)outputJsonFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            exitVal = -1;
        }
        return exitVal;
    }

    boolean getParams(String[] args) {
        File testOutput;
        String inputPath = "." + File.separator + "data" + File.separator + "htmls";
        String outputPath = "." + File.separator + "data" + File.separator + "htmljson";
        String inputMapFile = "." + File.separator + "data" + File.separator + "urls_to_htmls.tsv";
        String tmp = "";
        try {
            if (args.length >= 1) {
                inputPath = args[0];
            } else {
                this._interactive = true;
                this._thumbsucker = true;
                tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to directory containing " + this._ext + " capture files, or q to exit (" + inputPath + "):"));
                if (tmp == null || tmp.length() == 0) {
                    tmp = inputPath;
                }
                if (tmp.toLowerCase().equals("q")) {
                    return false;
                }
                inputPath = tmp;
            }
            if (!inputPath.endsWith(File.separator)) {
                inputPath = inputPath + File.separator;
            }
            this._inputPath = FileSystems.getDefault().getPath(inputPath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            System.out.println("Error: " + args[0] + " is not a valid directory to form a path.");
            return false;
        }
        if (args.length >= 2) {
            outputPath = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to the htmljson output directory, or q to exit (" + outputPath + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = outputPath;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            outputPath = tmp;
        }
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath + File.separator;
        }
        if (!(testOutput = new File(outputPath)).exists()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must exist.");
            return false;
        }
        if (!testOutput.isDirectory()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must be a directory.");
            return false;
        }
        this._outputPath = outputPath;
        if (args.length >= 3) {
            inputMapFile = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to the url to html file tsv file, or q to exit (" + inputMapFile + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = inputMapFile;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            inputMapFile = tmp;
        }
        File testInputMapFile = new File(inputMapFile);
        if (!testInputMapFile.exists()) {
            System.out.println("Error: The url to html file tsv file \"" + inputMapFile + "\" must exist.");
            return false;
        }
        if (testInputMapFile.isDirectory()) {
            System.out.println("Error: The entry can not be a directory \"" + inputMapFile + "\" must be a tsv file.");
            return false;
        }
        this._inputMapFile = inputMapFile;
        if (args.length >= 4) {
            this._thumbsucker = new Boolean(args[3]);
        }
        return true;
    }
}

