/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSON;
import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.remark.utils.CleanupMarkdown;
import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class GetMarkdownFromHTML {
    String _ext = "json";
    JSONObject _HTMLFilters = null;
    String _htmlFiltersFileName = "." + File.separator + "properties" + File.separator + "HTML_Filters.json";
    Path _inputPath = null;
    boolean _interactive = false;
    boolean _keepProvenanceLinks = false;
    String _outputPath = ".";
    Remark _remark = new Remark(Options.multiMarkdown());
    boolean _thumbsucker = false;

    public static JSONObject getMarkdownFromHTML(JSONObject htmlObject) {
        JsonNode jsonnode;
        JSONObject result = new JSONObject();
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonnode = mapper.readTree(htmlObject.toString());
        }
        catch (IOException e) {
            result.put("errorMsg", (Object)String.format("Error: Can not parse the object: %s" + e.getLocalizedMessage(), new Object[0]));
            return result;
        }
        jsonnode = GetMarkdownFromHTML.getMarkdownFromHTML((ObjectNode)jsonnode);
        try {
            result = (JSONObject)JSON.parse((String)jsonnode.toString());
        }
        catch (IOException e) {
            result.put("errorMsg", (Object)String.format("Error: Can not parse the response object: %s" + e.getLocalizedMessage(), new Object[0]));
            return result;
        }
        return result;
    }

    public static ObjectNode getMarkdownFromHTML(ObjectNode htmlObject) {
        Boolean test;
        JSONObject domainFilters;
        JSONObject HTMLFilters;
        ObjectNode result = JsonNodeFactory.instance.objectNode();
        boolean returnProvenance = true;
        JsonNode testProv = htmlObject.get("returnProvenance");
        if (testProv != null && testProv.isBoolean()) {
            returnProvenance = testProv.asBoolean();
        }
        String htmlFiltersFileName = "." + File.separator + "properties" + File.separator + "HTML_Filters.json";
        ObjectNode HTMLFiltersObj = (ObjectNode)htmlObject.get("HTMLFilters");
        if (HTMLFiltersObj == null) {
            try {
                ObjectMapper mapper = new ObjectMapper();
                JsonNode filters = mapper.readTree(new File(htmlFiltersFileName));
                HTMLFiltersObj = (ObjectNode)filters;
            }
            catch (Exception e1) {
                result.put("errorMsg", "Error: Can not find \"HTML_Filters\" in the request, nor can a file named \"" + htmlFiltersFileName + "\" be found: " + e1.getLocalizedMessage());
                return result;
            }
        }
        try {
            String htmlFilters = HTMLFiltersObj.toString().toLowerCase();
            HTMLFilters = (JSONObject)JSON.parse((String)htmlFilters);
        }
        catch (IOException e) {
            result.put("errorMsg", "Error: Can not find parse the content of the \"" + htmlFiltersFileName + "\" file: " + e.getLocalizedMessage());
            return result;
        }
        Options options = Options.multiMarkdown();
        options.hardwraps = false;
        GetMarkdownFromHTML pgm = new GetMarkdownFromHTML();
        pgm.setRemark(options, HTMLFilters);
        JsonNode temp = htmlObject.get("html");
        if (temp == null) {
            ArrayNode captureArray = (ArrayNode)htmlObject.get("captureArray");
            if (captureArray != null && captureArray.size() > 0) {
                ObjectNode obj = (ObjectNode)captureArray.get(0);
                temp = obj.get("html");
                if (temp == null) {
                    result.put("errorMsg", "The request captureArray is missing the required \"html\" key so there is nothing to process.");
                    return result;
                }
            } else {
                result.put("errorMsg", "The request is missing the required \"html\" or \"captureArray\" key so there is nothing to process.");
                return result;
            }
        }
        String html = temp.asText();
        temp = htmlObject.get("url");
        if (temp == null) {
            result.put("errorMsg", "The request is missing the required \"url\" key.");
            return result;
        }
        String baseURI = temp.asText();
        Document doc = Jsoup.parse((String)html, (String)baseURI);
        doc.outputSettings().escapeMode(Entities.EscapeMode.extended);
        boolean seekHeaders = true;
        String domain = Remark.getDomain((String)baseURI);
        int testindex = baseURI.indexOf(domain);
        String workingURI = baseURI.substring(testindex + domain.length());
        testindex = workingURI.toLowerCase().indexOf("http");
        if (testindex >= 0) {
            workingURI = workingURI.substring(testindex);
            domain = Remark.getDomain((String)workingURI);
            baseURI = workingURI;
        }
        if ((domainFilters = (JSONObject)HTMLFilters.get((Object)domain)) != null && (test = (Boolean)domainFilters.get((Object)DocumentConverter.SEEK_HEADERS)) != null) {
            seekHeaders = test;
        }
        ProvenanceWriter provWriter = null;
        StringWriter sw = null;
        BufferedWriter bw = null;
        if (returnProvenance) {
            sw = new StringWriter();
            bw = new BufferedWriter(sw);
            try {
                provWriter = new ProvenanceWriter("", "", HTMLFilters, baseURI, domain, (Writer)bw);
            }
            catch (IOException e) {
                e.printStackTrace();
                provWriter = null;
            }
        }
        String markdown = pgm.generateMarkdownFromHTML(doc, provWriter, baseURI, seekHeaders);
        markdown = markdown.replaceAll("&lt;!--", "<!--");
        markdown = markdown.replaceAll("--&gt;", "-->");
        result.set("HTMLFilters", (JsonNode)HTMLFiltersObj);
        if (returnProvenance && provWriter != null) {
            try {
                provWriter.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            String provenance = sw.getBuffer().toString();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode provObj = null;
            try {
                provObj = mapper.readTree(provenance);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            result.set("provenance", provObj);
            ObjectNode testHTMLFilters = (ObjectNode)provObj.get("HTMLFilters");
            if (testHTMLFilters != null) {
                result.set("HTMLFilters", (JsonNode)testHTMLFilters);
            }
        }
        ArrayNode captureArray = JsonNodeFactory.instance.arrayNode();
        ObjectNode htmlInfo = JsonNodeFactory.instance.objectNode();
        htmlInfo.put("content", doc.text());
        htmlInfo.put("html", html);
        htmlInfo.put("url", baseURI);
        captureArray.add((JsonNode)htmlInfo);
        result.set("captureArray", (JsonNode)captureArray);
        result.set("markdown", (JsonNode)JsonNodeFactory.instance.textNode(markdown));
        result.put("returnProvenance", returnProvenance);
        result.put("url", baseURI);
        return result;
    }

    public void getReferencesAndLinks(String line, Set<String> refLinks, Set<String> references) {
        String test = line.trim();
        char[] testChars = new char[test.length()];
        test.getChars(0, test.length(), testChars, 0);
        int offset = 0;
        boolean foundBracket = false;
        int bracketCnt = 0;
        int startOffset = -1;
        String refLink = "";
        String reference = "";
        Stack<Integer> startOffsets = new Stack<Integer>();
        for (char testChar : testChars) {
            switch (testChar) {
                case '[': {
                    if (!foundBracket) {
                        foundBracket = true;
                    }
                    startOffsets.push(offset);
                    ++bracketCnt;
                    break;
                }
                case ']': {
                    if (!foundBracket) break;
                    --bracketCnt;
                    startOffset = (Integer)startOffsets.pop();
                    if (offset - startOffset > 1) {
                        if (offset + 1 < test.length()) {
                            if (line.startsWith("[") && ':' == testChars[offset + 1]) {
                                if (offset + 2 < test.length()) {
                                    if (' ' == testChars[offset + 2]) {
                                        reference = test.substring(startOffset, offset + 1);
                                        references.add(reference);
                                    } else {
                                        refLink = test.substring(startOffset, offset + 1);
                                        refLinks.add(refLink);
                                    }
                                } else {
                                    refLink = test.substring(startOffset, offset + 1);
                                    refLinks.add(refLink);
                                }
                            } else {
                                refLink = test.substring(startOffset, offset + 1);
                                refLinks.add(refLink);
                            }
                        } else {
                            refLink = test.substring(startOffset, offset + 1);
                            refLinks.add(refLink);
                        }
                    }
                    if (bracketCnt != 0) break;
                    startOffset = -1;
                    foundBracket = false;
                    break;
                }
            }
            ++offset;
        }
    }

    public static void main(String[] args) throws Exception {
        Options options = Options.multiMarkdown();
        options.hardwraps = false;
        GetMarkdownFromHTML pgm = new GetMarkdownFromHTML();
        if (pgm.getParams(args)) {
            if (pgm._thumbsucker) {
                System.out.println("\nFiles ending with ." + pgm._ext + " will be read from " + pgm._inputPath + "\nand the generated markdown (.md), and html (.html and _foramtted.html) saved in " + pgm._outputPath);
            }
            if (pgm._interactive && MDfromHTMLUtils.prompt((String)"Press q to quit or press Enter to continue...").length() == 0) {
                pgm._interactive = false;
            }
            if (!pgm._interactive) {
                try {
                    List files = MDfromHTMLUtils.listSourceFiles((Path)FileSystems.getDefault().getPath(pgm._inputPath.toString(), new String[0]), (String)pgm._ext);
                    for (Path file : files) {
                        try {
                            pgm.doWork(file);
                        }
                        catch (Exception e) {
                            System.out.println("Error: Could not perform work for file \"" + file.toString() + "\": " + e.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: Can not reference files with extension " + pgm._ext + " in directory " + pgm._inputPath + " reason: " + e.getLocalizedMessage());
                }
            }
            if (pgm._thumbsucker) {
                System.out.println();
            }
        }
        if (args.length == 0) {
            System.out.println("Goodbye");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String removeUnusedReferences(String markdown) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = new BufferedReader(new StringReader(markdown));
        String line = "";
        String test = "";
        HashSet<String> refLinks = new HashSet<String>();
        HashSet<String> references = new HashSet<String>();
        int index = -1;
        String refStr = "";
        try {
            while ((line = br.readLine()) != null) {
                this.getReferencesAndLinks(line, refLinks, references);
            }
            for (String link : refLinks) {
                references.remove(link);
            }
            if (references.size() == 0) {
                sb = new StringBuffer(markdown);
            } else {
                br = new BufferedReader(new StringReader(markdown));
                while ((line = br.readLine()) != null) {
                    test = line.trim();
                    if (test.startsWith("[")) {
                        index = test.indexOf("]: ");
                        if (index != -1) {
                            refStr = test.substring(0, index + 1);
                            if (references.contains(refStr)) {
                                references.remove(refStr);
                                continue;
                            }
                        } else if (test.endsWith("]:")) continue;
                    }
                    sb.append(line);
                    sb.append("\n");
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            MDfromHTMLUtils.closeTextFile((BufferedReader)br);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rewriteURLReferences(String markdown) {
        HashMap<String, String> urlRefs = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new StringReader(markdown));
        String line = "";
        int refCloseIndex = -1;
        String url = "";
        String ref = "";
        int lineCnt = 0;
        int refLineStart = -1;
        int refLineEnd = -1;
        try {
            while ((line = br.readLine()) != null) {
                ++lineCnt;
                if (!line.startsWith("[") || (refCloseIndex = line.indexOf("]: ")) <= 0) continue;
                if (refLineStart == -1) {
                    refLineStart = lineCnt;
                }
                refLineEnd = lineCnt;
                ref = line.substring(1, refCloseIndex);
                url = line.substring(refCloseIndex + 3);
                urlRefs.put(ref, url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MDfromHTMLUtils.closeTextFile((BufferedReader)br);
        }
        StringBuffer sb = new StringBuffer();
        br = new BufferedReader(new StringReader(markdown));
        int indexBrackets = -1;
        int indexOpenBracket = -1;
        int indexCloseBracket = -1;
        String linePart = "";
        String refLabel = "";
        try {
            lineCnt = 0;
            while ((line = br.readLine()) != null) {
                if (++lineCnt >= refLineStart && lineCnt <= refLineEnd && refLineStart != -1 && refLineEnd != -1) continue;
                indexBrackets = line.indexOf("][");
                while (indexBrackets > 0) {
                    linePart = line.substring(0, indexBrackets);
                    indexOpenBracket = linePart.lastIndexOf("[");
                    refLabel = indexOpenBracket >= 0 ? linePart.substring(indexOpenBracket + 1) : "";
                    sb.append(linePart);
                    line = line.substring(indexBrackets + 2);
                    indexCloseBracket = line.indexOf("]");
                    if (indexCloseBracket >= 0) {
                        if (indexCloseBracket == 0 && refLabel.length() > 0) {
                            sb.append("](");
                            sb.append((String)urlRefs.get(refLabel.replaceAll(",", "_").replaceAll("\\^", "_")));
                            sb.append(") ");
                        } else {
                            sb.append("](");
                            sb.append((String)urlRefs.get(line.substring(0, indexCloseBracket)));
                            sb.append(") ");
                        }
                        line = line.substring(indexCloseBracket + 1);
                        indexBrackets = line.indexOf("][");
                        continue;
                    }
                    sb.append("][");
                    sb.append(line);
                    line = "";
                    break;
                }
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            MDfromHTMLUtils.closeTextFile((BufferedReader)br);
        }
        return sb.toString();
    }

    protected GetMarkdownFromHTML() {
    }

    void cleanUpAnnotations(String provenanceFileName) throws Exception {
        JSONObject annotation;
        String md;
        JSONObject provenanceObj = MDfromHTMLUtils.loadJSONFile((String)provenanceFileName);
        JSONArray provenanceArray = (JSONArray)provenanceObj.get((Object)"provenance");
        Iterator it = provenanceArray.iterator();
        while (it.hasNext() && (md = (String)(annotation = (JSONObject)it.next()).get((Object)"md")) != null && !md.startsWith("#")) {
            it.remove();
        }
        provenanceObj.put("provenance", (Object)provenanceArray);
        MDfromHTMLUtils.saveJSONFile((String)provenanceFileName, (JSONObject)provenanceObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doWork(Path file) throws Exception {
        ProvenanceWriter provenanceWriter = null;
        String provenanceOutputFileName = "unknown";
        String fqFileName = file.toString();
        if (this._thumbsucker) {
            System.out.println("Processing: " + fqFileName);
        }
        ObjectMapper mapper = new ObjectMapper();
        File jsonTestFile = new File(file.toString());
        JsonNode tempJSON = mapper.readTree(jsonTestFile);
        String shortFileName = fqFileName.substring(fqFileName.lastIndexOf(File.separator) + 1);
        int index = shortFileName.lastIndexOf("." + this._ext);
        if (index >= 1) {
            ObjectNode inputJson = (ObjectNode)tempJSON;
            int htmlCounter = 0;
            ArrayNode htmlList = (ArrayNode)inputJson.get("captureArray");
            if (htmlList == null) {
                JsonNode htmlObj = inputJson.get("captureDict");
                if (htmlObj == null) {
                    throw new Exception(fqFileName + " is missing the \"captureArray\" and the \"captureDict\" tag. Please fix and retry.");
                }
                htmlList = JsonNodeFactory.instance.arrayNode();
                htmlList.add(htmlObj);
            }
            int captureArrayLen = htmlList.size();
            String baseURI = null;
            String html = null;
            JsonNode temp = null;
            for (Object obj : htmlList) {
                Boolean test;
                boolean seekHeaders = true;
                JSONObject globalFilters = (JSONObject)this._HTMLFilters.get((Object)"*");
                if (globalFilters != null && (test = (Boolean)globalFilters.get((Object)DocumentConverter.SEEK_HEADERS)) != null) {
                    seekHeaders = test;
                }
                try {
                    Boolean test2;
                    ++htmlCounter;
                    ObjectNode htmlObj = (ObjectNode)obj;
                    temp = htmlObj.get("html");
                    if (temp == null) {
                        throw new Exception(fqFileName + " is missing the \"html\" key in the [" + (htmlCounter - 1) + "] element of the captureArray.");
                    }
                    html = temp.asText();
                    temp = htmlObj.get("url");
                    if (temp == null) {
                        throw new Exception(fqFileName + " is missing the \"utl\" key in the [" + (htmlCounter - 1) + "] element of the captureArray.");
                    }
                    baseURI = temp.asText();
                    String htmlOutputFileName = this._outputPath + shortFileName.substring(0, index) + (captureArrayLen > 1 ? "_" + MDfromHTMLUtils.padLeftZero((int)htmlCounter, (int)3) : "") + ".html";
                    MDfromHTMLUtils.saveTextFile((String)htmlOutputFileName, (String)html);
                    Document doc = Jsoup.parse((String)html, (String)baseURI);
                    doc.outputSettings().escapeMode(Entities.EscapeMode.extended);
                    String formattedHTML = doc.toString();
                    formattedHTML = formattedHTML.replaceAll("&amp;", "&");
                    formattedHTML = formattedHTML.replaceAll("&quot;", "\"");
                    String formattedHTMLOutputFileName = this._outputPath + shortFileName.substring(0, index) + (captureArrayLen > 1 ? "_" + MDfromHTMLUtils.padLeftZero((int)htmlCounter, (int)3) : "") + "_formatted.html";
                    MDfromHTMLUtils.saveTextFile((String)formattedHTMLOutputFileName, (String)formattedHTML);
                    String domain = Remark.getDomain((String)baseURI);
                    int testindex = baseURI.indexOf(domain);
                    String workingURI = baseURI.substring(testindex + domain.length());
                    testindex = workingURI.toLowerCase().indexOf("http");
                    if (testindex >= 0) {
                        workingURI = workingURI.substring(testindex);
                        domain = Remark.getDomain((String)workingURI);
                        baseURI = workingURI;
                    }
                    String markdownOutputFileName = this._outputPath + shortFileName.substring(0, index) + (captureArrayLen > 1 ? "_" + MDfromHTMLUtils.padLeftZero((int)htmlCounter, (int)3) : "") + ".md";
                    provenanceOutputFileName = this._outputPath + shortFileName.substring(0, index) + (captureArrayLen > 1 ? "_" + MDfromHTMLUtils.padLeftZero((int)htmlCounter, (int)3) : "") + "_html2md.json";
                    File provenanceOutputFile = new File(provenanceOutputFileName);
                    if (provenanceOutputFile.exists()) {
                        provenanceOutputFile.delete();
                    }
                    provenanceWriter = new ProvenanceWriter(formattedHTMLOutputFileName, markdownOutputFileName, this._remark.getHTMLFilters(), baseURI, domain, (Writer)new FileWriter(provenanceOutputFile, true));
                    JSONObject domainFilters = (JSONObject)this._HTMLFilters.get((Object)domain);
                    if (domainFilters != null && (test2 = (Boolean)domainFilters.get((Object)DocumentConverter.SEEK_HEADERS)) != null) {
                        seekHeaders = test2;
                    }
                    String markdown = this.generateMarkdownFromHTML(doc, provenanceWriter, baseURI, seekHeaders);
                    markdown = markdown.replaceAll("&lt;!--", "<!--");
                    markdown = markdown.replaceAll("--&gt;", "-->");
                    if (this._keepProvenanceLinks) {
                        markdown = markdown + "\n###### Provenance ######\n\n * [Original URL][]\n * [File Processed][]\n\n[Original URL]: " + baseURI.replaceAll(" ", "%20") + "\n[File Processed]: file://" + file.toAbsolutePath().toString();
                    }
                    if (this._thumbsucker) {
                        System.out.println("Writing: " + markdownOutputFileName);
                    }
                    MDfromHTMLUtils.saveTextFile((String)markdownOutputFileName, (String)markdown);
                }
                finally {
                    if (provenanceWriter == null) continue;
                    try {
                        provenanceWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    provenanceWriter = null;
                }
            }
        } else {
            throw new Exception(fqFileName + " does not end with " + this._ext);
        }
    }

    String generateMarkdownFromHTML(Document doc, ProvenanceWriter provenanceWriter, String baseUri, boolean seekHeaders) {
        String markdown = this._remark.convert(doc, provenanceWriter, baseUri);
        markdown = CleanupMarkdown.cleanAll((String)markdown, (boolean)seekHeaders);
        markdown = this.removeUnusedReferences(markdown);
        return this.rewriteURLReferences(markdown);
    }

    boolean getParams(String[] args) {
        File testOutput;
        String inputPath = "." + File.separator + "data" + File.separator + "htmljson";
        String outputPath = "." + File.separator + "data" + File.separator + "md";
        String htmlFiltersFileName = "." + File.separator + "properties" + File.separator + "HTML_Filters.json";
        String tmp = "";
        try {
            if (args.length >= 1) {
                inputPath = args[0];
            } else {
                this._interactive = true;
                this._thumbsucker = true;
                tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to directory containing " + this._ext + " html capture files, or q to exit (" + inputPath + "):"));
                if (tmp == null || tmp.length() == 0) {
                    tmp = inputPath;
                }
                if (tmp.toLowerCase().equals("q")) {
                    return false;
                }
                inputPath = tmp;
            }
            if (!inputPath.endsWith(File.separator)) {
                inputPath = inputPath + File.separator;
            }
            this._inputPath = FileSystems.getDefault().getPath(inputPath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            System.out.println("Error: " + args[0] + " is not a valid directory to form a path.");
            return false;
        }
        if (args.length >= 2) {
            outputPath = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to the markdown output directory, or q to exit (" + outputPath + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = outputPath;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            outputPath = tmp;
        }
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath + File.separator;
        }
        if (!(testOutput = new File(outputPath)).exists()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must exist.");
            return false;
        }
        if (!testOutput.isDirectory()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must be a directory.");
            return false;
        }
        this._outputPath = outputPath;
        if (args.length >= 3) {
            this._htmlFiltersFileName = args[2];
        } else {
            tmp = MDfromHTMLUtils.prompt((String)("Enter the name of the HTML Filters JSON input file, or q to quit (" + htmlFiltersFileName + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = htmlFiltersFileName;
            }
            if ("q".equalsIgnoreCase(tmp)) {
                return false;
            }
            this._htmlFiltersFileName = tmp;
        }
        testOutput = new File(this._htmlFiltersFileName);
        if (!testOutput.exists()) {
            System.out.println("Error: The HTML Filters file \"" + this._htmlFiltersFileName + "\" must exist.");
            return false;
        }
        if (!testOutput.isFile()) {
            System.out.println("Error: The HTML Filters file name \"" + this._htmlFiltersFileName + "\" must be a file.");
            return false;
        }
        if (!testOutput.canRead()) {
            System.out.println("Error: The HTML Filters file \"" + this._htmlFiltersFileName + "\" can not be read.");
            return false;
        }
        try {
            this._HTMLFilters = MDfromHTMLUtils.loadJSONFile((String)this._htmlFiltersFileName);
            try {
                this._HTMLFilters = (JSONObject)JSON.parse((String)this._HTMLFilters.toString().toLowerCase());
            }
            catch (Exception e) {
                System.out.println("Error: \"" + this._htmlFiltersFileName + "\" has a parsing error: " + e.getLocalizedMessage());
                return false;
            }
        }
        catch (Exception e1) {
            System.out.println("Error: Can not load HTML Filters file \"" + this._htmlFiltersFileName + "\": " + e1.getLocalizedMessage());
            return false;
        }
        Options options = Options.multiMarkdown();
        options.hardwraps = false;
        this.setRemark(options, this._HTMLFilters);
        if (args.length >= 4) {
            this._thumbsucker = new Boolean(args[3]);
        }
        if (args.length >= 5) {
            this._keepProvenanceLinks = new Boolean(args[4]);
        } else {
            tmp = MDfromHTMLUtils.prompt((String)("Keep provenance links? (" + this._keepProvenanceLinks + "):"));
            this._keepProvenanceLinks = new Boolean(tmp);
        }
        return true;
    }

    Set<String> getReferences(String line) {
        HashSet<String> results = new HashSet<String>();
        String test = line.trim();
        int index = test.indexOf("[");
        int index2 = -1;
        String reference = "";
        while (index != -1 && (index2 = test.indexOf("]: ")) != -1) {
            if (index2 - index > 2) {
                reference = test.substring(index, index2 + 1);
                results.add(reference);
            }
            test = test.substring(index2 + 3);
            index = test.indexOf("[");
        }
        return results;
    }

    void setRemark(Options options, JSONObject HTMLFilters) {
        this._remark = new Remark(options, HTMLFilters);
    }
}

