/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.markdown.transform;

import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.mdfromhtml.markdown.transform.TextUtils;
import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import com.overzealous.remark.convert.ProvenanceWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GetTextFromMarkdown {
    static boolean _includeLinks = false;
    String _ext = "md";
    JSONObject _HTMLFilters = new JSONObject();
    Path _inputPath = null;
    boolean _interactive = false;
    Options _options = Options.multiMarkdown();
    String _outputPath = ".";
    boolean _thumbsucker = false;
    String _txtext = "txt";
    int _colSkipped = 0;
    boolean _inTable = false;
    Pattern _fencePattern1 = Pattern.compile("```\\w+");
    Pattern _fencePattern2 = Pattern.compile("~~~\\w+");
    String _closeBracket = new String(new char[]{'\ufdd0'});
    String _openBracket = new String(new char[]{'\ufdd1'});
    String _urlUnderscore = new String(new char[]{'\ufdd2'});

    public Map<String, String> findRefURLs(List<String> mdLines) {
        HashMap<String, String> refURLs = new HashMap<String, String>();
        int offset = 0;
        String url = "";
        String ref = "";
        for (String mdLine : mdLines) {
            if (!(mdLine = mdLine.trim()).startsWith("[") || (offset = mdLine.indexOf("]: ")) <= 1) continue;
            ref = mdLine.substring(1, offset).trim();
            url = mdLine.substring(offset + 3).trim();
            url = url.replaceAll("_", this._urlUnderscore);
            refURLs.put(ref, url);
        }
        return refURLs;
    }

    public String generateTextFromMarkdown(String mdLine, Map<String, String> refURLs) {
        String test = mdLine.trim();
        if (test.length() > 0) {
            test = TextUtils.filterComments(test);
            test = this.processText(test, refURLs);
        }
        return test;
    }

    public static String getRef(String line) {
        String retVal = "";
        int startOffset = line.indexOf("[");
        if (startOffset > -1) {
            int endOffset = line.substring(startOffset).indexOf("]");
            if (startOffset > -1 && endOffset > startOffset) {
                retVal = line.substring(startOffset + 1, endOffset + startOffset).trim();
            }
        }
        return retVal;
    }

    public static void main(String[] args) throws Exception {
        JSONObject HTMLFilters = null;
        try {
            HTMLFilters = MDfromHTMLUtils.loadJSONFile((String)("." + File.separator + "properties" + File.separator + "HTML_Filters.json"));
        }
        catch (Exception e1) {
            System.out.println("Warning: Using no HTML Filters -- can not find ." + File.separator + "properties" + File.separator + "HTML_Filters.json\": " + e1.getLocalizedMessage());
        }
        GetTextFromMarkdown pgm = new GetTextFromMarkdown(Options.multiMarkdown(), HTMLFilters);
        if (pgm.getParams(args)) {
            if (pgm._thumbsucker) {
                System.out.println("\nFiles ending with ." + pgm._ext + " will be read from " + pgm._inputPath + "\nand the generated text files (." + pgm._txtext + ") will be saved in " + pgm._outputPath + "\nIt is " + _includeLinks + " that links will be included in the text output.");
            }
            if (pgm._interactive && MDfromHTMLUtils.prompt((String)"Press q to quit or press Enter to continue...").length() == 0) {
                pgm._interactive = false;
            }
            if (!pgm._interactive) {
                try {
                    List files = MDfromHTMLUtils.listSourceFiles((Path)FileSystems.getDefault().getPath(pgm._inputPath.toString(), new String[0]), (String)pgm._ext);
                    for (Path file : files) {
                        try {
                            pgm.doWork(file);
                        }
                        catch (Exception e) {
                            System.out.println("Error: Could not perform work for file \"" + file.toString() + "\": " + e.getLocalizedMessage());
                        }
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: Can not reference files with extension " + pgm._ext + " in directory " + pgm._inputPath + " reason: " + e.getLocalizedMessage());
                }
            }
            if (pgm._thumbsucker) {
                System.out.println();
            }
        }
        if (args.length == 0) {
            System.out.println("Goodbye");
        }
    }

    public String processText(String line, Map<String, String> refURLs) {
        StringBuffer sb = new StringBuffer();
        String testChanged = "";
        int lineLen = line.length();
        int offset = 0;
        this._inTable = false;
        this._colSkipped = 0;
        block12: while (offset < lineLen && line != null) {
            char startChar = line.charAt(offset);
            switch (startChar) {
                case '\\': {
                    if (this._inTable) {
                        ++this._colSkipped;
                    }
                    if (++offset < lineLen) {
                        sb.append(line.charAt(offset));
                        ++offset;
                    }
                    if (offset < lineLen) {
                        line = line.substring(offset);
                        lineLen = line.length();
                    } else {
                        lineLen = 0;
                        this._inTable = false;
                        this._colSkipped = 0;
                    }
                    offset = 0;
                    continue block12;
                }
                case '!': {
                    if (offset < lineLen - 1) {
                        if ("[".equals(line.substring(offset + 1, offset + 2))) {
                            if ((line = this.removeReferencesAndLinks(line.substring(offset), refURLs)) == null) {
                                this._inTable = false;
                                this._colSkipped = 0;
                                continue block12;
                            }
                            offset = 0;
                            lineLen = line.length();
                            continue block12;
                        }
                        sb.append("!");
                        line = line.substring(offset + 1);
                        offset = 0;
                        lineLen = line.length();
                        continue block12;
                    }
                    sb.append("!");
                    offset = line.length();
                    this._inTable = false;
                    this._colSkipped = 0;
                    continue block12;
                }
                case '[': {
                    line = this.removeReferencesAndLinks(line.substring(offset), refURLs);
                    this._inTable = false;
                    this._colSkipped = 0;
                    if (line == null) {
                        return null;
                    }
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
                case '|': {
                    if (this._inTable) {
                        while (this._colSkipped > 0) {
                            sb.append(" ");
                            --this._colSkipped;
                        }
                    }
                    this._inTable = true;
                    line = this.removeTableLines(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    if (lineLen != 0 || !this._inTable) continue block12;
                    this._colSkipped = 0;
                    this._inTable = false;
                    continue block12;
                }
                case '-': {
                    testChanged = this.removeTaskList(line.substring(offset));
                    if (testChanged.equals(line.substring(offset))) {
                        sb.append("-");
                        line = testChanged.substring(1);
                    } else {
                        line = testChanged;
                    }
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
                case '`': {
                    line = this.removeFencing(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
                case '#': {
                    line = this.removeHeading(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
                case '_': {
                    line = this.removeUnderscore(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
                case '~': {
                    line = this.removeFencing(line.substring(offset));
                    line = this.removeEmphasis(line);
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
                case '*': {
                    line = this.removeEmphasis(line.substring(offset));
                    offset = 0;
                    lineLen = line.length();
                    continue block12;
                }
            }
            sb.append(startChar);
            ++offset;
        }
        String temp = sb.toString();
        if (temp.contains("\\\\:")) {
            System.out.println("Before cleanse: " + temp);
            temp = temp.replaceAll("\\\\:", ":");
            System.out.println("After cleanse: " + temp);
        }
        if (temp.contains("\\\\-")) {
            System.out.println("Before cleanse: " + temp);
            temp = temp.replaceAll("\\\\-", "-");
            System.out.println("After cleanse: " + temp);
        }
        temp = temp.replaceAll(this._openBracket, "[");
        temp = temp.replaceAll(this._closeBracket, "]");
        temp = temp.replaceAll(this._urlUnderscore, "_");
        return temp;
    }

    public String removeEmphasis(String line) {
        StringBuffer sb = new StringBuffer();
        char test = ' ';
        char priorChar = '\u0000';
        char nextChar = '\u0000';
        for (int i = 0; i < line.length(); ++i) {
            test = line.charAt(i);
            nextChar = i < line.length() - 1 ? line.charAt(i + 1) : (char)'\u0000';
            switch (test) {
                case '~': {
                    if (!this._inTable) break;
                    ++this._colSkipped;
                    break;
                }
                case '*': {
                    if ((i == 0 || priorChar == ' ') && nextChar == ' ') {
                        sb.append('\u2022');
                        break;
                    }
                    if (priorChar == '\\') {
                        sb.append(test);
                        break;
                    }
                    if (!this._inTable) break;
                    ++this._colSkipped;
                    break;
                }
                case '|': {
                    if (this._inTable) {
                        sb.append(line.substring(i));
                        return sb.toString();
                    }
                }
                default: {
                    sb.append(test);
                }
            }
            priorChar = test;
        }
        return sb.toString();
    }

    public String removeFencing(String line) {
        int i;
        String remainingLine = "";
        int pipeOffset = line.indexOf("|");
        if (this._inTable && pipeOffset >= 0) {
            remainingLine = line.substring(pipeOffset);
            line = line.substring(0, pipeOffset);
        }
        String remLine = new String(line);
        StringBuffer sb = new StringBuffer();
        if (this._inTable) {
            Matcher matcher = this._fencePattern1.matcher(remLine);
            while (matcher.find()) {
                this._colSkipped += matcher.end() - matcher.start();
            }
        }
        String[] parts = line.split("```\\w+");
        for (i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            sb.append(parts[i]);
        }
        line = sb.toString();
        remLine = new String(line);
        if (this._inTable) {
            Matcher matcher = this._fencePattern2.matcher(remLine);
            while (matcher.find()) {
                this._colSkipped += matcher.end() - matcher.start();
            }
        }
        sb = new StringBuffer();
        parts = line.split("~~~\\w+");
        for (i = 0; i < parts.length; ++i) {
            if (parts[i].length() == 0) continue;
            sb.append(parts[i]);
        }
        line = sb.toString();
        sb = new StringBuffer();
        char test = ' ';
        block7: for (int i2 = 0; i2 < line.length(); ++i2) {
            test = line.charAt(i2);
            switch (test) {
                case '`': {
                    if (!this._inTable) continue block7;
                    ++this._colSkipped;
                    continue block7;
                }
                default: {
                    sb.append(test);
                }
            }
        }
        return sb.toString() + remainingLine;
    }

    public String removeHeading(String line) {
        StringBuffer sb = new StringBuffer();
        char test = ' ';
        block4: for (int i = 0; i < line.length(); ++i) {
            test = line.charAt(i);
            switch (test) {
                case '#': {
                    if (!this._inTable) continue block4;
                    ++this._colSkipped;
                    continue block4;
                }
                case '|': {
                    if (this._inTable) {
                        return sb.toString() + line.substring(i);
                    }
                }
                default: {
                    sb.append(test);
                }
            }
        }
        return sb.toString();
    }

    public String removeReferencesAndLinks(String line, Map<String, String> refURLs) {
        StringBuffer sb = new StringBuffer();
        String test = line.trim();
        char[] testChars = new char[test.length()];
        test.getChars(0, test.length(), testChars, 0);
        int offset = 0;
        boolean foundBracket = false;
        int bracketCnt = 0;
        int startOffset = -1;
        String refLink = "";
        String url = "";
        String ref = "";
        Stack<Integer> startOffsets = new Stack<Integer>();
        boolean isImageRef = false;
        boolean needLabel = false;
        for (char testChar : testChars) {
            switch (testChar) {
                case '[': {
                    if (!isImageRef) {
                        boolean bl = needLabel = !needLabel;
                    }
                    if (!foundBracket) {
                        foundBracket = true;
                    }
                    startOffsets.push(offset);
                    ++bracketCnt;
                    break;
                }
                case ']': {
                    if (!foundBracket) break;
                    --bracketCnt;
                    startOffset = (Integer)startOffsets.pop();
                    if (offset - startOffset > 1) {
                        if (offset + 1 < test.length()) {
                            if (':' == testChars[offset + 1]) {
                                return null;
                            }
                            refLink = test.substring(startOffset + 1, offset).trim();
                            if (needLabel) {
                                if (_includeLinks) {
                                    sb.append(this._openBracket + refLink + this._closeBracket);
                                    if (this._inTable) {
                                        this._colSkipped -= 2;
                                        if (this._colSkipped < 0) {
                                            this._colSkipped = 0;
                                        }
                                    }
                                } else {
                                    sb.append(refLink);
                                }
                                if ((ref = GetTextFromMarkdown.getRef(test.substring(offset)).trim()).equals("")) {
                                    if (this._inTable) {
                                        this._colSkipped += 2;
                                    }
                                    ref = refLink;
                                } else if (this._inTable) {
                                    this._colSkipped += ref.length() + 2;
                                }
                                url = refURLs.get(ref);
                                if (url != null && _includeLinks) {
                                    sb.append("(");
                                    sb.append(url);
                                    sb.append(")");
                                    if (this._inTable) {
                                        this._colSkipped -= 2 + url.length();
                                        if (this._colSkipped < 0) {
                                            this._colSkipped = 0;
                                        }
                                    }
                                }
                            }
                            if (isImageRef) {
                                needLabel = true;
                            }
                        } else {
                            refLink = test.substring(startOffset + 1, offset).trim();
                            if (needLabel) {
                                if (_includeLinks) {
                                    sb.append(this._openBracket + refLink + this._closeBracket);
                                    if (this._inTable) {
                                        this._colSkipped -= 2;
                                        if (this._colSkipped < 0) {
                                            this._colSkipped = 0;
                                        }
                                    }
                                } else {
                                    sb.append(refLink);
                                }
                                if ((ref = GetTextFromMarkdown.getRef(test.substring(offset)).trim()).equals("")) {
                                    if (this._inTable) {
                                        this._colSkipped += 2;
                                    }
                                    ref = refLink;
                                } else if (this._inTable) {
                                    this._colSkipped += ref.length() + 2;
                                }
                                url = refURLs.get(ref);
                                if (url != null && _includeLinks) {
                                    sb.append("(");
                                    sb.append(url);
                                    sb.append(")");
                                    if (this._inTable) {
                                        this._colSkipped -= 2 + url.length();
                                        if (this._colSkipped < 0) {
                                            this._colSkipped = 0;
                                        }
                                    }
                                }
                            }
                            if (isImageRef) {
                                needLabel = true;
                            }
                        }
                    }
                    if (bracketCnt != 0) break;
                    startOffset = -1;
                    foundBracket = false;
                    isImageRef = false;
                    break;
                }
                case '!': {
                    if (offset < test.length() - 1) {
                        if ('[' == testChars[offset + 1]) {
                            isImageRef = true;
                            needLabel = true;
                            if (!this._inTable) break;
                            ++this._colSkipped;
                            break;
                        }
                        sb.append(testChar);
                        break;
                    }
                    sb.append(testChar);
                    break;
                }
                default: {
                    if (!startOffsets.empty()) break;
                    sb.append(testChar);
                }
            }
            ++offset;
        }
        return sb.toString();
    }

    public String removeAll(String line, String remove) {
        int offset = line.indexOf(remove);
        int pipeOffset = line.indexOf("|");
        if (this._inTable && pipeOffset < offset && pipeOffset >= 0) {
            return line;
        }
        while (offset >= 0) {
            line = line.substring(0, offset) + line.substring(offset + remove.length());
            if (this._inTable) {
                this._colSkipped += remove.length();
            }
            offset = line.indexOf(remove);
            pipeOffset = line.indexOf("|");
            if (!this._inTable || pipeOffset >= offset || pipeOffset < 0) continue;
            return line;
        }
        return line;
    }

    public String removeTableLines(String line) {
        int test = 32;
        boolean foundOutlier = false;
        block3: for (int i = 0; i < line.length() && !foundOutlier; ++i) {
            test = line.charAt(i);
            switch (test) {
                case 32: 
                case 45: 
                case 58: 
                case 124: {
                    continue block3;
                }
                default: {
                    foundOutlier = true;
                }
            }
        }
        if (foundOutlier) {
            return line.substring(1);
        }
        return "";
    }

    public String replaceAll(String line, String search, String replacement) {
        int searchOffset = line.indexOf(search);
        int pipeOffset = line.indexOf("|");
        if (searchOffset < 0) {
            return line;
        }
        if (pipeOffset < searchOffset && this._inTable) {
            return line;
        }
        String test = line.replace(search, replacement);
        int offset = search.length() - replacement.length();
        while (!test.equals(line)) {
            if (this._inTable) {
                this._colSkipped += offset;
                if (this._colSkipped < 0) {
                    this._colSkipped = 0;
                }
            }
            line = test;
            test = line.replace(search, replacement);
        }
        return line;
    }

    public String removeTaskList(String line) {
        line = this.replaceAll(line, "- [ ]", "( )");
        line = this.replaceAll(line, "- [x]", "(x)");
        line = this.replaceAll(line, "- [ x ]", "(x)");
        return line;
    }

    public String removeUnderscore(String line) {
        StringBuffer sb = new StringBuffer();
        int lLen = line.length();
        boolean isEscaped = false;
        for (int i = 0; i < lLen; ++i) {
            if ('\\' == line.charAt(i)) {
                isEscaped = true;
            } else if ('_' == line.charAt(i)) {
                if (isEscaped) {
                    isEscaped = false;
                } else {
                    ++i;
                    if (this._inTable) {
                        ++this._colSkipped;
                    }
                    while (i < lLen && line.charAt(i) == '_') {
                        ++i;
                        if (!this._inTable) continue;
                        ++this._colSkipped;
                    }
                }
            }
            if (this._inTable && line.charAt(i) == '|') {
                return sb.toString();
            }
            if (i >= lLen) continue;
            sb.append(line.charAt(i));
        }
        return sb.toString();
    }

    public GetTextFromMarkdown() {
    }

    public GetTextFromMarkdown(Options options, JSONObject HTMLFilters) {
        this._options = options;
        this._HTMLFilters = HTMLFilters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Path file) throws Exception {
        ProvenanceWriter provenanceWriter = null;
        String html2mdProvenanceFileName = "unknown";
        String provenanceOutputFileName = "unknown";
        JSONObject provenance = null;
        String textOutputFileName = "unknown";
        String fqFileName = file.toString();
        if (this._thumbsucker) {
            System.out.println("Processing: " + fqFileName);
        }
        List markdownList = MDfromHTMLUtils.loadTextFile((String)fqFileName);
        String shortFileName = fqFileName.substring(fqFileName.lastIndexOf(File.separator) + 1);
        int index = shortFileName.lastIndexOf("." + this._ext);
        if (index >= 1) {
            File provenanceOutputFile;
            html2mdProvenanceFileName = this._inputPath + File.separator + shortFileName.substring(0, index) + "_html2md.json";
            provenanceOutputFileName = this._outputPath + shortFileName.substring(0, index) + "_md2txt.json";
            provenance = MDfromHTMLUtils.loadJSONFile((String)html2mdProvenanceFileName);
            this._HTMLFilters = (JSONObject)provenance.get((Object)"htmlFilters");
            String baseURI = (String)provenance.get((Object)"baseURI");
            textOutputFileName = this._outputPath + shortFileName.substring(0, index) + "." + this._txtext;
            String domain = Remark.getDomain((String)baseURI);
            int testindex = baseURI.indexOf(domain);
            String workingURI = baseURI.substring(testindex + domain.length());
            if ((testindex = workingURI.toLowerCase().indexOf("http")) >= 0) {
                workingURI = workingURI.substring(testindex);
                String urlDomain = domain;
                try {
                    urlDomain = URLDecoder.decode(domain, StandardCharsets.UTF_8.name());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (urlDomain.endsWith("/") && urlDomain.length() > 1) {
                    urlDomain = urlDomain.substring(0, urlDomain.length() - 1);
                }
                if (urlDomain.startsWith("http")) {
                    int indexProtocol = urlDomain.lastIndexOf("/");
                    domain = indexProtocol >= 0 ? urlDomain.substring(indexProtocol) : urlDomain;
                }
                baseURI = workingURI;
            }
            if ((provenanceOutputFile = new File(provenanceOutputFileName)).exists()) {
                provenanceOutputFile.delete();
            }
            provenanceWriter = new ProvenanceWriter(fqFileName, textOutputFileName, this._HTMLFilters, baseURI, domain, (Writer)new FileWriter(provenanceOutputFile, true));
            try {
                StringBuffer sb = new StringBuffer();
                int lineNum = 0;
                Map<String, String> refURLs = this.findRefURLs(markdownList);
                for (String mdLine : markdownList) {
                    ++lineNum;
                    if (mdLine.equals("###### Provenance ######")) break;
                    String testLine = this.generateTextFromMarkdown(mdLine, refURLs);
                    if (testLine == null) continue;
                    provenanceWriter.saveMD2Text("" + lineNum, mdLine, testLine);
                    sb.append(testLine);
                    sb.append("\n");
                }
                if (this._thumbsucker) {
                    System.out.println("Writing: " + textOutputFileName);
                }
                MDfromHTMLUtils.saveTextFile((String)textOutputFileName, (String)sb.toString());
            }
            finally {
                if (provenanceWriter != null) {
                    try {
                        provenanceWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        throw new Exception("Error: " + shortFileName + "doesn't end with ." + this._ext);
    }

    boolean getParams(String[] args) {
        File testOutput;
        String inputPath = "." + File.separator + "data" + File.separator + "md";
        String outputPath = "." + File.separator + "data" + File.separator + "txt";
        String tmp = "";
        try {
            if (args.length >= 1) {
                inputPath = args[0];
            } else {
                this._interactive = true;
                this._thumbsucker = true;
                tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to directory containing " + this._ext + " multimarkdown files, or q to exit (" + inputPath + "):"));
                if (tmp == null || tmp.length() == 0) {
                    tmp = inputPath;
                }
                if (tmp.toLowerCase().equals("q")) {
                    return false;
                }
                inputPath = tmp;
            }
            if (!inputPath.endsWith(File.separator)) {
                inputPath = inputPath + File.separator;
            }
            this._inputPath = FileSystems.getDefault().getPath(inputPath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            System.out.println("Error: " + args[0] + " is not a valid directory to form a path.");
            return false;
        }
        if (args.length >= 2) {
            outputPath = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to the text file output directory, or q to exit (" + outputPath + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = outputPath;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            outputPath = tmp;
        }
        if (!outputPath.endsWith(File.separator)) {
            outputPath = outputPath + File.separator;
        }
        if (!(testOutput = new File(outputPath)).exists()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must exist.");
            return false;
        }
        if (!testOutput.isDirectory()) {
            System.out.println("Error: The output directory \"" + outputPath + "\" must be a directory.");
            return false;
        }
        this._outputPath = outputPath;
        String includeLinks = "y";
        if (args == null || args.length >= 3) {
            includeLinks = args[2].trim().toLowerCase().substring(0, 1);
        } else {
            tmp = MDfromHTMLUtils.prompt((String)("Include links in text output (y=yes, n=no), or q to exit (" + includeLinks + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = includeLinks;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            includeLinks = tmp.toLowerCase().substring(0, 1);
        }
        _includeLinks = "y".equals(includeLinks);
        if (args.length >= 4) {
            this._thumbsucker = new Boolean(args[3]);
        }
        return true;
    }
}

