/*
 * Decompiled with CFR 0.152.
 */
package com.mdfromhtml.provenance;

import com.api.json.JSON;
import com.api.json.JSONArray;
import com.api.json.JSONObject;
import com.mdfromhtml.core.MDfromHTMLUtils;
import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import com.overzealous.remark.convert.DefaultNodeHandler;
import com.overzealous.remark.convert.DocumentConverter;
import com.overzealous.remark.convert.NodeHandler;
import com.overzealous.remark.util.BlockWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.safety.Cleaner;

public class FindHTMLFromMarkdown
extends DocumentConverter {
    Cleaner _cleaner = null;
    String _ext = "json";
    String _inputFileName = "unknown";
    Path _inputPath = null;
    boolean _interactive = false;
    boolean _thumbsucker = false;

    public static void main(String[] args) {
        int exitVal = 0;
        JSONObject htmlFilters = null;
        String inputHTMLFileName = "";
        try {
            htmlFilters = MDfromHTMLUtils.loadJSONFile((String)("." + File.separator + "properties" + File.separator + "HTML_Filters.json"));
        }
        catch (Exception e1) {
            System.out.println("Warning: Using no HTML Filters -- can not find \"." + File.separator + "properties" + File.separator + "HTML_Filters.json\": " + e1.getLocalizedMessage());
        }
        Options options = Options.multiMarkdown();
        options.hardwraps = false;
        FindHTMLFromMarkdown pgm = new FindHTMLFromMarkdown(options);
        if (pgm.getParams(args)) {
            if (pgm._thumbsucker) {
                System.out.println("\nLoading the input file " + pgm._inputFileName);
            }
            if (pgm._interactive && MDfromHTMLUtils.prompt((String)"Press q to quit or press Enter to continue...").length() == 0) {
                pgm._interactive = false;
            }
            if (!pgm._interactive) {
                try {
                    String provenanceLevel;
                    JSONObject provenance = (JSONObject)JSON.parse((InputStream)new FileInputStream(new File(pgm._inputFileName)));
                    if (provenance == null) {
                        throw new Exception("Unable to load the input file named \"" + pgm._inputFileName + "\".");
                    }
                    htmlFilters = (JSONObject)provenance.get((Object)"htmlFilters");
                    if (htmlFilters == null) {
                        htmlFilters = new JSONObject();
                    }
                    if ((inputHTMLFileName = (String)provenance.get((Object)"inputFilename")) == null) {
                        throw new Exception("The input provenance file doesn't have an \"inputFilename\" entry.");
                    }
                    String baseUri = (String)provenance.get((Object)"baseURI");
                    if (baseUri == null) {
                        throw new Exception("The input provenance file doesn't have a \"baseURI\" entry.");
                    }
                    String domain = Remark.getDomain((String)baseUri);
                    Document doc = Jsoup.parse((File)new File(inputHTMLFileName), (String)"UTF-8", (String)baseUri);
                    JSONArray provenanceArray = (JSONArray)provenance.get((Object)"provenance");
                    if (provenanceArray == null) {
                        throw new Exception("The input provenance file doesn't have a \"provenance\" array entry.");
                    }
                    Cleaner _cleaner = Remark.updateCleaner((String)domain, (Options)Options.multiMarkdown(), (JSONObject)htmlFilters);
                    doc = _cleaner.clean(doc);
                    while ((provenanceLevel = pgm.getProvenanceChoice(provenanceArray)) != null) {
                        Node htmlNode = pgm.findProvenanceReference(provenanceLevel, htmlFilters, baseUri, domain, doc);
                        if (htmlNode != null) {
                            System.out.println("Provenance level " + provenanceLevel + " found this html node:\n" + htmlNode.toString() + "\n");
                            continue;
                        }
                        System.out.println("Provenance level " + provenanceLevel + " could not find a corresponding node.");
                    }
                }
                catch (Exception e) {
                    System.out.println("Error: " + e.getLocalizedMessage());
                    e.printStackTrace();
                    exitVal = -1;
                }
            }
            if (pgm._thumbsucker) {
                System.out.println();
            }
        } else {
            exitVal = -1;
        }
        if (pgm._thumbsucker) {
            System.out.println("Goodbye");
        }
        System.exit(exitVal);
    }

    public FindHTMLFromMarkdown(Options options) {
        super(options);
    }

    public FindHTMLFromMarkdown(Options options, JSONObject HTMLFilters) {
        super(options, HTMLFilters);
    }

    Node findProvenanceReference(String searchLevel, JSONObject htmlFilters, String baseUri, String domain, Document doc) {
        BlockWriter bw;
        Node result = null;
        this.output = bw = BlockWriter.create((int)DocumentConverter.calculateLength((Element)doc, (int)0));
        this.lastNodeset = this.blockNodes;
        this.linkIds = new LinkedHashMap();
        this.linkUrls = new HashMap();
        this.abbreviations = new LinkedHashMap();
        this.lastNodeset = this.blockNodes;
        String level = "1";
        Element body = doc.body();
        if (searchLevel != null && searchLevel.equals(level)) {
            return body;
        }
        result = this.walkNodes((NodeHandler)DefaultNodeHandler.getInstance(), body, this.blockNodes, null, baseUri, domain, level, searchLevel);
        return result;
    }

    public boolean getParams(String[] args) {
        String inputPath = "." + File.separator + "data" + File.separator + "md";
        String inputFileName = "swg21122368_001_html2md.json";
        String tmp = "";
        try {
            if (args.length >= 1) {
                inputPath = args[0];
            } else {
                this._interactive = true;
                this._thumbsucker = true;
                tmp = MDfromHTMLUtils.prompt((String)("Enter the fully qualified path to directory containing " + this._ext + " html2md provenance files, or q to exit (" + inputPath + "):"));
                if (tmp == null || tmp.length() == 0) {
                    tmp = inputPath;
                }
                if (tmp.toLowerCase().equals("q")) {
                    return false;
                }
                inputPath = tmp;
            }
            if (!inputPath.endsWith(File.separator)) {
                inputPath = inputPath + File.separator;
            }
            this._inputPath = FileSystems.getDefault().getPath(inputPath, new String[0]);
        }
        catch (InvalidPathException ipe) {
            System.out.println("Error: " + args[0] + " is not a valid directory to form a path.");
            return false;
        }
        if (args.length >= 2) {
            inputFileName = args[1];
        } else {
            this._interactive = true;
            this._thumbsucker = true;
            tmp = MDfromHTMLUtils.prompt((String)("Enter the file name of the html2md provenance file, or q to exit (" + inputFileName + "):"));
            if (tmp == null || tmp.length() == 0) {
                tmp = inputFileName;
            }
            if (tmp.toLowerCase().equals("q")) {
                return false;
            }
            inputFileName = tmp;
        }
        inputFileName = inputPath + inputFileName;
        File testOutput = new File(inputFileName);
        if (!testOutput.exists()) {
            System.out.println("Error: The input file \"" + inputFileName + "\" must exist.");
            return false;
        }
        if (testOutput.isDirectory()) {
            System.out.println("Error: The input file \"" + inputFileName + "\" must not be a directory.");
            return false;
        }
        this._inputFileName = inputFileName;
        if (args.length >= 3) {
            this._thumbsucker = new Boolean(args[2]);
        }
        return true;
    }

    String getProvenanceChoice(JSONArray provenanceArray) {
        String result;
        block14: {
            int choice;
            result = null;
            int maxLines = provenanceArray.size();
            int displayMax = 10;
            String test = "";
            int currentStart = 0;
            int currentEnd = currentStart + displayMax;
            if (currentEnd > maxLines) {
                currentEnd = maxLines;
            }
            JSONObject lineObj = null;
            while (true) {
                result = null;
                for (int i = currentStart; i < currentEnd; ++i) {
                    lineObj = (JSONObject)provenanceArray.get(i);
                    System.out.println(MDfromHTMLUtils.padLeft((String)("" + i), (int)2, (char)' ') + ": " + lineObj.get((Object)"md"));
                }
                test = MDfromHTMLUtils.prompt((String)"Enter line number, > (or n) for next page, < (or p) for prior page, s for search, q to quit:");
                if ("q".equalsIgnoreCase(test)) break block14;
                if ("<".equals(test) || "p".equalsIgnoreCase(test)) {
                    if ((currentStart -= displayMax) < 0) {
                        currentStart = 0;
                    }
                    if ((currentEnd = currentStart + displayMax) <= maxLines) continue;
                    currentEnd = maxLines;
                    continue;
                }
                if (">".equals(test) || "n".equalsIgnoreCase(test)) {
                    if ((currentStart += displayMax) >= maxLines) {
                        currentStart = maxLines - displayMax;
                    }
                    if (currentStart < 0) {
                        currentStart = 0;
                    }
                    if ((currentEnd = currentStart + displayMax) <= maxLines) continue;
                    currentEnd = maxLines;
                    continue;
                }
                if ("e".equalsIgnoreCase(test)) {
                    currentEnd = maxLines;
                    currentStart = currentEnd - displayMax;
                    if (currentStart >= 0) continue;
                    currentStart = 0;
                    continue;
                }
                if ("s".equalsIgnoreCase(test)) {
                    String searchString = MDfromHTMLUtils.prompt((String)"Enter the search string: ");
                    if (searchString.length() == 0) continue;
                    JSONObject htmlObj = null;
                    boolean foundIt = false;
                    for (Object obj : provenanceArray) {
                        htmlObj = (JSONObject)obj;
                        if (!searchString.equals((String)htmlObj.get((Object)"md"))) continue;
                        foundIt = true;
                        break;
                    }
                    if (foundIt) {
                        result = (String)htmlObj.get((Object)"level");
                        break block14;
                    }
                    System.out.println("Could not find a match for search \"" + searchString + "\", try again.");
                    continue;
                }
                choice = -1;
                try {
                    choice = new Integer(test);
                    if (choice >= 0 && choice < maxLines) break;
                    System.out.println("Choice must be >= 0 and < " + maxLines + ", try again.");
                }
                catch (NumberFormatException nfe) {
                    System.out.println(test + " is not a valid number choice, try again.");
                }
            }
            result = (String)((JSONObject)provenanceArray.get(choice)).get((Object)"level");
        }
        return result;
    }
}

