/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.spring.boot;

import com.ibm.mq.spring.boot.MQConfigurationProperties;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.ssl.NoSuchSslBundleException;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={MQConfigurationProperties.class})
public class MQConfigurationSslBundles {
    private static Logger logger = LoggerFactory.getLogger(MQConfigurationSslBundles.class);
    private static SslBundles sslBundles = null;

    public MQConfigurationSslBundles(SslBundles _sslBundles) {
        logger.trace("constructor - Bundles are {}", (Object)(_sslBundles == null ? "null" : "not null"));
        sslBundles = _sslBundles;
    }

    static boolean isSupported() {
        logger.trace("SSLBundles are supported");
        return true;
    }

    public static SSLSocketFactory getSSLSocketFactory(String b) {
        SSLSocketFactory sf = null;
        if (b == null || b.isEmpty()) {
            logger.trace("getSSLSocketFactory - null/empty bundle name requested");
            return sf;
        }
        if (sslBundles != null) {
            try {
                SslBundle sb = sslBundles.getBundle(b);
                logger.trace("SSL Bundle for {} - found", (Object)b);
                SSLContext sc = sb.createSslContext();
                sf = sc.getSocketFactory();
            }
            catch (NoSuchSslBundleException e) {
                logger.error("SSL bundle for {} - not found", (Object)b);
            }
        }
        return sf;
    }
}

