/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased;

import com.ibm.wala.cast.ipa.callgraph.AstContextInsensitiveSSAContextInterpreter;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraph;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.CallVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.FuncVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.ObjectVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VarVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VertexFactory;
import com.ibm.wala.cast.js.ipa.callgraph.JSAnalysisOptions;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraph;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptConstructTargetSelector;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptFunctionApplyContextInterpreter;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptFunctionApplyTargetSelector;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptFunctionDotCallTargetSelector;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptConstructorFunctions;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextSelector;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.MethodTargetSelector;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.ContextInsensitiveSelector;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.callgraph.propagation.SSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DefaultSSAInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.DelegatingSSAContextInterpreter;
import com.ibm.wala.ipa.callgraph.propagation.cfa.nCFAContextSelector;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.intset.OrdinalSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public abstract class FieldBasedCallGraphBuilder {
    protected final IClassHierarchy cha;
    protected final AnalysisOptions options;
    protected final IAnalysisCacheView cache;
    protected final JavaScriptConstructorFunctions constructors;
    public final MethodTargetSelector targetSelector;
    protected final boolean supportFullPointerAnalysis;
    private static final boolean LOG_TIMINGS = true;
    Set<IClass> constructedTypes = HashSetFactory.make();
    Everywhere targetContext = Everywhere.EVERYWHERE;

    public FieldBasedCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView iAnalysisCacheView, boolean supportFullPointerAnalysis) {
        this.cha = cha;
        this.options = options;
        this.cache = iAnalysisCacheView;
        this.constructors = new JavaScriptConstructorFunctions(cha);
        this.targetSelector = FieldBasedCallGraphBuilder.setupMethodTargetSelector(this.constructors, options);
        this.supportFullPointerAnalysis = supportFullPointerAnalysis;
    }

    private static MethodTargetSelector setupMethodTargetSelector(JavaScriptConstructorFunctions constructors2, AnalysisOptions options) {
        Object result = new JavaScriptConstructTargetSelector(constructors2, options.getMethodTargetSelector());
        if (options instanceof JSAnalysisOptions && ((JSAnalysisOptions)options).handleCallApply()) {
            result = new JavaScriptFunctionApplyTargetSelector(new JavaScriptFunctionDotCallTargetSelector((MethodTargetSelector)result));
        }
        return result;
    }

    protected FlowGraph flowGraphFactory() {
        FlowGraphBuilder builder = new FlowGraphBuilder(this.cha, this.cache, this.supportFullPointerAnalysis);
        return builder.buildFlowGraph();
    }

    public abstract FlowGraph buildFlowGraph(MonitorUtil.IProgressMonitor var1) throws CancelException;

    public Pair<JSCallGraph, PointerAnalysis<ObjectVertex>> buildCallGraph(Iterable<? extends Entrypoint> eps, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        long fgBegin = System.currentTimeMillis();
        MonitorUtil.beginTask((MonitorUtil.IProgressMonitor)monitor, (String)"flow graph", (int)1);
        FlowGraph flowGraph = this.buildFlowGraph(monitor);
        MonitorUtil.done((MonitorUtil.IProgressMonitor)monitor);
        long fgEnd = System.currentTimeMillis();
        System.out.println("flow graph construction took " + (double)(fgEnd - fgBegin) / 1000.0 + " seconds");
        long cgBegin = System.currentTimeMillis();
        MonitorUtil.beginTask((MonitorUtil.IProgressMonitor)monitor, (String)"extract call graph", (int)1);
        JSCallGraph cg = this.extract(flowGraph, eps, monitor);
        MonitorUtil.done((MonitorUtil.IProgressMonitor)monitor);
        long cgEnd = System.currentTimeMillis();
        System.out.println("call graph extraction took " + (double)(cgEnd - cgBegin) / 1000.0 + " seconds");
        return Pair.make((Object)((Object)cg), flowGraph.getPointerAnalysis((CallGraph)cg, this.cache, monitor));
    }

    public JSCallGraph extract(FlowGraph flowgraph, Iterable<? extends Entrypoint> eps, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        DelegatingSSAContextInterpreter interpreter = new DelegatingSSAContextInterpreter((SSAContextInterpreter)new AstContextInsensitiveSSAContextInterpreter(this.options, this.cache), (SSAContextInterpreter)new DefaultSSAInterpreter(this.options, this.cache));
        return this.extract((SSAContextInterpreter)interpreter, flowgraph, eps, monitor);
    }

    public JSCallGraph extract(SSAContextInterpreter interpreter, FlowGraph flowgraph, Iterable<? extends Entrypoint> eps, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        JSCallGraph cg = new JSCallGraph((IMethod)JavaScriptLoader.JS.getFakeRootMethod(this.cha, this.options, this.cache), this.options, this.cache);
        cg.init();
        if (this.options instanceof JSAnalysisOptions && ((JSAnalysisOptions)this.options).handleCallApply()) {
            interpreter = new DelegatingSSAContextInterpreter((SSAContextInterpreter)new JavaScriptFunctionApplyContextInterpreter(this.options, this.cache), interpreter);
        }
        cg.setInterpreter(interpreter);
        AbstractRootMethod fakeRootMethod = (AbstractRootMethod)cg.getFakeRootNode().getMethod();
        CGNode fakeRootNode = cg.findOrCreateNode((IMethod)fakeRootMethod, (Context)Everywhere.EVERYWHERE);
        for (Entrypoint entrypoint : eps) {
            CGNode nd = cg.findOrCreateNode(entrypoint.getMethod(), (Context)Everywhere.EVERYWHERE);
            SSAAbstractInvokeInstruction invk = entrypoint.addCall(fakeRootMethod);
            fakeRootNode.addTarget(invk.getCallSite(), nd);
        }
        cg.registerEntrypoint(fakeRootNode);
        Set<Pair<CallVertex, FuncVertex>> edges = this.extractCallGraphEdges(flowgraph, monitor);
        for (Pair<CallVertex, FuncVertex> edge : edges) {
            boolean isFunctionPrototypeApply;
            CallSiteReference site;
            CallVertex callVertex = (CallVertex)edge.fst;
            FuncVertex targetVertex = (FuncVertex)edge.snd;
            IClass kaller = callVertex.getCaller().getConcreteType();
            CGNode caller = cg.findOrCreateNode(kaller.getMethod(AstMethodReference.fnSelector), (Context)Everywhere.EVERYWHERE);
            IMethod target = this.targetSelector.getCalleeTarget(caller, site = callVertex.getSite(), targetVertex.getConcreteType());
            boolean isFunctionPrototypeCall = target != null && target.getName().toString().startsWith("$$ call_");
            boolean bl = isFunctionPrototypeApply = target != null && target.getName().toString().startsWith("$$ apply_dummy");
            if (isFunctionPrototypeCall || isFunctionPrototypeApply) {
                this.handleFunctionCallOrApplyInvocation(flowgraph, monitor, cg, callVertex, caller, site, target);
                continue;
            }
            this.addEdgeToJSCallGraph(cg, site, target, caller);
            if (!(target instanceof JavaScriptConstructorFunctions.JavaScriptConstructor)) continue;
            IMethod fun = ((JavaScriptConstructorFunctions.JavaScriptConstructor)target).constructedType().getMethod(AstMethodReference.fnSelector);
            CGNode ctorCaller = cg.findOrCreateNode(target, (Context)Everywhere.EVERYWHERE);
            CallSiteReference ref = null;
            Iterator sites = ctorCaller.iterateCallSites();
            while (sites.hasNext()) {
                CallSiteReference r = (CallSiteReference)sites.next();
                if (!r.getDeclaredTarget().getSelector().equals((Object)AstMethodReference.fnSelector)) continue;
                ref = r;
                break;
            }
            if (ref == null) continue;
            this.addEdgeToJSCallGraph(cg, ref, fun, ctorCaller);
        }
        return cg;
    }

    public boolean handleFunctionCallOrApplyInvocation(FlowGraph flowgraph, MonitorUtil.IProgressMonitor monitor, JSCallGraph cg, CallVertex callVertex, CGNode caller, CallSiteReference site, IMethod target) throws CancelException {
        nCFAContextSelector functionPrototypeCallSelector = new nCFAContextSelector(1, (ContextSelector)new ContextInsensitiveSelector());
        Context calleeContext = functionPrototypeCallSelector.getCalleeTarget(caller, site, target, null);
        boolean ret = FieldBasedCallGraphBuilder.addCGEdgeWithContext(cg, site, target, caller, calleeContext);
        CGNode functionPrototypeCallNode = cg.findOrCreateNode(target, calleeContext);
        OrdinalSet<FuncVertex> reflectiveTargets = FieldBasedCallGraphBuilder.getReflectiveTargets(flowgraph, callVertex, monitor);
        System.err.println("adding callees " + reflectiveTargets + " for " + caller);
        CallSiteReference reflectiveCallSite = (CallSiteReference)functionPrototypeCallNode.getIR().iterateCallSites().next();
        for (FuncVertex f : reflectiveTargets) {
            IMethod reflectiveTgtMethod = this.targetSelector.getCalleeTarget(functionPrototypeCallNode, reflectiveCallSite, f.getConcreteType());
            ret |= this.addEdgeToJSCallGraph(cg, reflectiveCallSite, reflectiveTgtMethod, functionPrototypeCallNode);
        }
        return ret;
    }

    public boolean addEdgeToJSCallGraph(JSCallGraph cg, CallSiteReference site, IMethod target, CGNode caller) throws CancelException {
        return FieldBasedCallGraphBuilder.addCGEdgeWithContext(cg, site, target, caller, (Context)Everywhere.EVERYWHERE);
    }

    private static boolean addCGEdgeWithContext(JSCallGraph cg, CallSiteReference site, IMethod target, CGNode caller, Context targetContext) throws CancelException {
        boolean ret = false;
        if (target != null) {
            CGNode callee = cg.findOrCreateNode(target, targetContext);
            cg.addNode(caller);
            cg.addNode(callee);
            boolean bl = ret = !cg.getPossibleTargets(caller, site).contains(callee);
            if (ret) {
                cg.addEdge(caller, callee);
                caller.addTarget(site, callee);
            }
        }
        return ret;
    }

    private static OrdinalSet<FuncVertex> getReflectiveTargets(FlowGraph flowGraph, CallVertex callVertex, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        JavaScriptInvoke invoke = callVertex.getInstruction();
        VarVertex functionParam = flowGraph.getVertexFactory().makeVarVertex(callVertex.getCaller(), invoke.getUse(1));
        return flowGraph.getReachingSet(functionParam, monitor);
    }

    private static OrdinalSet<FuncVertex> getConstructorTargets(FlowGraph flowGraph, CallVertex callVertex, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        JavaScriptInvoke invoke = callVertex.getInstruction();
        assert (invoke.getDeclaredTarget().getName().equals((Object)JavaScriptMethods.ctorAtom));
        VarVertex objectParam = flowGraph.getVertexFactory().makeVarVertex(callVertex.getCaller(), invoke.getUse(0));
        return flowGraph.getReachingSet(objectParam, monitor);
    }

    public Set<Pair<CallVertex, FuncVertex>> extractCallGraphEdges(FlowGraph flowgraph, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        VertexFactory factory = flowgraph.getVertexFactory();
        HashSet result = HashSetFactory.make();
        for (CallVertex callVertex : factory.getCallVertices()) {
            for (FuncVertex funcVertex : flowgraph.getReachingSet(callVertex, monitor)) {
                result.add(Pair.make((Object)callVertex, (Object)funcVertex));
            }
        }
        return result;
    }
}

