/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased;

import com.ibm.wala.cast.js.callgraph.fieldbased.FieldBasedCallGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraph;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.FlowGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.CallVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.FuncVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VarVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.Vertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VertexFactory;
import com.ibm.wala.cast.js.ipa.callgraph.JSAnalysisOptions;
import com.ibm.wala.cast.js.ssa.JavaScriptInvoke;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.types.AstMethodReference;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class WorklistBasedOptimisticCallgraphBuilder
extends FieldBasedCallGraphBuilder {
    public int ITERATION_CUTOFF = Integer.MAX_VALUE;
    private final boolean handleCallApply;
    private FlowGraphBuilder builder;

    public WorklistBasedOptimisticCallgraphBuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache, boolean supportFullPointerAnalysis) {
        super(cha, options, cache, supportFullPointerAnalysis);
        this.handleCallApply = options instanceof JSAnalysisOptions && ((JSAnalysisOptions)options).handleCallApply();
    }

    @Override
    public FlowGraph buildFlowGraph(MonitorUtil.IProgressMonitor monitor) throws CancelException {
        this.builder = new FlowGraphBuilder(this.cha, this.cache, false);
        return this.builder.buildFlowGraph();
    }

    @Override
    public Set<Pair<CallVertex, FuncVertex>> extractCallGraphEdges(FlowGraph flowgraph, MonitorUtil.IProgressMonitor monitor) throws CancelException {
        VertexFactory factory = flowgraph.getVertexFactory();
        HashSet worklist = HashSetFactory.make();
        HashMap reachingFunctions = HashMapFactory.make();
        HashMap reflectiveCalleeVertices = HashMapFactory.make();
        for (Vertex v : flowgraph) {
            if (!(v instanceof FuncVertex)) continue;
            FuncVertex fv = (FuncVertex)v;
            worklist.add(fv);
            MapUtil.findOrCreateSet((Map)reachingFunctions, (Object)fv).add(fv);
        }
        while (!worklist.isEmpty()) {
            MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)monitor);
            Vertex v = (Vertex)worklist.iterator().next();
            worklist.remove(v);
            Set vReach = MapUtil.findOrCreateSet((Map)reachingFunctions, (Object)v);
            for (Vertex w : Iterator2Iterable.make(flowgraph.getSucc(v))) {
                MonitorUtil.throwExceptionIfCanceled((MonitorUtil.IProgressMonitor)monitor);
                Set wReach = MapUtil.findOrCreateSet((Map)reachingFunctions, (Object)w);
                boolean changed = false;
                if (w instanceof CallVertex) {
                    for (FuncVertex fv : vReach) {
                        if (!wReach.add(fv)) continue;
                        changed = true;
                        this.addCallEdge(flowgraph, (CallVertex)w, fv, worklist);
                        if (!this.handleCallApply || !changed || !fv.getFullName().equals("Lprologue.js/Function_prototype_call")) continue;
                        JavaScriptInvoke invk = ((CallVertex)w).getInstruction();
                        VarVertex reflectiveCalleeVertex = factory.makeVarVertex(((CallVertex)w).getCaller(), invk.getUse(1));
                        reflectiveCalleeVertices.put(reflectiveCalleeVertex, invk);
                        for (FuncVertex fw : MapUtil.findOrCreateSet((Map)reachingFunctions, (Object)reflectiveCalleeVertex)) {
                            this.addReflectiveCallEdge(flowgraph, reflectiveCalleeVertex, invk, fw, worklist);
                        }
                    }
                } else if (this.handleCallApply && reflectiveCalleeVertices.containsKey(w)) {
                    JavaScriptInvoke invk = (JavaScriptInvoke)((Object)reflectiveCalleeVertices.get(w));
                    for (FuncVertex fv : vReach) {
                        if (!wReach.add(fv)) continue;
                        changed = true;
                        this.addReflectiveCallEdge(flowgraph, (VarVertex)w, invk, fv, worklist);
                    }
                } else {
                    changed = wReach.addAll(vReach);
                }
                if (!changed) continue;
                worklist.add(w);
            }
        }
        HashSet res = HashSetFactory.make();
        for (Map.Entry entry : reachingFunctions.entrySet()) {
            Vertex v = (Vertex)entry.getKey();
            if (!(v instanceof CallVertex)) continue;
            for (FuncVertex fv : (Set)entry.getValue()) {
                res.add(Pair.make((Object)((CallVertex)v), (Object)fv));
            }
        }
        return res;
    }

    private void addCallEdge(FlowGraph flowgraph, CallVertex c, FuncVertex callee, Set<Vertex> worklist) {
        VertexFactory factory = flowgraph.getVertexFactory();
        FuncVertex caller = c.getCaller();
        JavaScriptInvoke invk = c.getInstruction();
        int offset = 0;
        if (invk.getDeclaredTarget().getSelector().equals((Object)JavaScriptMethods.ctorReference.getSelector())) {
            offset = 1;
        }
        for (int i = 0; i < invk.getNumberOfPositionalParameters(); ++i) {
            flowgraph.addEdge(factory.makeVarVertex(caller, invk.getUse(i)), factory.makeArgVertex(callee));
            if (i == 1 && invk.getDeclaredTarget().getSelector().equals((Object)AstMethodReference.fnSelector)) continue;
            this.addFlowEdge(flowgraph, factory.makeVarVertex(caller, invk.getUse(i)), factory.makeParamVertex(callee, i + offset), worklist);
        }
        this.addFlowEdge(flowgraph, factory.makeRetVertex(callee), factory.makeVarVertex(caller, invk.getDef()), worklist);
    }

    public void addFlowEdge(FlowGraph flowgraph, Vertex from, Vertex to, Set<Vertex> worklist) {
        flowgraph.addEdge(from, to);
        worklist.add(from);
    }

    private void addReflectiveCallEdge(FlowGraph flowgraph, VarVertex reflectiveCallee, JavaScriptInvoke invk, FuncVertex realCallee, Set<Vertex> worklist) {
        VertexFactory factory = flowgraph.getVertexFactory();
        FuncVertex caller = reflectiveCallee.getFunction();
        for (int i = 2; i < invk.getNumberOfPositionalParameters(); ++i) {
            this.addFlowEdge(flowgraph, factory.makeVarVertex(caller, invk.getUse(i)), factory.makeParamVertex(realCallee, i - 1), worklist);
            this.addFlowEdge(flowgraph, factory.makeRetVertex(realCallee), factory.makeVarVertex(caller, invk.getDef()), worklist);
        }
    }
}

