/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices;

import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.ObjectVertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.Vertex;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.VertexVisitor;
import com.ibm.wala.cast.js.ipa.summaries.JavaScriptConstructorFunctions;
import com.ibm.wala.cast.js.types.JavaScriptMethods;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.Pair;
import java.util.Iterator;
import java.util.Set;

public class FuncVertex
extends Vertex
implements ObjectVertex {
    protected final IClass klass;

    FuncVertex(IClass method) {
        this.klass = method;
    }

    public String getFullName() {
        return this.klass.getName().toString();
    }

    @Override
    public <T> T accept(VertexVisitor<T> visitor) {
        return visitor.visitFuncVertex(this);
    }

    public String toString() {
        String methodName = this.klass.getName().toString();
        return "Func(" + methodName.substring(methodName.lastIndexOf(47) + 1) + ')';
    }

    public Iterator<Pair<CGNode, NewSiteReference>> getCreationSites(CallGraph CG) {
        MethodReference ctorRef = JavaScriptMethods.makeCtorReference(JavaScriptTypes.Function);
        Set f = CG.getNodes(ctorRef);
        CGNode ctor = null;
        for (CGNode n : f) {
            JavaScriptConstructorFunctions.JavaScriptConstructor c = (JavaScriptConstructorFunctions.JavaScriptConstructor)n.getMethod();
            if (!c.constructedType().equals(this.klass)) continue;
            ctor = n;
            break;
        }
        if (ctor == null) {
            return EmptyIterator.instance();
        }
        Iterator callers = CG.getPredNodes(ctor);
        CGNode caller = (CGNode)callers.next();
        assert (!callers.hasNext());
        Iterator sites = CG.getPossibleSites(caller, ctor);
        CallSiteReference site = (CallSiteReference)sites.next();
        assert (!sites.hasNext()) : caller + " --> " + ctor + " @ " + site + " and " + sites.next() + '\n' + caller.getIR();
        return NonNullSingletonIterator.make((Object)Pair.make((Object)caller, (Object)NewSiteReference.make((int)site.getProgramCounter(), (TypeReference)this.klass.getReference())));
    }

    public IClass getConcreteType() {
        return this.klass;
    }
}

