/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.client;

import com.ibm.wala.cast.ipa.callgraph.CAstAnalysisScope;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.js.callgraph.fieldbased.FieldBasedCallGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.OptimisticCallgraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.PessimisticCallGraphBuilder;
import com.ibm.wala.cast.js.callgraph.fieldbased.flowgraph.vertices.ObjectVertex;
import com.ibm.wala.cast.js.client.impl.ZeroCFABuilderFactory;
import com.ibm.wala.cast.js.ipa.callgraph.JSAnalysisOptions;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraph;
import com.ibm.wala.cast.js.ipa.callgraph.JSCallGraphUtil;
import com.ibm.wala.cast.js.ipa.callgraph.JavaScriptEntryPoints;
import com.ibm.wala.cast.js.loader.JavaScriptLoader;
import com.ibm.wala.cast.js.loader.JavaScriptLoaderFactory;
import com.ibm.wala.cast.js.translator.JavaScriptTranslatorFactory;
import com.ibm.wala.cast.js.types.JavaScriptTypes;
import com.ibm.wala.cast.loader.SingleClassLoaderFactory;
import com.ibm.wala.classLoader.ClassLoaderFactory;
import com.ibm.wala.classLoader.Language;
import com.ibm.wala.classLoader.Module;
import com.ibm.wala.classLoader.SourceModule;
import com.ibm.wala.client.AbstractAnalysisEngine;
import com.ibm.wala.ipa.callgraph.AnalysisCacheImpl;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.CallGraphBuilder;
import com.ibm.wala.ipa.callgraph.CallGraphBuilderCancelException;
import com.ibm.wala.ipa.callgraph.Entrypoint;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.PointerAnalysis;
import com.ibm.wala.ipa.cha.ClassHierarchyException;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ipa.cha.SeqClassHierarchyFactory;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import com.ibm.wala.util.debug.Assertions;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.JarFile;

public abstract class JavaScriptAnalysisEngine<I extends InstanceKey>
extends AbstractAnalysisEngine<I, CallGraphBuilder<I>, Void> {
    protected JavaScriptLoaderFactory loaderFactory;
    protected JavaScriptTranslatorFactory translatorFactory;

    public void buildAnalysisScope() {
        this.loaderFactory = new JavaScriptLoaderFactory(this.translatorFactory);
        SourceModule[] files = this.moduleFiles.toArray(new SourceModule[0]);
        this.scope = new CAstAnalysisScope((Module[])files, (SingleClassLoaderFactory)this.loaderFactory, Collections.singleton(JavaScriptLoader.JS));
    }

    public IClassHierarchy buildClassHierarchy() {
        try {
            return this.setClassHierarchy((IClassHierarchy)SeqClassHierarchyFactory.make((AnalysisScope)this.getScope(), (ClassLoaderFactory)this.loaderFactory, (Language)JavaScriptLoader.JS));
        }
        catch (ClassHierarchyException e) {
            Assertions.UNREACHABLE((String)e.toString());
            return null;
        }
    }

    public void setTranslatorFactory(JavaScriptTranslatorFactory factory) {
        this.translatorFactory = factory;
    }

    public void setJ2SELibraries(JarFile[] libs) {
        Assertions.UNREACHABLE((String)"Illegal to call setJ2SELibraries");
    }

    public void setJ2SELibraries(Module[] libs) {
        Assertions.UNREACHABLE((String)"Illegal to call setJ2SELibraries");
    }

    protected Iterable<Entrypoint> makeDefaultEntrypoints(AnalysisScope scope, IClassHierarchy cha) {
        return new JavaScriptEntryPoints(cha, cha.getLoader(JavaScriptTypes.jsLoader));
    }

    public IAnalysisCacheView makeDefaultCache() {
        return new AnalysisCacheImpl(AstIRFactory.makeDefaultFactory());
    }

    public JSAnalysisOptions getDefaultOptions(Iterable<Entrypoint> roots) {
        JSAnalysisOptions options = new JSAnalysisOptions(this.scope, roots);
        options.setUseConstantSpecificKeys(true);
        options.setUseStacksForLexicalScoping(true);
        return options;
    }

    public static class PropagationJavaScriptAnalysisEngine
    extends JavaScriptAnalysisEngine<InstanceKey> {
        protected CallGraphBuilder<InstanceKey> getCallGraphBuilder(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            return new ZeroCFABuilderFactory().make((JSAnalysisOptions)options, cache, cha);
        }
    }

    public static class FieldBasedJavaScriptAnalysisEngine
    extends JavaScriptAnalysisEngine<ObjectVertex> {
        private BuilderType builderType = BuilderType.OPTIMISTIC;

        public BuilderType getBuilderType() {
            return this.builderType;
        }

        public void setBuilderType(BuilderType builderType) {
            this.builderType = builderType;
        }

        @Override
        public JSAnalysisOptions getDefaultOptions(Iterable<Entrypoint> roots) {
            return JSCallGraphUtil.makeOptions(this.scope, this.getClassHierarchy(), roots);
        }

        protected CallGraphBuilder<ObjectVertex> getCallGraphBuilder(final IClassHierarchy cha, AnalysisOptions options, final IAnalysisCacheView cache) {
            HashSet roots = HashSetFactory.make();
            for (Entrypoint e : options.getEntrypoints()) {
                roots.add(e);
            }
            if (this.builderType.equals((Object)BuilderType.OPTIMISTIC)) {
                ((JSAnalysisOptions)options).setHandleCallApply(false);
            }
            final FieldBasedCallGraphBuilder builder = this.builderType.equals((Object)BuilderType.PESSIMISTIC) ? new PessimisticCallGraphBuilder(this.getClassHierarchy(), options, this.makeDefaultCache(), true) : new OptimisticCallgraphBuilder(this.getClassHierarchy(), options, this.makeDefaultCache(), true);
            return new CallGraphBuilder<ObjectVertex>(){
                private PointerAnalysis<ObjectVertex> ptr;

                public CallGraph makeCallGraph(AnalysisOptions options, MonitorUtil.IProgressMonitor monitor) throws IllegalArgumentException, CallGraphBuilderCancelException {
                    Pair<JSCallGraph, PointerAnalysis<ObjectVertex>> dat;
                    try {
                        dat = builder.buildCallGraph(options.getEntrypoints(), monitor);
                    }
                    catch (CancelException e) {
                        throw CallGraphBuilderCancelException.createCallGraphBuilderCancelException((Exception)((Object)e), null, null);
                    }
                    this.ptr = (PointerAnalysis)dat.snd;
                    return (CallGraph)dat.fst;
                }

                public PointerAnalysis<ObjectVertex> getPointerAnalysis() {
                    return this.ptr;
                }

                public IAnalysisCacheView getAnalysisCache() {
                    return cache;
                }

                public IClassHierarchy getClassHierarchy() {
                    return cha;
                }
            };
        }

        public static enum BuilderType {
            PESSIMISTIC,
            OPTIMISTIC,
            REFLECTIVE;

        }
    }
}

