/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.js.html.DomLessSourceExtractor;
import com.ibm.wala.cast.js.html.ITag;
import com.ibm.wala.cast.js.html.IUrlResolver;
import com.ibm.wala.cast.js.html.JSSourceExtractor;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;

public class DefaultSourceExtractor
extends DomLessSourceExtractor {
    public static Supplier<JSSourceExtractor> factory = DefaultSourceExtractor::new;

    @Override
    protected DomLessSourceExtractor.IGeneratorCallback createHtmlCallback(URL entrypointUrl, IUrlResolver urlResolver) {
        return new HtmlCallBack(entrypointUrl, urlResolver);
    }

    protected static class HtmlCallBack
    extends DomLessSourceExtractor.HtmlCallback {
        private final HashMap<String, String> constructors = HashMapFactory.make();
        private final Stack<String> stack = new Stack();
        private final Stack<ITag> forms = new Stack();
        private final Set<Pair<ITag, String>> sets = new HashSet<Pair<ITag, String>>();

        public HtmlCallBack(URL entrypointUrl, IUrlResolver urlResolver) {
            super(entrypointUrl, urlResolver);
            this.constructors.put("FORM", "DOMHTMLFormElement");
            this.constructors.put("TABLE", "DOMHTMLTableElement");
        }

        @Override
        public void handleEndTag(ITag tag) {
            super.handleEndTag(tag);
            this.endElement(this.stack.pop());
            if (tag.getName().equalsIgnoreCase("FORM")) {
                this.forms.pop();
            }
            for (Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> e : tag.getAllAttributes().entrySet()) {
                String a = e.getKey();
                String v = (String)e.getValue().fst;
                if (v == null || !v.startsWith("javascript:")) continue;
                try {
                    this.writeEntrypoint("           " + v.substring(11), (CAstSourcePositionMap.Position)e.getValue().snd, new URL(tag.getElementPosition().getURL().toString() + '#' + a), true);
                }
                catch (MalformedURLException ex) {
                    this.writeEntrypoint(v.substring(11), (CAstSourcePositionMap.Position)e.getValue().snd, this.entrypointUrl, false);
                }
            }
        }

        @Override
        protected void handleDOM(ITag tag, String funcName) {
            String cons = this.constructors.get(tag.getName().toUpperCase());
            if (cons == null) {
                cons = "DOMHTMLElement";
            }
            this.writeElement(tag, cons, funcName);
            this.newLine();
        }

        protected void printlnIndented(String line, ITag relatedTag) {
            this.printlnIndented(line, relatedTag == null ? null : relatedTag.getElementPosition());
        }

        private void printlnIndented(String line, CAstSourcePositionMap.Position pos) {
            StringBuilder indentedLine = new StringBuilder();
            for (int i = 0; i < this.stack.size(); ++i) {
                indentedLine.append("  ");
            }
            indentedLine.append(line);
            if (pos == null) {
                this.domRegion.println(indentedLine.toString());
            } else {
                this.domRegion.println(indentedLine.toString(), pos, this.entrypointUrl, false);
            }
        }

        private void newLine() {
            this.domRegion.println("");
        }

        private static String makeRef(String object, String property) {
            assert (object != null && property != null);
            return object + "[\"" + property + "\"]";
        }

        protected void writeElement(ITag tag, String cons, String varName) {
            Map<String, Pair<String, CAstSourcePositionMap.Position>> attrs = tag.getAllAttributes();
            this.printlnIndented("function make_" + varName + "(parent) {", tag);
            this.stack.push(varName);
            this.printlnIndented("this.temp = " + cons + ';', tag);
            this.printlnIndented("this.temp(\"" + tag.getName() + "\");", tag);
            for (Map.Entry<String, Pair<String, CAstSourcePositionMap.Position>> e : attrs.entrySet()) {
                String attr = e.getKey();
                String value = (String)e.getValue().fst;
                this.writeAttribute(tag, attr, value, "this", varName);
            }
            if (tag.getName().equalsIgnoreCase("FORM")) {
                this.forms.push(tag);
                this.printlnIndented("  document.forms[document.formCount++] = this;", tag);
                this.printlnIndented("  var currentForm = this;", tag);
            }
            if (tag.getName().equalsIgnoreCase("INPUT")) {
                String type;
                String prop = attrs.containsKey("name") ? (String)attrs.get((Object)"name").fst : null;
                String string = type = attrs.containsKey("type") ? (String)attrs.get((Object)"type").fst : null;
                if (type != null && prop != null && !this.forms.isEmpty()) {
                    if (type.equalsIgnoreCase("RADIO")) {
                        if (this.sets.add((Pair<ITag, String>)Pair.make((Object)this.forms.peek(), (Object)prop))) {
                            this.printlnIndented("  " + HtmlCallBack.makeRef("currentForm", prop) + " = new Array();", tag);
                            this.printlnIndented("  " + HtmlCallBack.makeRef("currentForm", prop + "Counter") + " = 0;", tag);
                        }
                        this.printlnIndented("  " + HtmlCallBack.makeRef(HtmlCallBack.makeRef("currentForm", prop), prop + "Counter++") + " = this;", tag);
                    } else {
                        this.printlnIndented("  " + HtmlCallBack.makeRef("currentForm", prop) + " = this;", tag);
                    }
                }
                this.inputElementCallback();
            }
            assert (varName != null && !varName.isEmpty());
            this.printlnIndented(varName + " = this;", tag);
            this.printlnIndented("document." + varName + " = this;", tag);
            this.printlnIndented("parent.appendChild(this);", tag);
        }

        protected void inputElementCallback() {
        }

        protected void writeAttribute(ITag tag, String attr, String value, String varName, String varName2) {
            this.writePortletAttribute(tag, attr, value, varName);
            this.writeEventAttribute(tag, attr, value, varName, varName2);
        }

        protected void writeEventAttribute(ITag tag, String attr, String value, String varName, String varName2) {
            if (attr.length() >= 2 && attr.substring(0, 2).equals("on")) {
                this.printlnIndented(varName + '.' + attr + " = function " + tag.getName().toLowerCase() + '_' + attr + "(event) {" + value + "};", tag);
                this.writeEntrypoint(varName2 + '.' + attr + "(null);", tag.getElementPosition(), this.entrypointUrl, false);
            } else if (value != null) {
                Pair<String, Character> x = HtmlCallBack.quotify(value);
                value = (String)x.fst;
                char quote = ((Character)x.snd).charValue();
                if (attr.equals(attr.toUpperCase())) {
                    attr = attr.toLowerCase();
                }
                this.printlnIndented(varName + "['" + attr + "'] = " + quote + value + quote + ';', tag);
            }
        }

        protected void writePortletAttribute(ITag tag, String attr, String value, String varName) {
            if (attr.equals("portletid")) {
                switch (value.substring(value.length() - 4)) {
                    case "vice": {
                        this.newLine();
                        this.newLine();
                        this.printlnIndented("function cVice() { var contextVice = " + varName + "; }\ncVice();\n", tag);
                        break;
                    }
                    case "root": {
                        this.newLine();
                        this.newLine();
                        this.printlnIndented("function cRoot() { var contextRoot = " + varName + "; }\ncRoot();\n", tag);
                    }
                }
            }
        }

        protected void endElement(String name) {
            this.printlnIndented("};", (CAstSourcePositionMap.Position)null);
            if (this.stack.isEmpty()) {
                this.printlnIndented("new make_" + name + "(document);\n\n", (CAstSourcePositionMap.Position)null);
            } else {
                this.printlnIndented("new make_" + name + "(this);\n", (CAstSourcePositionMap.Position)null);
            }
        }
    }
}

