/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.js.html.FileMapping;
import com.ibm.wala.cast.js.html.IncludedPosition;
import com.ibm.wala.cast.js.html.RangeFileMapping;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;

public class NestedRangeMapping
implements FileMapping {
    private final RangeFileMapping.Range range;
    private final FileMapping innerMapping;

    public NestedRangeMapping(int rangeStart, int rangeEnd, int rangeStartingLine, int rangeEndingLine, FileMapping innerMapping) {
        assert (innerMapping != null);
        this.range = new RangeFileMapping.Range(rangeStart, rangeEnd, rangeStartingLine, rangeEndingLine);
        this.innerMapping = innerMapping;
    }

    @Override
    public IncludedPosition getIncludedPosition(final CAstSourcePositionMap.Position pos) {
        if (this.range.includes(pos)) {
            return this.innerMapping.getIncludedPosition((CAstSourcePositionMap.Position)new AbstractSourcePosition(){

                public int getFirstLine() {
                    return pos.getFirstLine() - NestedRangeMapping.this.range.getStartingLine() + 1;
                }

                public int getLastLine() {
                    return pos.getLastLine() == -1 ? -1 : pos.getLastLine() - NestedRangeMapping.this.range.getStartingLine() + 1;
                }

                public int getFirstCol() {
                    return pos.getFirstCol();
                }

                public int getLastCol() {
                    return pos.getLastCol();
                }

                public int getFirstOffset() {
                    return pos.getFirstOffset() == -1 ? -1 : pos.getFirstOffset() - NestedRangeMapping.this.range.getStart();
                }

                public int getLastOffset() {
                    return pos.getLastOffset() == -1 ? -1 : pos.getLastOffset() - NestedRangeMapping.this.range.getStart();
                }

                public URL getURL() {
                    return pos.getURL();
                }

                public Reader getReader() throws IOException {
                    return pos.getReader();
                }
            });
        }
        return null;
    }

    public String toString() {
        return this.range + "(" + this.innerMapping + ')';
    }
}

