/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.js.html.FileMapping;
import com.ibm.wala.cast.js.html.IncludedPosition;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class RangeFileMapping
implements FileMapping {
    private final Range range;
    private final URL includedURL;
    private final CAstSourcePositionMap.Position includePosition;

    public RangeFileMapping(int rangeStart, int rangeEnd, int rangeStartingLine, int rangeEndingLine, CAstSourcePositionMap.Position parentPosition, URL url) {
        assert (parentPosition != null);
        this.range = new Range(rangeStart, rangeEnd, rangeStartingLine, rangeEndingLine);
        this.includePosition = parentPosition;
        this.includedURL = url;
    }

    public String toString() {
        return this.range + ":" + this.includePosition;
    }

    @Override
    public IncludedPosition getIncludedPosition(final CAstSourcePositionMap.Position offset) {
        if (this.range.includes(offset)) {
            class Pos
            extends AbstractSourcePosition
            implements IncludedPosition {
                Pos() {
                }

                public int getFirstLine() {
                    return offset.getFirstLine() - RangeFileMapping.this.range.getStartingLine() + 1;
                }

                public int getLastLine() {
                    return offset.getLastLine() == -1 ? -1 : offset.getLastLine() - RangeFileMapping.this.range.getStartingLine() + 1;
                }

                public int getFirstCol() {
                    return offset.getFirstCol();
                }

                public int getLastCol() {
                    return offset.getLastCol();
                }

                public int getFirstOffset() {
                    return offset.getFirstOffset() == -1 ? -1 : offset.getFirstOffset() - RangeFileMapping.this.range.getStart();
                }

                public int getLastOffset() {
                    return offset.getLastOffset() == -1 ? -1 : offset.getLastOffset() - RangeFileMapping.this.range.getStart();
                }

                public URL getURL() {
                    return RangeFileMapping.this.includedURL;
                }

                public Reader getReader() throws IOException {
                    return RangeFileMapping.this.getInputStream();
                }

                @Override
                public CAstSourcePositionMap.Position getIncludePosition() {
                    return RangeFileMapping.this.includePosition;
                }

                public String toString() {
                    return "[include:" + RangeFileMapping.this.includePosition + ']' + super.toString();
                }
            }
            return new Pos();
        }
        return null;
    }

    public Reader getInputStream() throws IOException {
        return new InputStreamReader(this.includedURL.openStream());
    }

    public static final class Range {
        private final int rangeStart;
        private final int rangeEnd;
        private final int rangeStartingLine;
        private final int rangeEndingLine;

        public boolean includes(CAstSourcePositionMap.Position offset) {
            return offset.getFirstOffset() != -1 ? this.rangeStart <= offset.getFirstOffset() && offset.getLastOffset() <= this.rangeEnd : this.rangeStartingLine <= offset.getFirstLine() && (offset.getLastLine() == -1 ? offset.getFirstLine() : offset.getLastLine()) <= this.rangeEndingLine;
        }

        public Range(int rangeStart, int rangeEnd, int rangeStartingLine, int rangeEndingLine) {
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
            this.rangeStartingLine = rangeStartingLine;
            this.rangeEndingLine = rangeEndingLine;
        }

        public int getStart() {
            return this.rangeStart;
        }

        public int getEnd() {
            return this.rangeEnd;
        }

        public int getStartingLine() {
            return this.rangeStartingLine;
        }

        public int getEndingLine() {
            return this.rangeEndingLine;
        }

        public String toString() {
            return "{" + this.rangeStart + "->" + this.rangeEnd + '}';
        }
    }
}

