/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.js.html.CompositeFileMapping;
import com.ibm.wala.cast.js.html.FileMapping;
import com.ibm.wala.cast.js.html.NestedRangeMapping;
import com.ibm.wala.cast.js.html.RangeFileMapping;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;

public class SourceRegion {
    private final StringBuilder source = new StringBuilder();
    private FileMapping fileMapping;
    private int currentLine = 1;

    public void print(final String text, CAstSourcePositionMap.Position originalPos, URL url, boolean bogusURL) {
        int startOffset = this.source.length();
        this.source.append(text);
        int endOffset = this.source.length();
        int numberOfLineDrops = SourceRegion.getNumberOfLineDrops(text);
        if (originalPos != null) {
            RangeFileMapping map = bogusURL ? new RangeFileMapping(startOffset, endOffset, this.currentLine, this.currentLine + numberOfLineDrops, originalPos, url){

                @Override
                public Reader getInputStream() throws IOException {
                    return new StringReader(text);
                }
            } : new RangeFileMapping(startOffset, endOffset, this.currentLine, this.currentLine + numberOfLineDrops, originalPos, url);
            this.fileMapping = this.fileMapping == null ? map : new CompositeFileMapping(map, this.fileMapping);
        }
        this.currentLine += numberOfLineDrops;
    }

    public void println(String text, CAstSourcePositionMap.Position originalPos, URL url, boolean bogusURL) {
        this.print(text + '\n', originalPos, url, bogusURL);
    }

    public void print(String text) {
        this.print(text, null, null, true);
    }

    public void println(String text) {
        this.print(text + '\n');
    }

    public FileMapping writeToFile(PrintWriter ps) {
        ps.print(this.source.toString());
        ps.flush();
        return this.fileMapping;
    }

    public void write(SourceRegion otherRegion) {
        int rangeStart = this.source.length();
        String text = otherRegion.source.toString();
        this.source.append(text);
        int rangeEnd = this.source.length();
        int numberOfLineDrops = SourceRegion.getNumberOfLineDrops(text);
        if (otherRegion.fileMapping != null) {
            NestedRangeMapping map = new NestedRangeMapping(rangeStart, rangeEnd, this.currentLine, this.currentLine + numberOfLineDrops, otherRegion.fileMapping);
            this.fileMapping = this.fileMapping == null ? map : new CompositeFileMapping(map, this.fileMapping);
        }
        this.currentLine += numberOfLineDrops;
    }

    public void dump(PrintWriter ps) {
        ps.println(this.source.toString());
    }

    private static int getNumberOfLineDrops(String text) {
        int ret = 0;
        int i = text.indexOf(10);
        while (i != -1) {
            ++ret;
            if (i >= text.length() - 1) break;
            i = text.indexOf(10, i + 1);
        }
        return ret;
    }
}

