/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html;

import com.ibm.wala.cast.ir.translator.TranslatorToCAst;
import com.ibm.wala.cast.js.html.DefaultSourceExtractor;
import com.ibm.wala.cast.js.html.DomLessSourceExtractor;
import com.ibm.wala.cast.js.html.IHtmlParserFactory;
import com.ibm.wala.cast.js.html.IdentityUrlResolver;
import com.ibm.wala.cast.js.html.JSSourceExtractor;
import com.ibm.wala.cast.js.html.MappedSourceModule;
import com.ibm.wala.cast.js.html.jericho.JerichoHtmlParser;
import com.ibm.wala.util.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import java.util.function.Supplier;

public class WebUtil {
    public static final String preamble = "preamble.js";
    private static IHtmlParserFactory factory = () -> new JerichoHtmlParser();

    public static void setFactory(IHtmlParserFactory factory) {
        WebUtil.factory = factory;
    }

    public static Pair<Set<MappedSourceModule>, File> extractScriptFromHTML(URL url, Supplier<JSSourceExtractor> fSourceExtractor) throws TranslatorToCAst.Error {
        try {
            JSSourceExtractor extractor = fSourceExtractor.get();
            Set<MappedSourceModule> sources = extractor.extractSources(url, factory.getParser(), new IdentityUrlResolver());
            return Pair.make(sources, (Object)extractor.getTempFile());
        }
        catch (IOException e) {
            throw new RuntimeException("trouble with " + url, e);
        }
    }

    public static void main(String[] args) throws MalformedURLException, TranslatorToCAst.Error {
        System.err.println(WebUtil.extractScriptFromHTML(new URL(args[0]), Boolean.parseBoolean(args[1]) ? DefaultSourceExtractor.factory : DomLessSourceExtractor.factory));
    }

    public static Reader getStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        return new InputStreamReader(conn.getInputStream());
    }
}

