/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.js.html.jericho;

import com.ibm.wala.cast.js.html.ITag;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Pair;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.htmlparser.jericho.Attribute;
import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.Segment;

public class JerichoTag
implements ITag {
    private final Element innerElement;
    private final String sourceFile;
    private Map<String, Pair<String, CAstSourcePositionMap.Position>> allAttributes = null;

    public JerichoTag(Element root, String sourceFile) {
        this.innerElement = root;
        this.sourceFile = sourceFile;
    }

    private CAstSourcePositionMap.Position getPosition(final Segment e) {
        return new AbstractSourcePosition(){

            public int getFirstLine() {
                return e.getSource().getRowColumnVector(e.getBegin()).getRow();
            }

            public int getLastLine() {
                return e.getSource().getRowColumnVector(e.getEnd()).getRow();
            }

            public int getFirstCol() {
                return -1;
            }

            public int getLastCol() {
                return -1;
            }

            public int getFirstOffset() {
                return e.getBegin();
            }

            public int getLastOffset() {
                return e.getEnd();
            }

            public URL getURL() {
                try {
                    return new URL("file://" + JerichoTag.this.sourceFile);
                }
                catch (MalformedURLException e2) {
                    return null;
                }
            }

            public Reader getReader() throws IOException {
                return new FileReader(JerichoTag.this.sourceFile);
            }
        };
    }

    private Map<String, Pair<String, CAstSourcePositionMap.Position>> makeAllAttributes() {
        HashMap result = HashMapFactory.make();
        if (this.innerElement.getStartTag().getAttributes() != null) {
            for (Attribute a : this.innerElement.getStartTag().getAttributes()) {
                result.put(a.getName().toLowerCase(), Pair.make((Object)a.getValue(), (Object)this.getPosition(a.getValueSegment())));
            }
        }
        return result;
    }

    @Override
    public Map<String, Pair<String, CAstSourcePositionMap.Position>> getAllAttributes() {
        if (this.allAttributes == null) {
            this.allAttributes = this.makeAllAttributes();
        }
        return this.allAttributes;
    }

    @Override
    public Pair<String, CAstSourcePositionMap.Position> getAttributeByName(String name) {
        if (this.allAttributes == null) {
            this.allAttributes = this.makeAllAttributes();
        }
        return this.allAttributes.get(name.toLowerCase());
    }

    public Pair<Integer, String> getBodyText() {
        Segment content = this.innerElement.getContent();
        Integer lineNum = this.innerElement.getSource().getRow(content.getBegin());
        String nl = content.getSource().getNewLine();
        String body = nl == null ? content.toString() : content.toString().replace(nl, "\n");
        return Pair.make((Object)lineNum, (Object)body);
    }

    public String getFilePath() {
        return this.sourceFile;
    }

    @Override
    public String getName() {
        return this.innerElement.getName();
    }

    public String toString() {
        return this.innerElement.toString();
    }

    @Override
    public CAstSourcePositionMap.Position getElementPosition() {
        return this.getPosition((Segment)this.innerElement);
    }

    @Override
    public CAstSourcePositionMap.Position getContentPosition() {
        return this.getPosition(this.innerElement.getContent());
    }
}

